<?php
session_set_cookie_params(0); 
session_start();
$session_timeout = 4800;
if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $session_timeout)) {
    session_unset();
    session_destroy();
    header("Location: login.php");
    exit;
}
$_SESSION['last_activity'] = time();

if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
  <html>
  <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>UI GreenMetric Dashboard</title>
    <link rel="stylesheet" href="dashboard.css">
  </head>
  <body>
    <div class="topnav">
      <a href="./home.php">Home</a>
      <a href="./dashboard_si.php">SI</a>
      <a class="active" href="./dashboard_ec.php">EC</a>
      <a href="./dashboard_ws.php">WS</a>
      <a href="./dashboard_wr.php">WR</a>
      <a href="./dashboard_tr.php">TR</a>
      <a href="./dashboard_ed.php">ED</a>
      <a href="./about.php">About</a>
    </div>

    <h2>Welcome, <?php echo $_SESSION['username']; ?>!</h2>
    <a href="logout.php" style="color: rgb(255, 255, 255)">Logout</a>
    <h1>UI GreenMetric - Monitoring & Evaluation Dashboard</h1>
    <br>
    <h2>Energy and Climate Change (EC)</h2>
    <br>
    <div class="dashboard">
      <div class="card">
        <h5>EC.1</h5>
        <h6>Energy efficient appliances usage</h6>
        <div class="value" id="ec1_value"></div>
        <div class="evidence">
          <input id="value_2_1_1"  type="number" step="0.001" placeholder="number of energy-efficient appliances"/>
          <input id="value_2_1_2"  type="number" step="0.001" placeholder="number of conventional ones"/>
          <br>
          <button onclick="output_ec1()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_ec1"></p>
        </div>
        <script>
          function output_ec1(){
            var value1_ec1 = document.getElementById('value_2_1_1').value;
            var value2_ec1 = document.getElementById('value_2_1_2').value;
            document.getElementById('result_ec1').innerHTML = ((parseFloat(value1_ec1)-parseFloat(value2_ec1))/parseFloat(value1_ec1))*100 + "%";
            var progressBar = document.getElementById('progress_ec1');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_ec1';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_ec1_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_ec1').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_ec1_inner');
            }
            var percent = ((parseFloat(value1_ec1)-parseFloat(value2_ec1))/parseFloat(value1_ec1))*100;
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(0) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }
            var ec1ValueEl = document.getElementById('ec1_value');
            var resEl = document.getElementById('result_ec1');
            var evidenceText = '';
            if (!isNaN(percent) && isFinite(percent)) {
              ec1ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 75) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 50) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 25) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent >= 1) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent < 1) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              ec1ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }

          }
        </script>
      </div>

      <div class="card">
        <h5>EC.2</h5>
        <h6>Smart building implementation</h6>
        <div class="value" id="ec2_value"></div>
        <div class="evidence">
          <input id="value_2_2" type="number" step="0.001" placeholder="Total campus' smart building area (square meters)"/>
          <br>
          <input id="value_1_7" type="number" step="0.001" placeholder="Total campus buildings area (square meters)"/>
          <br>
          <button onclick="output_ec2()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_ec2"></p>
        </div>
        <script>
          function output_ec2(){
            var value1_ec2 = document.getElementById('value_2_2').value;
            var value2_ec2 = document.getElementById('value_1_7').value;
            document.getElementById('result_ec2').innerHTML = (parseFloat(value1_ec2)/parseFloat(value2_ec2))*100 + "%";
            var progressBar = document.getElementById('progress_ec2');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_ec2';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_ec2_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_ec2').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_ec2_inner');
            }
            var percent = (parseFloat(value1_ec2)/parseFloat(value2_ec2))*100;
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(0) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }
            var ec2ValueEl = document.getElementById('ec2_value');
            var resEl = document.getElementById('result_ec2');
            var evidenceText = '';
            if (!isNaN(percent) && isFinite(percent)) {
              ec2ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(3) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              ec2ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }

          }
        </script>
      </div>

      <div class="card">
        <h5>EC.3</h5>
        <h6>Number of renewable energy sources on campus</h6>
        <div class="value" id="ec3_value"></div>
        <div class="evidence">
          <input id="value_2_4" type="number" min="0" max="65535" placeholder="Number of renewable energy sources on campus"/>
          <br>
          <button onclick="output_ec3()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_ec3"></p>
        </div>
        <script>
          function output_ec3(){
            var value1_ec3 = document.getElementById('value_2_4').value;
            document.getElementById('result_ec3').innerHTML = parseInt(value1_ec3) + " sources";
            var progressBar = document.getElementById('progress_ec3');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_ec3';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_ec3_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_ec3').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_ec3_inner');
            }
            var percent = parseInt(value1_ec3)/65535*100;
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(0) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }
          }
        </script>
      </div>

      <div class="card">
        <h5>EC.4</h5>
        <h6>Total electricity usage divided by total campus' population (kWh per person)</h6>
        <div class="value" id="ec4_value"></div>
        <div class="evidence">
          <input id="value_2_6" type="number" step="0.001" placeholder="Total campus electricity usage (kWh)"/>
          <br>
          <input id="value_1_12_2" type="number" step="0.001" placeholder="Total number of regular students"/>
          <br>
          <input id="value_1_14_2" type="number" step="0.001" placeholder="Total number of academic and non-academic staff"/>
          <br>
          <button onclick="output_ec4()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_ec4"></p>
        </div>
        <script>
          function output_ec4(){
            var value1_ec4 = document.getElementById('value_2_6').value;
            var value2_ec4 = document.getElementById('value_1_12_2').value;
            var value3_ec4 = document.getElementById('value_1_14_2').value;
            document.getElementById('result_ec4').innerHTML = parseFloat(value1_ec4)/(parseFloat(value2_ec4)+parseFloat(value3_ec4)) + " kWh";
            var progressBar = document.getElementById('progress_ec4');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_ec4';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_ec4_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_ec4').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_ec4_inner');
            }
            var percent = (parseFloat(value1_ec4)/(parseFloat(value2_ec4)+parseFloat(value3_ec4)))/100;
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(0) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }
            var ec4ValueEl = document.getElementById('ec4_value');
            var resEl = document.getElementById('result_ec4');
            var evidenceText = '';
            if (!isNaN(percent) && isFinite(percent)) {
              ec4ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              ec4ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }

          }
        </script>
      </div>

      <div class="card">
        <h5>EC.5</h5>
        <h6>The ratio of renewable energy production divided by total energy usage per year</h6>
        <div class="value" id="ec5_value"></div>
        <div class="evidence">
          <input type="radio" name="options_2_8">None
          <br>
          <input type="radio" name="options_2_8">Bio diesel
          <br>
          <input type="radio" name="options_2_8">Clean biomass
          <br>
          <input type="radio" name="options_2_8">Solar power
          <br>
          <input type="radio" name="options_2_8">Geothermal
          <br>
          <input type="radio" name="options_2_8">Wind power
          <br>
          <input type="radio" name="options_2_8">Hydropower
          <br>
          <input type="radio" name="options_2_8">Combine Heat and Power
          <br>
          <input id="value_2_5" type="number" step="0.001" placeholder="Total renewable energy production (kWh)"/>
          <br>
          <input id="value_2_8" type="number" step="0.001" placeholder="The ratio of renewable energy production divided by total energy usage per year"/>
          <button onclick="output_ec5()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_ec5"></p>
        </div>
        <script>
          function output_ec5(){
            var value1_ec5 = document.getElementById('value_2_5').value;
            var value2_ec5 = document.getElementById('value_2_8').value;
            document.getElementById('result_ec5').innerHTML = parseFloat(value1_ec5)/parseFloat(value2_ec5) + " kWh";
            var progressBar = document.getElementById('progress_ec5');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_ec5';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_ec5_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_ec5').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_ec5_inner');
            }
            var percent = (parseFloat(value1_ec5)/parseFloat(value2_ec5))*100;
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(0) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }
            var ec5ValueEl = document.getElementById('ec5_value');
            var resEl = document.getElementById('result_ec5');
            var evidenceText = '';
            if (!isNaN(percent) && isFinite(percent)) {
              ec5ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              ec5ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }

          }
        </script>
      </div>

      <div class="card">
        <h5>EC.6</h5>
        <h6>Elements of green building implementation as reflected in all buildings</h6>
        <div class="value" id="ec6_value"></div>
        <div class="evidence">
          <input id="value_2_9" type="number" min="0" max="65535" placeholder="Elements of green building implementation as reflected in all buildings"/>
          <br>
          <button onclick="output_ec6()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_ec6"></p>
        </div>
        <script>
          function output_ec6() {
            var value1_ec6 = document.getElementById('value_2_9').value;
            document.getElementById('result_ec6').innerHTML = parseInt(value1_ec6) + " element(s)";
            var progressBar = document.getElementById('progress_ec6');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_ec6';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_ec6_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_ec6').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_ec6_inner');
            }
            var percent = parseInt(value1_ec6)/65535*100;
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(0) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }
          }
            var ec6ValueEl = document.getElementById('ec6_value');
            var resEl = document.getElementById('result_ec6');
            var evidenceText = '';
            if (!isNaN(percent) && isFinite(percent)) {
              ec6ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              ec6ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }

        </script>
      </div>

      <div class="card">
        <h5>EC.7</h5>
        <h6>Greenhouse gas emission reduction program</h6>
        <div class="value" id="ec7_value"></div>
        <div class="evidence">
          
          <input type="radio" name="options_ec7">None. Please select this option if the reduction program is needed, but nothing has been done.
          <br>
          <input type="radio" name="options_ec7">Program in preparation
          <br>
          <input type="radio" name="options_ec7">Program(s) aims to reduce one out of three scopes emissions (Scope 1 or 2 or 3)
          <br>
          <input type="radio" name="options_ec7">Program(s) aims to reduce two out of three scopes emissions (Scope 1 and 2 or Scope 1 and 3 or Scope 2 and 3)
          <br>
          <input type="radio" name="options_ec7">Program(s) aims to reduce all three scopes emissions (Scope 1, 2, and 3)
          <br>
        
          <strong>Evidence</strong>
        </div>
        <script>

        </script>
      </div>

      <div class="card">
        <h5>EC.8</h5>
        <h6>Total carbon footprint divided by total campus' population (metric tons per person)</h6>
        <div class="value" id="ec8_value"></div>
        <div class="evidence">
          <input id="value_2_11" type="number" placeholder="Total campus carbon footprint (metric tons CO2e)"/>
          <br>
          <input id="value_1_12_3" type="number" placeholder="Total number of regular students"/>
          <br>
          <input id="value_1_14_3" type="number" placeholder="Total number of academic and non-academic staff"/>
          <br>
          <button onclick="output_ec8()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_ec8"></p>
        </div>
        <script>
          function output_ec8(){
            var value1_ec8 = document.getElementById('value_2_11').value;
            var value2_ec8 = document.getElementById('value_1_12_3').value;
            var value3_ec8 = document.getElementById('value_1_14_3').value;
            document.getElementById('result_ec8').innerHTML = (parseFloat(value1_ec8)/(parseFloat(value2_ec8)+parseFloat(value3_ec8))) + " metric ton(s)";
            var progressBar = document.getElementById('progress_ec8');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_ec8';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_ec8_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_ec8').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_ec8_inner');
            }
            var percent = (parseFloat(value1_ec8)/(parseFloat(value2_ec8)+parseFloat(value3_ec8)));
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(0) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }
            var ec8ValueEl = document.getElementById('ec8_value');
            var resEl = document.getElementById('result_ec8');
            var evidenceText = '';
            if (!isNaN(percent) && isFinite(percent)) {
              ec8ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              ec8ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }

          }
        </script>
      </div>

      <div class="card">
        <h5>EC.9</h5>
        <h6>Number of innovative program(s) in energy and climate change</h6>
        <div class="value" id="ec9_value"></div>
        <div class="evidence">
          <input id="value_2_13" type="number" min="0" max="65535" placeholder="Number of innovative program(s) in energy and climate change"/>
          <br>
          <button onclick="output_ec9()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_ec9"></p>
        </div>
        <script>
          function output_ec9(){
            var value1_ec9 = document.getElementById('value_2_13').value;
            document.getElementById('result_ec9').innerHTML = parseInt(value1_ec9) + " program(s)";
            var progressBar = document.getElementById('progress_ec9');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_ec9';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_ec9_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_ec9').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_ec9_inner');
            }
            var percent = parseInt(value1_ec9)/65535*100;
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(0) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }
            var ec9ValueEl = document.getElementById('ec9_value');
            var resEl = document.getElementById('result_ec9');
            var evidenceText = '';
            if (!isNaN(percent) && isFinite(percent)) {
              ec9ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              ec9ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }

          }
        </script>
      </div>

      <div class="card">
        <h5>EC.10</h5>
        <h6>Impactful university program(s) on climate change</h6>
        <div class="value" id="ec10_value"></div>
        <div class="evidence">
          <input type="radio" name="options_ec10">None
          <br>
          <input type="radio" name="options_ec10">Program in preparation
          <br>
          <input type="radio" name="options_ec10">Provide training, educational materials, seminars/conferences, and activities which are implemented by surrounding communities.
          <br>
          <input type="radio" name="options_ec10">Provide training, educational materials, seminars/conferences, and activities which are implemented by communities at the national level.
          <br>
          <input type="radio" name="options_ec10">Provide training, educational materials, seminars/conferences, and activities which are implemented by communities at the international level.
          <br>
          <input id="value_2_14" type="text" placeholder="Some text..." />
          <br>
          <button onclick="output_ec10()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_ec10"></p>
        </div>
        <script>
          function output_ec10(){
            var value1_ec10 = document.getElementById('value_2_14').value;
            document.getElementById('result_ec10').innerHTML = value1_ec10;
          }
        </script>
      </div>

      <div class="card">
        <h5>EC.11</h5>
        <h6>Planning, implementation, monitoring and/or evaluation of all programs related to Energy and Climate Change through the utilization of Information and Communication Technology (ICT)</h6>
        <div class="value" id="ec11_value"></div>
        <div class="evidence">
          <input type="radio" name="options_ec11">None
          <br>
          <input type="radio" name="options_ec11">The program is currently in the planning stage
          <br>
          <input type="radio" name="options_ec11">Program has been implemented
          <br>
          <input type="radio" name="options_ec11">Program has been implemented and evaluated
          <br>
          <input type="radio" name="options_ec11">Program has been implemented, evaluated, and is currently revised
          <br>
          <strong>Evidence</strong>
          <p id="result_ec11"></p>
        </div>
        <script>
          const radio_ec11 = document.querySelectorAll('input[name="options_ec11"]');
          const result_ec11 = document.getElementById('result_ec11');
          radio_ec11.forEach(radio => {
            radio.addEventListener('change', function() {
              result_ec11.innerHTML = this.nextSibling.textContent.trim();
            });
          });
        </script>
      </div>
    </div>
    <br>
    </div>
  </body>
</html>
