<?php
session_set_cookie_params(0); 
session_start();
$session_timeout = 4800;
if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $session_timeout)) {
    session_unset();
    session_destroy();
    header("Location: login.php");
    exit;
}
$_SESSION['last_activity'] = time();

if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
  <html>
  <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>UI GreenMetric Dashboard</title>
    <link rel="stylesheet" href="dashboard.css">
  </head>
  <body>
    <div class="topnav">
      <a href="./home.php">Home</a>
      <a href="./dashboard_si.php">SI</a>
      <a href="./dashboard_ec.php">EC</a>
      <a href="./dashboard_ws.php">WS</a>
      <a href="./dashboard_wr.php">WR</a>
      <a href="./dashboard_tr.php">TR</a>
      <a class="active" href="./dashboard_ed.php">ED</a>
      <a href="./about.php">About</a>
    </div>

    <h2>Welcome, <?php echo $_SESSION['username']; ?>!</h2>
    <a href="logout.php" style="color: rgb(255, 255, 255)">Logout</a>
    <h1>UI GreenMetric - Monitoring & Evaluation Dashboard</h1>
    <br>
    <h2>Education and Research (ED)</h2>
    <br>
    <div class="dashboard">
      <div class="card">
        <h5>ED.1</h5>
        <h6>The ratio of sustainability courses to total courses/subjects</h6>
        <div class="value" id="ed1_value"></div>
        <div class="evidence">
          <input id="value_6_1" type="number" min="0" max="65535" placeholder="Number of courses/subjects related to sustainability offered"/>
          <br>
          <input id="value_6_2" type="number" min="0" max="65535" placeholder="Total number of courses/subjects offered"/>
          <br>
          <button onclick="output_ed1()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_ed1"></p>
        </div>
        <script>
          function output_ed1(){
            var value1_ed1 = document.getElementById('value_6_1').value;
            var value2_ed1 = document.getElementById('value_6_2').value;
            document.getElementById('result_ed1').innerHTML = (parseInt(value1_ed1)/parseInt(value2_ed1))*100 + "%";
            var progressBar = document.getElementById('progress_ed1');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_ed1';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_ed1_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_ed1').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_ed1_inner');
            }
            var percent = (parseInt(value1_ed1)/parseInt(value2_ed1))*100;
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(2) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }
            var si4ValueEl = document.getElementById('si4_value');
            var resEl = document.getElementById('result_si4');
            var evidenceText = '';
            if (!isNaN(percent) && isFinite(percent)) {
              si4ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              ed1ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }
          }
        </script>
      </div>

      <div class="card">
        <h5>ED.2</h5>
        <h6>The ratio of sustainability research funding to total research funding</h6>
        <div class="value" id="ed2_value"></div>
        <div class="evidence">
          <input id="value_6_4" type="number" min="0" placeholder="Total research funds dedicated to sustainability research (in US Dollars)"/>
          <br>
          <input id="value_6_5" type="number" min="0" placeholder="Total research funds (in US Dollars)"/>
          <br>
          <button onclick="output_ed2()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_ed2"></p>
        </div>
        <script>
          function output_ed2(){
            var value1_ed2 = document.getElementById('value_6_4').value;
            var value2_ed2 = document.getElementById('value_6_5').value;
            document.getElementById('result_ed2').innerHTML = (parseFloat(value1_ed2)/parseFloat(value2_ed2))*100 + "%";
            var progressBar = document.getElementById('progress_ed2');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_ed2';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_ed2_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_ed2').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_ed2_inner');
            }
            var percent = (parseFloat(value1_ed2)/parseFloat(value2_ed2))*100;
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(2) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }
            var si4ValueEl = document.getElementById('si4_value');
            var resEl = document.getElementById('result_si4');
            var evidenceText = '';
            if (!isNaN(percent) && isFinite(percent)) {
              si4ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              ed2ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }
          }
        </script>
      </div>

      <div class="card">
        <h5>ED.3</h5>
        <h6>Ratio of scholarly publications on sustainability to lecturers and researchers on campus in one year period</h6>
        <div class="value" id="ed3_value"></div>
        <div class="evidence">
          <input id="value_6_8" type="number" min="0" max="65535" placeholder="Number of lecturers and researchers on campus in one year period "/>
          <br>
          <input id="value_6_9" type="number" min="0" max="65535" placeholder="Number of scholarly publications on sustainability in one year period"/>
          <br>
          <button onclick="output_ed3()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_ed3"></p>
        </div>
        <script>
          function output_ed3(){
            var value1_ed3 = document.getElementById('value_6_8').value;
            var value2_ed3 = document.getElementById('value_6_9').value;
            document.getElementById('result_ed3').innerHTML = parseInt(value2_ed3)/parseInt(value1_ed3);
            var progressBar = document.getElementById('progress_ed3');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_ed3';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_ed3_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_ed3').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_ed3_inner');
            }
            var percent = (parseInt(value2_ed3)/parseInt(value1_ed3))*100;
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(2) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }
            var ed34ValueEl = document.getElementById('ed3_value');
            var resEl = document.getElementById('result_ed3');
            var evidenceText = '';
            if (!isNaN(percent) && isFinite(percent)) {
              ed3ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              ed3ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }
          }
        </script>
      </div>

      <div class="card">
        <h5>ED.4</h5>
        <h6>Number of events related to sustainability (environment)</h6>
        <div class="value" id="ed4_value"></div>
        <div class="evidence">
          <input id="value_6_11" type="number" min="0" max="65535" placeholder="Number of events related to sustainability (environment)"/>
          <br>
          <button onclick="output_ed4()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_ed4"></p>
        </div>
        <script>
          function output_ed4(){
            var value1_ed4 = document.getElementById('value_6_11').value;
            document.getElementById('result_ed4').innerHTML = parseInt(value1_ed4) + " event(s)";
            var progressBar = document.getElementById('progress_ed4');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_ed4';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_ed4_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_ed4').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_ed4_inner');
            }
            var percent = parseInt(value1_ed4);
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(0) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }
            var si4ValueEl = document.getElementById('si4_value');
            var resEl = document.getElementById('result_si4');
            var evidenceText = '';
            if (!isNaN(percent) && isFinite(percent)) {
              si4ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              ed4ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }
          }
        </script>
      </div>

      <div class="card">
        <h5>ED.5</h5>
        <h6>Number of activities organized by student organizations related to sustainability per year</h6>
        <div class="value" id="ed5_value"></div>
        <div class="evidence">
          <input id="value_6_12" type="number" min="0" max="65535" placeholder="Number of activities organized by student organizations related to sustainability per year"/>
          <br>
          <button onclick="output_ed5()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_ed5"></p>
        </div>
        <script>
          function output_ed5(){
            var value1_ed5 = document.getElementById('value_6_12').value;
            document.getElementById('result_ed5').innerHTML = parseInt(value1_ed5) + " activity(ies)";
            var progressBar = document.getElementById('progress_ed5');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_ed5';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_ed5_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_ed5').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_ed5_inner');
            }
            var percent = parseInt(value1_ed5);
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(0) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }
            var ed5ValueEl = document.getElementById('ed5_value');
            var resEl = document.getElementById('result_ed5');
            var evidenceText = '';
            if (!isNaN(percent) && isFinite(percent)) {
              ed5ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              ed5ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }
          }
        </script>
      </div>

      <div class="card">
        <h5>ED.6</h5>
        <h6>University-run sustainability website</h6>
        <div class="value" id="ed6_value"></div>
        <div class="evidence">
          <input type="radio" name="options_ed6">Not available
          <br>
          <input type="radio" name="options_ed6">Website in progress or under construction
          <br>
          <input type="radio" name="options_ed6">Website is available and accessible
          <br>
          <input type="radio" name="options_ed6">Website is available, accessible, and updated occasionally
          <br>
          <input type="radio" name="options_ed6">Website is available, accessible, and updated regularly
          <br>
          <strong>Evidence</strong>
          <p id="result_ed6"></p>
        </div>
        <script>
          const radio_ed6 = document.querySelectorAll('input[name="options_ed6"]');
          const result_ed6 = document.getElementById('result_ed6');
          radio_ed6.forEach(radio => {
            radio.addEventListener('change', function() {
              result_ed6.innerHTML = this.nextSibling.textContent.trim();
            });
          });
        </script>
      </div>

      <div class="card">
        <h5>ED.7</h5>
        <h6>Sustainability report</h6>
        <div class="value" id="ed7_value"></div>
        <div class="evidence">
          <input type="radio" name="options_ed7">Not available
          <br>
          <input type="radio" name="options_ed7">Sustainability report is in preparation
          <br>
          <input type="radio" name="options_ed7">Available but not publicly accessible
          <br>
          <input type="radio" name="options_ed7">Sustainability report is accessible and published occasionally
          <br>
          <input type="radio" name="options_ed7">Sustainability report is accessible and published annually
          <br>
          <strong>Evidence</strong>
          <p id="result_ed7"></p>
        </div>
        <script>
          const radio_ed7 = document.querySelectorAll('input[name="options_ed7"]');
          const result_ed7 = document.getElementById('result_ed7');
          radio_ed7.forEach(radio => {
            radio.addEventListener('change', function() {
              result_ed7.innerHTML = this.nextSibling.textContent.trim();
            });
          });
        </script>
      </div>

      <div class="card">
        <h5>ED.8</h5>
        <h6>Number of cultural activities on campus</h6>
        <div class="value" id="ed8_value"></div>
        <div class="evidence">
          <input id="value_6_17" type="number" min="0" max="65535" placeholder="Number of cultural activities on campus"/>
          <br>
          <button onclick="output_ed8()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_ed8"></p>
        </div>
        <script>
          function output_ed8(){
            var value1_ed8 = document.getElementById('value_6_17').value;
            document.getElementById('result_ed8').innerHTML = parseInt(value1_ed8) + " event(s) per year";
            var progressBar = document.getElementById('progress_ed8');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_ed8';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_ed8_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_ed8').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_ed8_inner');
            }
            var percent = parseInt(value1_ed8);
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(0) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }
            var ed8ValueEl = document.getElementById('ed8_value');
            var resEl = document.getElementById('result_ed8');
            var evidenceText = '';
            if (!isNaN(percent) && isFinite(percent)) {
              ed8ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              ed8ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }
          }
        </script>
      </div>

      <div class="card">
        <h5>ED.9</h5>
        <h6>Number of university sustainability program(s) with international collaborations</h6>
        <div class="value" id="ed9_value"></div>
        <div class="evidence">
          <input id="value_6_18" type="number" min="0" max="65535" placeholder="Number of university sustainability program(s) with international collaborations"/>
          <br>
          <button onclick="output_ed9()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_ed9"></p>
        </div>
        <script>
          function output_ed9(){
            var value1_ed9 = document.getElementById('value_6_18').value;
            document.getElementById('result_ed9').innerHTML = parseInt(value1_ed9) + " program(s) per year";
            var progressBar = document.getElementById('progress_ed9');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_ed9';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_ed9_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_ed9').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_ed9_inner');
            }
            var percent = parseInt(value1_ed9);
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(0) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }
            var si4ValueEl = document.getElementById('si4_value');
            var resEl = document.getElementById('result_si4');
            var evidenceText = '';
            if (!isNaN(percent) && isFinite(percent)) {
              si4ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              si9ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }
          }
        </script>
      </div>

      <div class="card">
        <h5>ED.10</h5>
        <h6>Number of community services related to sustainability organized by university and involving students</h6>
        <div class="value" id="ed10_value"></div>
        <div class="evidence">
          <input id="value_6_19" type="number" min="0" max="65535" placeholder="Number of community services related to sustainability organized by university and involving students"/>
          <br>
          <button onclick="output_ed10()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_ed10"></p>
        </div>
        <script>
          function output_ed10(){
            var value1_ed10 = document.getElementById('value_6_19').value;
            document.getElementById('result_ed10').innerHTML = parseInt(value1_ed10) + " project(s) per year";
            var progressBar = document.getElementById('progress_ed10');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_ed10';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_ed10_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_ed10').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_ed10_inner');
            }
            var si4ValueEl = document.getElementById('si4_value');
            var resEl = document.getElementById('result_si4');
            var evidenceText = '';
            if (!isNaN(percent) && isFinite(percent)) {
              si4ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              ed10ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }
          }
        </script>
      </div>

      <div class="card">
        <h5>ED.11</h5>
        <h6>Number of sustainability-related startups</h6>
        <div class="value" id="ed11_value"></div>
        <div class="evidence">
          <input id="value_6_20" type="number" min="0" max="65535" placeholder="Number of sustainability-related startups"/>
          <br>
          <button onclick="output_ed11()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_ed11"></p>
        </div>
        <script>
          function output_ed11(){
            var value1_ed11 = document.getElementById('value_6_20').value;
            document.getElementById('result_ed11').innerHTML = parseInt(value1_ed11) + " startup(s)";
            var progressBar = document.getElementById('progress_ed11');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_ed11';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_ed11_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_ed11').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_ed11_inner');
            }
            var percent = parseInt(value1_ed11);
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(0) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }
            var si4ValueEl = document.getElementById('si4_value');
            var resEl = document.getElementById('result_si4');
            var evidenceText = '';
            if (!isNaN(percent) && isFinite(percent)) {
              si4ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              ed11ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }
          }
        </script>
      </div>

      <div class="card">
        <h5>ED.12</h5>
        <h6>Percentage of number of graduates with green jobs (for the last 3 years)</h6>
        <div class="value" id="ed12_value"></div>
        <div class="evidence">
          <input id="value_6_23" type="number" min="0" max="65535" placeholder="Total number of graduates with green jobs (for the last 3 years)"/>
          <br>
          <input id="value_1_12_6" type="number" min="0" max="65535" placeholder="Total number of graduates (for the last 3 years)"/>
          <br>
          <button onclick="output_ed12()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_ed12"></p>
        </div>
        <script>
          function output_ed12(){
            var value1_ed12 = document.getElementById('value_6_23').value;
            var value2_ed12 = document.getElementById('value_1_12_6').value;
            document.getElementById('result_ed12').innerHTML = (parseInt(value1_ed12)/parseInt(value2_ed12))*100 + "%";
            var progressBar = document.getElementById('progress_ed12');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_ed12';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_ed12_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_ed12').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_ed12_inner');
            }
            var percent = (parseInt(value1_ed12)/parseInt(value2_ed12))*100;
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(2) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }
            var si4ValueEl = document.getElementById('si4_value');
            var resEl = document.getElementById('result_si4');
            var evidenceText = '';
            if (!isNaN(percent) && isFinite(percent)) {
              si4ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              ed12ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }
          }
        </script>
      </div>

      <div class="card">
        <h5>ED.13</h5>
        <h6>Availability of unit or office that coordinate sustainability on campus</h6>
        <div class="value" id="ed13_value"></div>
        <div class="evidence">
          <input type="radio" name="options_ed13">Ad-hoc / task force 
          <br>
          <input type="radio" name="options_ed13">Unit or office in development 
          <br>
          <input type="radio" name="options_ed13">Unit or office with university leader decree of establishment, structure and duties at early stage 
          <br>
          <input type="radio" name="options_ed13">Unit or office with university leader decree of establishment, structure and duties has been operational 
          <br>
          <input type="radio" name="options_ed13">Unit or office with university leader decree of establishment, structure and duties has been operational and lead the university implementation of sustainability  
          <br>
          <strong>Evidence</strong>
          <p id="result_ed13"></p>
        </div>
        <script>
          const radio_ed13 = document.querySelectorAll('input[name="options_ed13"]');
          const result_ed13 = document.getElementById('result_ed13');
          radio_ed13.forEach(radio => {
            radio.addEventListener('change', function() {
              result_ed13.innerHTML = this.nextSibling.textContent.trim();
            });
          });
        </script>
      </div>

      <div class="card">
        <h5>ED.14</h5>
        <h6>Planning, implementation, monitoring and/or evaluation of university governance through the utilization of Information and Communication Technology (ICT)</h6>
        <div class="value" id="ed14_value"></div>
        <div class="evidence">
          <input type="radio" name="options_ed14">None 
          <br>
          <input type="radio" name="options_ed14">The program is currently in the planning stage 
          <br>
          <input type="radio" name="options_ed14">Program has been implemented 
          <br>
          <input type="radio" name="options_ed14">Program has been implemented and evaluated 
          <br>
          <input type="radio" name="options_ed14">Program has been implemented, evaluated, and is currently revised 
          <br>
          <strong>Evidence</strong>
          <p id="result_ed14"></p>
        </div>
        <script>
          const radio_ed14 = document.querySelectorAll('input[name="options_ed14"]');
          const result_ed14 = document.getElementById('result_ed14');
          radio_ed14.forEach(radio => {
            radio.addEventListener('change', function() {
              result_ed14.innerHTML = this.nextSibling.textContent.trim();
            });
          });
        </script>
      </div>
    </div>
  </body>
</html>
