<?php
session_set_cookie_params(0); 
session_start();
$session_timeout = 4800;
if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $session_timeout)) {
    session_unset();
    session_destroy();
    header("Location: login.php");
    exit;
}
$_SESSION['last_activity'] = time();

if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
  <html>
  <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>UI GreenMetric Dashboard</title>
    <link rel="stylesheet" href="dashboard.css">
  </head>
  <body>
    <div class="topnav">
      <a href="./home.php">Home</a>
      <a class="active" href="./dashboard_si.php">SI</a>
      <a href="./dashboard_ec.php">EC</a>
      <a href="./dashboard_ws.php">WS</a>
      <a href="./dashboard_wr.php">WR</a>
      <a href="./dashboard_tr.php">TR</a>
      <a href="./dashboard_ed.php">ED</a>
      <a href="./about.php">About</a>
    </div>

    <h2>Welcome, <?php echo $_SESSION['username']; ?>!</h2>
    <a href="logout.php" style="color: rgb(255, 255, 255)">Logout</a>
    <h1>UI GreenMetric - Monitoring & Evaluation Dashboard</h1>
    <br>
    <h2>Setting and Infrastructure (SI)</h2>
    <br>
    <div class="dashboard">
      <div class="card">
        <h5>SI.1</h5>
        <h6>The ratio of open space area to total area</h6>
        <div class="value" id="si1_value"></div>
        <div class="evidence">
          <input id="value_1_5" type="number" min="0" step="0.001" placeholder="Total campus area (square meters)"/>
          <br>
          <input id="value_1_6" type="number" min="0" step="0.001" placeholder="Total campus ground floor area of buildings (square meters)"/>
          <br>
          <button onclick="output_si1()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_si1"></p>
        </div>
        <script>
          function output_si1(){
            var value1_si1 = document.getElementById('value_1_5').value;
            var value2_si1 = document.getElementById('value_1_6').value;
            document.getElementById('result_si1').innerHTML = ((parseFloat(value1_si1)-parseFloat(value2_si1))/parseFloat(value1_si1))*100 + "%";
            var progressBar = document.getElementById('progress_si1');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_si1';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_si1_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_si1').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_si1_inner');
            }
            var percent = ((parseFloat(value1_si1)-parseFloat(value2_si1))/parseFloat(value1_si1))*100;
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(0) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }

            var si1ValueEl = document.getElementById('si1_value');
            var resEl = document.getElementById('result_si1');
            var evidenceText = '';

            if (!isNaN(percent) && isFinite(percent)) {
              si1ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 95) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 90) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 80) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 1) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 1) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }
              resEl.innerHTML = percent.toFixed(3) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              si1ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }

          }
        </script>
      </div>

      <div class="card">
        <h5>SI.2</h5>
        <h6>Total area on campus covered in forest vegetation used for research, teaching, and/or community engagement</h6>
        <div class="value" id="si2_value"></div>
        <div class="evidence">
          <input id="value_1_5_2" type="number" min="0" step="0.001" placeholder="Total campus area (square meters)"/>
          <br>
          <input id="value_1_9" type="number" min="0" step="0.001" placeholder="Total area on campus covered in forest vegetation used for research, teaching, and/or community engagement"/>
          <br>
          <button onclick="output_si2()" class="btn">Lihat</button>
          <br>
          <strong>Evidence</strong>
          <p id="result_si2"></p>
        </div>
        <script>
          function output_si2(){
            var value1_si2 = document.getElementById('value_1_5_2').value;
            var value2_si2 = document.getElementById('value_1_9').value;
            document.getElementById('result_si2').innerHTML = ((parseFloat(value1_si2)-parseFloat(value2_si2))/parseFloat(value1_si2))*100 + "%";
            var progressBar = document.getElementById('progress_si2');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_si2';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_si2_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_si2').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_si2_inner');
            }
            var percent = ((parseFloat(value1_si2)-parseFloat(value2_si2))/parseFloat(value1_si2))*100;
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(0) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }

            var si2ValueEl = document.getElementById('si2_value');
            var resEl = document.getElementById('result_si2');
            var evidenceText = '';

            if (!isNaN(percent) && isFinite(percent)) {
              si2ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 35) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 25) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              } 
              resEl.innerHTML = percent.toFixed(3) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              si2ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }
          }
        </script>
      </div>

      <div class="card">
        <h5>SI.3</h5>
        <h6>Total area on campus covered in planted vegetation</h6>
        <div class="value" id="si3_value"></div>
        <div class="evidence">
          <input id="value_1_5_3" type="number" min="0" step="0.001" placeholder="Total campus area (square meters)"/>
          <br>
          <input id="value_1_10" type="number" min="0" step="0.001" placeholder="Total area on campus covered in forest vegetation used for research, teaching, and/or community engagement"/>
          <br>
          <button onclick="output_si3()" class="btn">Lihat</button>
          <br>
          <strong>Evidence</strong>
          <p id="result_si3"></p>
        </div>
        <script>
          function output_si3(){
            var value1_si3 = document.getElementById('value_1_5_3').value;
            var value2_si3 = document.getElementById('value_1_10').value;
            document.getElementById('result_si3').innerHTML = ((parseFloat(value1_si3)-parseFloat(value2_si3))/parseFloat(value1_si3))*100 + "%";
            var progressBar = document.getElementById('progress_si3');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_si3';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_si3_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_si3').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_si3_inner');
            }
            var percent = ((parseFloat(value1_si3)-parseFloat(value2_si3))/parseFloat(value1_si3))*100;
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(0) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }

            var si3ValueEl = document.getElementById('si3_value');
            var resEl = document.getElementById('result_si3');
            var evidenceText = '';

            if (!isNaN(percent) && isFinite(percent)) {
              si3ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 50) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 30) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 20) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 10) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 10) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              si3ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }
          }
        </script>
      </div>

      <div class="card">
        <h5>SI.4</h5>
        <h6>Total area on campus for water absorption besides the forest and planted vegetation</h6>
        <div class="value" id="si4_value"></div>
        <div class="evidence">
          <input id="value_1_5_4" type="number" min="0" step="0.001" placeholder="Total campus area (square meters)"/>
          <br>
          <input id="value_1_11" type="number" min="0" step="0.001" placeholder="Total area on campus covered in forest vegetation used for research, teaching, and/or community engagement"/>
          <br>
          <button onclick="output_si4()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_si4"></p>
        </div>
        <script>
          function output_si4(){
            var value1_si4 = document.getElementById('value_1_5_4').value;
            var value2_si4 = document.getElementById('value_1_11').value;
            document.getElementById('result_si4').innerHTML = ((parseFloat(value1_si4)-parseFloat(value2_si4))/parseFloat(value1_si4))*100 + "%";
            var progressBar = document.getElementById('progress_si4');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_si4';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_si4_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_si4').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_si4_inner');
            }
            var percent = ((parseFloat(value1_si4)-parseFloat(value2_si4))/parseFloat(value1_si4))*100;
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(0) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }

            var si4ValueEl = document.getElementById('si4_value');
            var resEl = document.getElementById('result_si4');
            var evidenceText = '';

            if (!isNaN(percent) && isFinite(percent)) {
              si4ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              si4ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }
          }

        </script>
      </div>

      <div class="card">
        <h5>SI.5</h5>
        <h6>The total open space area divided by the total campus population</h6>
        <div class="value" id="si5_value"></div>
        <div class="evidence">
          <input id="value_1_5_5" type="number" min="0" step="0.001" placeholder="Total campus area (square meters)"/>
          <br>
          <input id="value_1_6_2" type="number" min="0" step="0.001" placeholder="Total campus ground floor area of buildings (square meters)"/>
          <br>
          <input id="value_1_12" type="number" min="0" step="0.001" placeholder="Total number of regular students"/>
          <br>
          <input id="value_1_14" type="number" min="0" step="0.001" placeholder="Total number of academic and non-academic staff"/>
          <br>
          <button onclick="output_si5()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_si5"></p>
        </div>
        <script>
          function output_si5() {
            var value1_si5 = document.getElementById('value_1_5_5').value;
            var value2_si5 = document.getElementById('value_1_6_2').value;
            var value3_si5 = document.getElementById('value_1_12').value;
            var value4_si5 = document.getElementById('value_1_14').value;
            document.getElementById('result_si5').innerHTML = ((parseFloat(value1_si5)-parseFloat(value2_si5))/(parseFloat(value3_si5)+parseFloat(value4_si5))) + "%";
            var progressBar = document.getElementById('progress_si5');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_si5';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_si5_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_si5').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_si5_inner');
            }
            var percent = ((parseFloat(value1_si5)-parseFloat(value2_si5))/(parseFloat(value3_si5)+parseFloat(value4_si5)));
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(0) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }

            var si5ValueEl = document.getElementById('si5_value');
            var resEl = document.getElementById('result_si5');
            var evidenceText = '';

            if (!isNaN(percent) && isFinite(percent)) {
              si5ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 70) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 40) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 20) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 10) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 10) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              si5ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }
          }
        </script>
      </div>

      <div class="card">
        <h5>SI.6</h5>
        <h6>Percentage of university budget for sustainability efforts</h6>
        <div class="value" id="si6_value"></div>
        <div class="evidence">

          <input id="value_1_18_1" type="number" step="0.001" min="0" max="100" placeholder="infrastructure"/>
          <br>
          <input id="value_1_18_2" type="number" step="0.001" min="0" max="100" placeholder="facilities"/>
          <br>
          <input id="value_1_18_3" type="number" step="0.001" min="0" max="100" placeholder="personnel cost"/>
          <br>
          <input id="value_1_18_4" type="number" step="0.001" min="0" max="100" placeholder="research"/>
          <br>
          <input id="value_1_18_5" type="number" step="0.001" min="0" max="100" placeholder="programs"/>
          <br>
          <input id="value_1_18_6" type="number" step="0.001" min="0" max="100" placeholder="and others related to the sustainability efforts"/>
          <br>
          <button onclick="output_si6()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_si6"></p>
        </div>
        <script>
          function output_si6() {
            var value1_si6 = document.getElementById('value_1_18_1').value;
            var value2_si6 = document.getElementById('value_1_18_2').value;
            var value3_si6 = document.getElementById('value_1_18_3').value;
            var value4_si6 = document.getElementById('value_1_18_4').value;
            var value5_si6 = document.getElementById('value_1_18_5').value;
            var value6_si6 = document.getElementById('value_1_18_6').value;
            document.getElementById('result_si6').innerHTML = ((parseFloat(value1_si6)+parseFloat(value2_si6)+parseFloat(value3_si6)+parseFloat(value4_si6)+parseFloat(value5_si6)+parseFloat(value6_si6))/600)*100 + "%";
            var progressBar = document.getElementById('progress_si6');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_si6';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_si6_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_si6').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_si6_inner');
            }
            var percent = ((parseFloat(value1_si6)+parseFloat(value2_si6)+parseFloat(value3_si6)+parseFloat(value4_si6)+parseFloat(value5_si6)+parseFloat(value6_si6))/600)*100;
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(0) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }

            var si6ValueEl = document.getElementById('si6_value');
            var resEl = document.getElementById('result_si6');
            var evidenceText = '';

            if (!isNaN(percent) && isFinite(percent)) {
              si6ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              si6ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }
          }        
        </script>
      </div>

      <div class="card">
        <h5>SI.7</h5>
        <h6>Campus facilities for disabled, special needs, and/or maternity care</h6>
        <div class="value" id="si7_value"></div>
        <div class="evidence">
          <input type="radio" name="options_si7">None
          <br>
          <input type="radio" name="options_si7">Policy is in place
          <br>
          <input type="radio" name="options_si7">Facilities are in the planning stage
          <br>
          <input type="radio" name="options_si7">Facilities are partially available and operated
          <br>
          <input type="radio" name="options_si7">Facilities exist in all buildings and are fully operated
          <br>
          <strong>Evidence</strong>
          <p id="result_si7"></p>
        </div>
        <script>
          const radio_si7 = document.querySelectorAll('input[name="options_si7"]');
          const result_si7 = document.getElementById('result_si7');
          radio_si7.forEach(radio => {
            radio.addEventListener('change', function() {
              result_si7.innerHTML = this.nextSibling.textContent.trim();
            });
          });
        </script>
      </div>

      <div class="card">
        <h5>SI.8</h5>
        <h6>Security and safety facilities</h6>
        <div class="value" id="si8_value"></div>
        <div class="evidence">
          <input type="radio" name="options_si8">Passive security and safety system
          <br>
          <input type="radio" name="options_si8">Security and safety infrastructure (CCTV, emergency hotline/button) available and fully function
          <br>
          <input type="radio" name="options_si8">Security and safety infrastructure (CCTV, emergency hotline/button, certified personnel, fire extinguisher, hydrant) available and fully function
          <br>
          <input type="radio" name="options_si8">Security and safety infrastructure available and fully functioning and security responding time for accidents, crime, fire, and natural disasters is more than 5 minutes
          <br>
          <input type="radio" name="options_si8">Security and safety infrastructure available and fully functioning and security responding time for accidents, crime, fire, and natural disasters is less than 5 minutes
          <br>          
          <strong>Evidence</strong>
          <p id="result_si8"></p>
        </div>
        <script>
          const radio_si8 = document.querySelectorAll('input[name="options_si8"]');
          const result_si8 = document.getElementById('result_si8');
          radio_si8.forEach(radio => {
            radio.addEventListener('change', function() {
              result_si8.innerHTML = this.nextSibling.textContent.trim();
            });
          });
        </script>
      </div>

      <div class="card">
        <h5>SI.9</h5>
        <h6>Health infrastructure facilities for students, academics, and administrative staff's well-being</h6>
        <div class="value" id="si9_value"></div>
        <div class="evidence">
          <input type="radio" name="options_si9">Health infrastructure (first aid) is not available.
          <br>
          <input type="radio" name="options_si9">Health infrastructure (first aid, emergency room, clinic, and personnel) are available
          <br>
          <input type="radio" name="options_si9">Health infrastructure (first aid, emergency room, clinic, and certified personnel) are available
          <br>
          <input type="radio" name="options_si9">Health infrastructure (first aid, emergency room, clinic, hospital, and certified personnel) are available
          <br>
          <input type="radio" name="options_si9">Health infrastructure available (first aid, emergency room, clinic, hospital and certified personnel), system and accessible for public
          <br>
          <strong>Evidence</strong>
          <p id="result_si9"></p>
        </div>
        <script>
          const radio_si9 = document.querySelectorAll('input[name="options_si9"]');
          const result_si9 = document.getElementById('result_si9');
          radio_si9.forEach(radio => {
            radio.addEventListener('change', function() {
              result_si9.innerHTML = this.nextSibling.textContent.trim();
            });
          });
        </script>
      </div>

      <div class="card">
        <h5>SI.10</h5>
        <h6>Conservation: plant (flora), animal (fauna), or wildlife, genetic resources for food and agriculture secured in either medium or long-term conservation facilities</h6>
        <div class="value" id="si10_value"></div>
        <div class="evidence">
          <input id="value_1_22" type="number" step="0.001" min="0" max="100" placeholder="Number of conservation facilities (plant, animal, or wildlife, genetic resources for food and agriculture)"/>
          <br>
          <button onclick="output_si10()" class="btn">Lihat</button>
          <br>
          <strong>Evidence</strong>
          <p id="result_si10"></p>
        </div>
        <script>
          function output_si10(){
            var value1_si10 = document.getElementById('value_1_22').value;
            document.getElementById('result_si10').innerHTML = parseFloat(value1_si10) + "%";
            var progressBar = document.getElementById('progress_si10');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_si10';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_si10_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_si10').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_si10_inner');
            }
            var percent = parseFloat(value1_si10);
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(0) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }

            var si10ValueEl = document.getElementById('si10_value');
            var resEl = document.getElementById('result_si10');
            var evidenceText = '';

            if (!isNaN(percent) && isFinite(percent)) {
              si10ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              si10ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }
          }
        </script>
      </div>

      <div class="card">
        <h5>SI.11</h5>
        <h6>Planning, implementation, monitoring and/or evaluation of all programs related to Setting and Infrastructure through the utilization of Information and Communication Technology (ICT)</h6>
        <div class="value" id="si11_value"></div>
        <div class="evidence">
          
          <input type="radio" name="options_si11">None
          <br>
          <input type="radio" name="options_si11">The program is currently in the planning stage
          <br>
          <input type="radio" name="options_si11">Program has been implemented
          <br>
          <input type="radio" name="options_si11">Program has been implemented and evaluated
          <br>
          <input type="radio" name="options_si11">Program has been implemented, evaluated, and is currently revised
          <br>
          
          <strong>Evidence</strong>
        </div>
        <script>

        </script>
      </div>
    </div>
  </body>
</html>
