<?php
session_set_cookie_params(0); 
session_start();
$session_timeout = 4800;
if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $session_timeout)) {
    session_unset();
    session_destroy();
    header("Location: login.php");
    exit;
}
$_SESSION['last_activity'] = time();

if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
  <html>
  <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>UI GreenMetric Dashboard</title>
    <link rel="stylesheet" href="dashboard.css">
  </head>
  <body>
    <div class="topnav">
      <a href="./home.php">Home</a>
      <a href="./dashboard_si.php">SI</a>
      <a href="./dashboard_ec.php">EC</a>
      <a href="./dashboard_ws.php">WS</a>
      <a href="./dashboard_wr.php">WR</a>
      <a class="active" href="./dashboard_tr.php">TR</a>
      <a href="./dashboard_ed.php">ED</a>
      <a href="./about.php">About</a>
    </div>

    <h2>Welcome, <?php echo $_SESSION['username']; ?>!</h2>
    <a href="logout.php" style="color: rgb(255, 255, 255)">Logout</a>
    <h1>UI GreenMetric - Monitoring & Evaluation Dashboard</h1>
    <br>
    <h2>Transportation (TR)</h2>
    <br>
    <div class="dashboard">
      <div class="card">
        <h5>TR.1</h5>
        <h6>The total number of vehicles (cars and motorcycles with combustion engines) divided by the total campus' population</h6>
        <div class="value" id="tr1_value"></div>
        <div class="evidence">
          <input id="value_5_1" type="number" placeholder="Number of cars actively used and managed by the university"/>
          <br>
          <input id="value_5_2" type="number" placeholder="Number of cars entering the university daily"/>
          <br>
          <input id="value_5_3" type="number" placeholder="Number of motorcycles entering the university daily"/>
          <br>
          <input id="value_1_12_4" type="number" placeholder="Total number of regular students"/>
          <br>
          <input id="value_1_14_4" type="number" placeholder="Total number of academic and non-academic staff"/>
          <br>
          <button onclick="output_tr1()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_tr1"></p>
        </div>
        <script>
          function output_tr1(){
            var value1_tr1 = document.getElementById('value_5_1').value;
            var value2_tr1 = document.getElementById('value_5_2').value;
            var value3_tr1 = document.getElementById('value_5_3').value;
            var value4_tr1 = document.getElementById('value_1_12_4').value;
            var value5_tr1 = document.getElementById('value_1_14_4').value;
            document.getElementById('result_tr1').innerHTML = (parseFloat(value1_tr1)+parseFloat(value2_tr1)+parseFloat(value3_tr1))/(parseFloat(value4_tr1)+parseFloat(value5_tr1));
            var progressBar = document.getElementById('progress_tr1');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_tr1';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_tr1_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_tr1').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_tr1_inner');
            }
            var percent = (parseFloat(value1_tr1)+parseFloat(value2_tr1)+parseFloat(value3_tr1))/(parseFloat(value4_tr1)+parseFloat(value5_tr1))*100;
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(3) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }

            var si4ValueEl = document.getElementById('si4_value');
            var resEl = document.getElementById('result_si4');
            var evidenceText = '';
            
            if (!isNaN(percent) && isFinite(percent)) {
              si4ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              tr1ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }

          }
        </script>
      </div>

      <div class="card">
        <h5>TR.2</h5>
        <h6>Shuttle services</h6>
        <div class="value" id="tr2_value"></div>
        <div class="evidence">
          <input type="radio" name="options_tr2">Possible but not provided by university 
          <br>
          <input type="radio" name="options_tr2">Provided (by university or other parties) and regular but not free 
          <br>
          <input type="radio" name="options_tr2">Provided (by university or other parties) and the university contributes a part of the cost 
          <br>
          <input type="radio" name="options_tr2">Provided by university, regular, and free 
          <br>
          <input type="radio" name="options_tr2">Provided by university, regular, and zero emission vehicle. Or shuttle use is not applicable
          <br>
          <strong>Evidence</strong>
          <p id="result_tr2"></p>
        </div>
        <script>
          const radio_tr2 = document.querySelectorAll('input[name="options_tr2"]');
          const result_tr2 = document.getElementById('result_tr2');
          radio_tr2.forEach(radio => {
            radio.addEventListener('change', function() {
              result_tr2.innerHTML = this.nextSibling.textContent.trim();
            });
          });
        </script>
      </div>

      <div class="card">
        <h5>TR.3</h5>
        <h6>Zero Emission Vehicles (ZEV) availability on campus</h6>
        <div class="value" id="tr3_value"></div>
        <div class="evidence">
          <input type="radio" name="options_tr3">ZEV are not available 
          <br>
          <input type="radio" name="options_tr3">ZEV use is not possible or practical 
          <br>
          <input type="radio" name="options_tr3">ZEV are available, but not provided by university 
          <br>
          <input type="radio" name="options_tr3">ZEV are available, provided by the university and charged  
          <br>
          <input type="radio" name="options_tr3">ZEV are available, and provided by the university for free (Regularly used by campus academic society)
          <br>
          <strong>Evidence</strong>
          <p id="result_tr3"></p>
        </div>
        <script>
          const radio_tr3 = document.querySelectorAll('input[name="options_tr3"]');
          const result_tr3 = document.getElementById('result_tr3');
          radio_tr3.forEach(radio => {
            radio.addEventListener('change', function() {
              result_tr3.innerHTML = this.nextSibling.textContent.trim();
            });
          });
        </script>
      </div>

      <div class="card">
        <h5>TR.4</h5>
        <h6>The total number of Zero Emission Vehicles (ZEV) divided by the total campus population</h6>
        <div class="value" id="tr4_value"></div>
        <div class="evidence">
          <input id="value_5_10" type="number" step="0.001" placeholder="Average number of Zero Emission Vehicles (ZEV) on campus per day"/>
          <br>
          <input id="value_1_12_5" type="number" step="0.001" placeholder="Total number of regular students"/>
          <br>
          <input id="value_1_14_5" type="number" step="0.001" placeholder="Total number of academic and non-academic staff"/>
          <br>
          <button onclick="output_tr4()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_tr4"></p>
        </div>
        <script>
          function output_tr4(){
            var value1_tr4 = document.getElementById('value_5_10').value;
            var value2_tr4 = document.getElementById('value_1_12_5').value;
            var value3_tr4 = document.getElementById('value_1_14_5').value;
            document.getElementById('result_tr4').innerHTML = parseFloat(value1_tr4)/(parseFloat(value2_tr4)+parseFloat(value3_tr4));
          var progressBar = document.getElementById('progress_tr4');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_tr4';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_tr4_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_tr4').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_tr4_inner');
            }
            var percent = parseFloat(value1_tr4)/(parseFloat(value2_tr4)+parseFloat(value3_tr4))*100;
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(3) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }

            var tr4ValueEl = document.getElementById('tr4_value');
            var resEl = document.getElementById('result_tr4');
            var evidenceText = '';

            if (!isNaN(percent) && isFinite(percent)) {
              tr4ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              tr4ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }

          }
        </script>
      </div>

      <div class="card">
        <h5>TR.5</h5>
        <h6>The ratio of the ground parking area to total campus area</h6>
        <div class="value" id="tr5_value"></div>
        <div class="evidence">
          <input id="value_5_13" type="number" step="0.001" min="0" placeholder="Total ground parking area (square meters)"/>
          <br>
          <input id="value_1_5_6" type="number" step="0.001" min="0" placeholder="Total campus area (square meters)"/>
          <br>
          <button onclick="output_tr5()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_tr5"></p>
        </div>
        <script>
          function output_tr5(){
            var value1_tr5 = document.getElementById('value_5_13').value;
            var value2_tr5 = document.getElementById('value_1_5_6').value;
            document.getElementById('result_tr5').innerHTML = (parseFloat(value1_tr5)/parseFloat(value2_tr5))*100 + "%";
            var progressBar = document.getElementById('progress_tr5');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_tr5';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_tr5_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_tr5').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_tr5_inner');
            }
            var percent = (parseFloat(value1_tr5)/parseFloat(value2_tr5))*100;
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(3) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }

            var tr5ValueEl = document.getElementById('tr5_value');
            var resEl = document.getElementById('result_tr5');
            var evidenceText = '';

            if (!isNaN(percent) && isFinite(percent)) {
              tr5ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              tr5ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }

          }
        </script>
      </div>

      <div class="card">
        <h5>TR.6</h5>
        <h6></h6>
        <div class="value" id="tr6_value"></div>
        <div class="evidence">
          
          <input type="radio" name="options_tr6">None
          <br>
          <input type="radio" name="options_tr6">In preparation
          <br>
          <input type="radio" name="options_tr6">Parking area 
          <br>
          <input id="value_5_14" type="number" step="0.001" min="0" max="100" placeholder="Percentage of parking area" />
          <br>
          <button onclick="output_tr6()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_tr6"></p>
        </div>
        <script>
          function output_tr6(){
            var value1_tr6 = document.getElementById('value_5_14').value;
            document.getElementById('result_tr6').innerHTML = parseFloat(value1_tr6) + "%";
            var progressBar = document.getElementById('progress_tr6');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_tr6';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_tr6_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_tr6').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_tr6_inner');
            }
            var percent = parseFloat(value1_tr6);
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(3) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }

            var tr6ValueEl = document.getElementById('tr6_value');
            var resEl = document.getElementById('result_tr6');
            var evidenceText = '';

            if (!isNaN(percent) && isFinite(percent)) {
              tr6ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              tr6ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }

          }
        </script>
      </div>

      <div class="card">
        <h5>TR.7</h5>
        <h6>Number of initiatives to decrease private vehicles on campus</h6>
        <div class="value" id="tr7_value"></div>
        <div class="evidence">
          <input id="value_5_15" type="number" min="0" max="65535" placeholder="Number of initiatives to decrease private vehicles on campus"/>
          <br>
          <button onclick="output_tr7()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_tr7"></p>
        </div>
        <script>
          function output_tr7(){
            var value1_tr7 = document.getElementById('value_5_15').value;
            document.getElementById('result_tr7').innerHTML = parseInt(value1_tr7) + " initiative(s)";
            var progressBar = document.getElementById('progress_tr7');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_tr7';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_tr7_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_tr7').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_tr7_inner');
            }
            var percent = parseInt(value1_tr7);
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(3) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }

            var tr7ValueEl = document.getElementById('tr7_value');
            var resEl = document.getElementById('result_tr7');
            var evidenceText = '';

            if (!isNaN(percent) && isFinite(percent)) {
              tr7ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              tr7ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }

          }
        </script>
      </div>

      <div class="card">
        <h5>TR.8</h5>
        <h6>Pedestrian path on campus</h6>
        <div class="value" id="tr8_value"></div>
        <div class="evidence">
          <input type="radio" name="options_tr8">None
          <br>
          <input type="radio" name="options_tr8">Available
          <br>
          <input type="radio" name="options_tr8">Available, and designed for safety
          <br>
          <input type="radio" name="options_tr8">Available, designed for safety and convenience
          <br>
          <input type="radio" name="options_tr8">Available, designed for safety, convenience, and in some parts provided with disabled-friendly features
          <br>
          <strong>Evidence</strong>
          <p id="result_tr8"></p>
        </div>
        <script>
          const radio_tr8 = document.querySelectorAll('input[name="options_tr8"]');
          const result_tr8 = document.getElementById('result_tr8');
          radio_tr8.forEach(radio => {
            radio.addEventListener('change', function() {
              result_tr8.innerHTML = this.nextSibling.textContent.trim();
            });
          });
        </script>
      </div>

      <div class="card">
        <h5>TR.9</h5>
        <h6>Planning, implementation, monitoring and/or evaluation of all programs related to Transportation through the utilization of Information and Communication Technology (ICT)</h6>
        <div class="value" id="tr9_value"></div>
        <div class="evidence">
          <input type="radio" name="options_tr9">None
          <br>
          <input type="radio" name="options_tr9">The program is currently in the planning stage
          <br>
          <input type="radio" name="options_tr9">Program has been implemented
          <br>
          <input type="radio" name="options_tr9">Program has been implemented and evaluated
          <br>
          <input type="radio" name="options_tr9">Program has been implemented, evaluated, and is currently revised
          <br>
          <strong>Evidence</strong>
          <p id="result_tr9"></p>
        </div>
        <script>
          const radio_tr9 = document.querySelectorAll('input[name="options_tr9"]');
          const result_tr9 = document.getElementById('result_tr9');
          radio_tr9.forEach(radio => {
            radio.addEventListener('change', function() {
              result_tr9.innerHTML = this.nextSibling.textContent.trim();
            });
          });
        </script>
      </div>
    </div>
    <br>
    </div>
  </body>
</html>
