<?php
session_set_cookie_params(0); 
session_start();
$session_timeout = 4800;
if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $session_timeout)) {
    session_unset();
    session_destroy();
    header("Location: login.php");
    exit;
}
$_SESSION['last_activity'] = time();

if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
  <html>
  <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>UI GreenMetric Dashboard</title>
    <link rel="stylesheet" href="dashboard.css">
  </head>
  <body>
    <div class="topnav">
      <a href="./home.php">Home</a>
      <a href="./dashboard_si.php">SI</a>
      <a href="./dashboard_ec.php">EC</a>
      <a href="./dashboard_ws.php">WS</a>
      <a class="active" href="./dashboard_wr.php">WR</a>
      <a href="./dashboard_tr.php">TR</a>
      <a href="./dashboard_ed.php">ED</a>
      <a href="./about.php">About</a>
    </div>

    <h2>Welcome, <?php echo $_SESSION['username']; ?>!</h2>
    <a href="logout.php" style="color: rgb(255, 255, 255)">Logout</a>
    <h1>UI GreenMetric - Monitoring & Evaluation Dashboard</h1>
    <br>
    <h2>Water (WR)</h2>
    <br>
    <div class="dashboard">
      <div class="card">
        <h5>WR.1</h5>
        <h6>Water conservation program and implementation</h6>
        <div class="value" id="wr1_value"></div>
        <div class="evidence">

          <input type="radio" name="options_wr1">None. Please select this option if the conservation program is needed, but nothing has been done.
          <br>
          <input type="radio" name="options_wr1">Program in preparation
          <br>
          <input type="radio" name="options_wr1">Water conservation
          <br>
          <input id="value_4_1" type="number" placeholder="Water conserved"/>
          <br>
          <button onclick="output_wr1()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_wr1"></p>
        </div>
        <script>
          function output_wr1(){
            var value1_wr1 = document.getElementById('value_4_1').value;
            document.getElementById('result_wr1').innerHTML = parseFloat(value1_wr1) + "%";
            var progressBar = document.getElementById('progress_wr1');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_wr1';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_wr1_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_wr1').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_wr1_inner');
            }
            var percent = parseFloat(value1_wr1);
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(0) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }
          }
        </script>
      </div>

      <div class="card">
        <h5>WR.2</h5>
        <h6>Water recycling program implementation</h6>
        <div class="value" id="wr2_value"></div>
        <div class="evidence">
          <input type="radio" name="options_wr2">None. Please select this option if the reduction program is needed, but nothing has been done.
          <br>
          <input type="radio" name="options_wr2">Program in preparation
          <br>
          <input type="radio" name="options_wr2">Water conservation
          <br>
          <input id="value_4_2" type="number" placeholder="Water conserved"/>
          <br>
          <button onclick="output_wr1()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_wr2"></p>
        </div>
        <script>
          function output_wr2(){
            var value1_wr2 = document.getElementById('value_4_2').value;
            document.getElementById('result_wr2').innerHTML = parseFloat(value1_wr2) + "%";
            var progressBar = document.getElementById('progress_wr2');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_wr2';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_wr2_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_wr2').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_wr2_inner');
            }
            var percent = parseFloat(value1_wr2);
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(0) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }
          }
        </script>
      </div>

      <div class="card">
        <h5>WR.3</h5>
        <h6>Water efficient appliances usage</h6>
        <div class="value" id="wr3_value"></div>
        <div class="evidence">
          <input id="value_4_3" type="number" placeholder="Water conserved"/>
          <br>
          <button onclick="output_wr3()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_wr3"></p>
        </div>
        <script>
          function output_wr3(){
            var value1_wr3 = document.getElementById('value_4_3').value;
            document.getElementById('result_wr3').innerHTML = parseFloat(value1_wr3) + "% of water efficient appliances installed";
            var progressBar = document.getElementById('progress_wr3');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_wr3';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_wr3_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_wr3').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_wr3_inner');
            }
            var percent = parseFloat(value1_wr3);
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(0) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }
          }
        </script>
      </div>

      <div class="card">
        <h5>WR.4</h5>
        <h6>Consumption of treated water</h6>
        <div class="value" id="wr4_value"></div>
        <div class="evidence">
          <input id="value_4_4" type="number" placeholder="Water conserved"/>
          <br>
          <button onclick="output_wr4()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_wr4"></p>
        </div>
        <script>
          function output_wr4(){
            var value1_wr1 = document.getElementById('value_4_4').value;
            document.getElementById('result_wr4').innerHTML = parseFloat(value1_wr4) + "% treated water consumed";
            var progressBar = document.getElementById('progress_wr4');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_wr4';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_wr4_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_wr4').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_wr4_inner');
            }
            var percent = parseFloat(value1_wr4);
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(0) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }
          }
        </script>
      </div>

      <div class="card">
        <h5>WR.5</h5>
        <h6>Water pollution control in campus area</h6>
        <div class="value" id="wr5_value"></div>
        <div class="evidence">
          <input type="radio" name="options_wr5">Policy and programs for water pollution control are in the designing stage
          <br>
          <input type="radio" name="options_wr5">Policy and programs for water pollution control are in the construction stage
          <br>
          <input type="radio" name="options_wr5">Policy and programs for water pollution control are in the early implementation stage
          <br>
          <input type="radio" name="options_wr5">Policy and programs for water pollution control are fully implemented and monitored occasionally
          <br>
          <input type="radio" name="options_wr5">Policy and programs for water pollution control are fully implemented and monitored regularly
          <br>
          <strong>Evidence</strong>
          <p id="result_wr5"></p>
        </div>
        <script>
          const radio_wr5 = document.querySelectorAll('input[name="options_wr5"]');
          const result_wr5 = document.getElementById('result_wr5');
          radio_wr5.forEach(radio => {
            radio.addEventListener('change', function() {
              result_wr5.innerHTML = this.nextSibling.textContent.trim();
            });
          });
        </script>
      </div>

      <div class="card">
        <h5>WR.6</h5>
        <h6>Planning, implementation, monitoring and/or evaluation of all programs related to Water Management through the utilization of Information and Communication Technology (ICT)</h6>
        <div class="value" id="wr6_value"></div>
        <div class="evidence">
          <input type="radio" name="options_wr6">None
          <br>
          <input type="radio" name="options_wr6">The program is currently in the planning stage
          <br>
          <input type="radio" name="options_wr6">Program has been implemented
          <br>
          <input type="radio" name="options_wr6">Program has been implemented and evaluated
          <br>
          <input type="radio" name="options_wr6">Program has been implemented, evaluated, and is currently revised
          <br>
          <strong>Evidence</strong>
          <p id="result_wr6"></p>
        </div>
        <script>
          const radio_wr6 = document.querySelectorAll('input[name="options_wr6"]');
          const result_wr6 = document.getElementById('result_wr6');
          radio_wr6.forEach(radio => {
            radio.addEventListener('change', function() {
              result_wr6.innerHTML = this.nextSibling.textContent.trim();
            });
          });
        </script>
      </div>
    </div>
    <br>
    </div>
  </body>
</html>
