<?php
session_set_cookie_params(0); 
session_start();
$session_timeout = 4800;
if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $session_timeout)) {
    session_unset();
    session_destroy();
    header("Location: login.php");
    exit;
}
$_SESSION['last_activity'] = time();

if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
  <html>
  <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>UI GreenMetric Dashboard</title>
    <link rel="stylesheet" href="dashboard.css">
  </head>
  <body>
    <div class="topnav">
      <a href="./home.php">Home</a>
      <a href="./dashboard_si.php">SI</a>
      <a href="./dashboard_ec.php">EC</a>
      <a class="active" href="./dashboard_ws.php">WS</a>
      <a href="./dashboard_wr.php">WR</a>
      <a href="./dashboard_tr.php">TR</a>
      <a href="./dashboard_ed.php">ED</a>
      <a href="./about.php">About</a>
    </div>

    <h2>Welcome, <?php echo $_SESSION['username']; ?>!</h2>
    <a href="logout.php" style="color: rgb(255, 255, 255)">Logout</a>
    <h1>UI GreenMetric - Monitoring & Evaluation Dashboard</h1>
    <br>
    <h2>Waste (WS)</h2>
    <br>
    <div class="dashboard">
      <div class="card">
        <h5>WS.1</h5>
        <h6>3R (Reduce, Reuse, Recycle) program for university's waste</h6>
        <div class="value" id="ws1_value"></div>
        <div class="evidence">
          <input id="value_3_1" type="number" step="0.001" min="0" max="100" placeholder="Percentage of water efficient appliances usage (%)"/>
          <br>
          <button onclick="output_ws1()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_ws1"></p>
        </div>
        <script>
          function output_ws1(){
            var value1_ws1 = document.getElementById('value_3_1').value;
            document.getElementById('result_ws1').innerHTML = parseFloat(value1_ws1) + "%";
            var progressBar = document.getElementById('progress_ws1');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_ws1';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_ws1_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_ws1').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_ws1_inner');
            }
            var percent = parseFloat(value1_ws1);
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(3) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }

            var ws1ValueEl = document.getElementById('ws1_value');
            var resEl = document.getElementById('result_ws1');
            var evidenceText = '';

            if (!isNaN(percent) && isFinite(percent)) {
              ws1ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              ws1ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }

          }
        </script>
      </div>

      <div class="card">
        <h5>WS.2</h5>
        <h6>Program to reduce the use of paper and plastic on campus</h6>
        <div class="value" id="ws2_value"></div>
        <div class="evidence">
          <input id="value_3_4" type="number" min="0" max="65535" placeholder="Number of programs to reduce the use of paper and plastic on campus"/>
          <br>
          <button onclick="output_ws2()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_ws2"></p>
        </div>
        <script>
          function output_ws2(){
            var value1_ws2 = document.getElementById('value_3_4').value;
            document.getElementById('result_ws2').innerHTML = parseFloat(value1_ws2) + " program(s)";
            var progressBar = document.getElementById('progress_ws2');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_ws2';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_ws2_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_ws2').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_ws2_inner');
            }
            var percent = parseFloat(value1_ws2)/65535*100;
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(3) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }

            var ws2ValueEl = document.getElementById('ws2_value');
            var resEl = document.getElementById('result_ws2');
            var evidenceText = '';

            if (!isNaN(percent) && isFinite(percent)) {
              ws2ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              ws2ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }

          }
        </script>
      </div>

      <div class="card">
        <h5>WS.3</h5>
        <h6>Organic waste treatment</h6>
        <div class="value" id="ws3_value"></div>
        <div class="evidence">
          <input id="value_3_8" type="number" step="0.001" min="0" max="100" placeholder="Percentage of organic waste treatment"/>
          <br>
          <button onclick="output_ws3()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_ws3"></p>
        </div>
        <script>
          function output_ws3(){
            var value1_ws3 = document.getElementById('value_3_8').value;
            document.getElementById('result_ws3').innerHTML = parseFloat(value1_ws3) + "% treated";
            var progressBar = document.getElementById('progress_ws3');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_ws3';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_ws3_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_ws3').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_ws3_inner');
            }
            var percent = parseFloat(value1_ws3);
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(3) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }

            var ws3ValueEl = document.getElementById('ws3_value');
            var resEl = document.getElementById('result_ws3');
            var evidenceText = '';

            if (!isNaN(percent) && isFinite(percent)) {
              ws3ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              ws3ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }

          }
        </script>
      </div>

      <div class="card">
        <h5>WS.4</h5>
        <h6>Inorganic waste treatment</h6>
        <div class="value" id="ws4_value"></div>
        <div class="evidence">
          <input id="value_3_12" type="number" step="0.001" min="0" max="100" placeholder="Percentage of inorganic waste treatment"/>
          <br>
          <button onclick="output_ws4()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_ws4"></p>
        </div>
        <script>
          function output_ws4(){
            var value1_ws4 = document.getElementById('value_3_12').value;
            document.getElementById('result_ws4').innerHTML = parseFloat(value1_ws4) + "% treated";
            var progressBar = document.getElementById('progress_ws4');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_ws4';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_ws4_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_ws4').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_ws4_inner');
            }
            var percent = parseFloat(value1_ws4);
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(3) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }

            var ws4ValueEl = document.getElementById('ws4_value');
            var resEl = document.getElementById('result_ws4');
            var evidenceText = '';

            if (!isNaN(percent) && isFinite(percent)) {
              si4ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              ws4ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }

          }
        </script>
      </div>

      <div class="card">
        <h5>WS.5</h5>
        <h6>Toxic waste treatment</h6>
        <div class="value" id="ws5_value"></div>
        <div class="evidence">
          <input id="value_3_16" type="number" step="0.001" min="0" max="100" placeholder="Percentage of toxic waste treatment"/>
          <br>
          <button onclick="output_ws5()" class="btn">Lihat</button>
          <strong>Evidence</strong>
          <p id="result_ws5"></p>
        </div>
        <script>
          function output_ws5(){
            var value1_ws5 = document.getElementById('value_3_16').value;
            document.getElementById('result_ws5').innerHTML = parseFloat(value1_ws5) + "% treated";
            var progressBar = document.getElementById('progress_ws5');
            if (!progressBar) {
              progressBar = document.createElement('div');
              progressBar.id = 'progress_ws5';
              progressBar.style.width = '100%';
              progressBar.style.background = 'rgb(0, 0, 0)';
              progressBar.style.borderRadius = '5px';
              progressBar.style.marginTop = '10px';
              var innerBar = document.createElement('div');
              innerBar.id = 'progress_ws5_inner';
              innerBar.style.height = '20px';
              innerBar.style.width = '0%';
              innerBar.style.background = 'rgb(0, 170, 255)';
              innerBar.style.borderRadius = '5px';
              progressBar.appendChild(innerBar);
              document.getElementById('result_ws5').parentNode.appendChild(progressBar);
            } else {
              var innerBar = document.getElementById('progress_ws5_inner');
            }
            var percent = parseFloat(value1_ws5);
            if (!isNaN(percent) && isFinite(percent)) {
              innerBar.style.width = Math.max(0, Math.min(100, percent)) + '%';
              innerBar.innerText = percent.toFixed(3) + '%';
            } else {
              innerBar.style.width = '0%';
              innerBar.innerText = '';
            }

            var ws5ValueEl = document.getElementById('ws5_value');
            var resEl = document.getElementById('result_ws5');
            var evidenceText = '';

            if (!isNaN(percent) && isFinite(percent)) {
              ws5ValueEl.innerText = percent.toFixed(3) + '%';

              if (percent > 40) {
                evidenceText = 'Excellent — very high proportion of open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,0,255)';
              } else if (percent > 20) {
                evidenceText = 'Good — adequate open space.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,255)';
              } else if (percent > 10) {
                evidenceText = 'Fair — limited open space; consider improvements.';
                if (innerBar) innerBar.style.background = 'rgb(0,255,0)';
              } else if (percent > 2) {
                evidenceText = 'Poor — very low open space; actions recommended.';
                if (innerBar) innerBar.style.background = 'rgb(255,255,0)';
              } else if (percent <= 2) {
                evidenceText = 'Critical — negligible open space; immediate action required.';
                if (innerBar) innerBar.style.background = 'rgb(255,0,0)';
              }

              resEl.innerHTML = percent.toFixed(2) + '%<br><strong>Condition:</strong> ' + evidenceText;
            } else {
              ws5ValueEl.innerText = '-';
              resEl.innerHTML = 'Please enter valid numeric values for total campus area and ground floor area.';
              if (innerBar) {
                innerBar.style.width = '0%';
                innerBar.innerText = '';
              }
            }

          }
        </script>
      </div>

      <div class="card">
        <h5>WS.6</h5>
        <h6>Sewage disposal</h6>
        <div class="value" id="ws6_value"></div>
        <div class="evidence">
          <input type="radio" name="options_ws6">Untreated into waterways
          <br>
          <input type="radio" name="options_ws6">Treated with preliminary treatment
          <br>
          <input type="radio" name="options_ws6">Treated with primary treatment
          <br>
          <input type="radio" name="options_ws6">Treated with secondary treatment
          <br>
          <input type="radio" name="options_ws6">Treated with tertiary treatment
          <br>
          <strong>Evidence</strong>
          <p id="result_ws6"></p>
        </div>
        <script>
          const radio_ws6 = document.querySelectorAll('input[name="options_ws6"]');
          const result_ws6 = document.getElementById('result_ws6');
          radio_ws6.forEach(radio => {
            radio.addEventListener('change', function() {
              result_ws6.innerHTML = this.nextSibling.textContent.trim();
            });
          });
        </script>
      </div>

      <div class="card">
        <h5>WS.7</h5>
        <h6>Planning, implementation, monitoring and/or evaluation of all programs related to Waste Management through the utilization of Information and Communication Technology (ICT)</h6>
        <div class="value" id="ws7_value"></div>
        <div class="evidence">
          <input type="radio" name="options_ws7">None
          <br>
          <input type="radio" name="options_ws7">The program is currently in the planning stage
          <br>
          <input type="radio" name="options_ws7">Program has been implemented
          <br>
          <input type="radio" name="options_ws7">Program has been implemented and evaluated
          <br>
          <input type="radio" name="options_ws7">Program has been implemented, evaluated, and is currently revised
          <br>
          <strong>Evidence</strong>
          <p id="result_ws7"></p>
        </div>
        <script>
          const radio_ws7 = document.querySelectorAll('input[name="options_ws7"]');
          const result_ws7 = document.getElementById('result_ws7');
          radio_ws7.forEach(radio => {
            radio.addEventListener('change', function() {
              result_ws7.innerHTML = this.nextSibling.textContent.trim();
            });
          });

        </script>
      </div>
    </div>
    <br>
    </div>
  </body>
</html>
