-- Membuat database uigm_db
CREATE DATABASE uigm_db;

-- Menggunakan database uigm_db
USE uigm_db;

-- Membuat tabel users untuk autentikasi
CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(65535) NOT NULL,
    password VARCHAR(65535) NOT NULL
);

-- Tabel kategori utama
CREATE TABLE categories (
    category_id INT PRIMARY KEY AUTO_INCREMENT,
    category_code TEXT NOT NULL,  -- contoh: SI, EC, WS, WR, TR, ED
    category_name TEXT NOT NULL  -- contoh: Setting and Infrastructure
);

-- Tabel indikator
CREATE TABLE indicators (
    category_id INT NOT NULL,
    indicator_id INT PRIMARY KEY AUTO_INCREMENT,
    indicator_code TEXT NOT NULL,   -- contoh: SI1, EC3, WR5
    indicator_description TEXT NOT NULL,   -- deskripsi indikator
    FOREIGN KEY (category_id) REFERENCES categories(category_id),
    evidence TEXT NOT NULL
);

-- Insert kategori
INSERT INTO categories (category_code, category_name) VALUES
('SI', 'Setting and Infrastructure'),
('EC', 'Energy and Climate Change'),
('WS', 'Waste'),
('WR', 'Water'),
('TR', 'Transportation'),
('ED', 'Education and Research');

-- Indikator SI
INSERT INTO indicators (category_id, indicator_code, indicator_description) VALUES
(1, 'SI1', 'The ratio of open space area to total area'),
(1, 'SI2', 'Total area on campus covered in forest vegetation used for research, teaching, and/or community engagement'),
(1, 'SI3', 'Total area on campus covered in planted vegetation'),
(1, 'SI4', 'Total area on campus for water absorption besides the forest and planted vegetation'),
(1, 'SI5', 'The total open space area divided by total campus population'),
(1, 'SI6', 'Percentage of university budget for sustainability efforts'),
(1, 'SI7', 'Campus facilities for disabled, special needs and/or maternity care'),
(1, 'SI8', 'Security and safety facilities'),
(1, 'SI9', 'Health infrastructure facilities for students, academics and administrative staffs well-being'),
(1, 'SI10', 'Conservation: plant (flora), animal (fauna), or wildlife, genetic resources for food and agriculture secured in either medium or long-term conservation facilities'),
(1, 'SI11', 'Planning, implementation, monitoring and/or evaluation of all programs related to Setting and Infrastructure through the utilization of Information and Communication Technology (ICT)');

-- Indikator EC
INSERT INTO indicators (category_id, indicator_code, indicator_description) VALUES
(2, 'EC1', 'Energy efficient appliances usage'),
(2, 'EC2', 'Smart building implementation'),
(2, 'EC3', 'Number of renewable energy sources on campus'),
(2, 'EC4', 'Total electricity usage divided by total campus population (kWh per person)'),
(2, 'EC5', 'The ratio of renewable energy production divided by total energy usage per year'),
(2, 'EC6', 'Elements of green building implementation as reflected in all buildings'),
(2, 'EC7', 'Greenhouse gas emission reduction program'),
(2, 'EC8', 'Total carbon footprint divided by total campus population (metric tons per person)'),
(2, 'EC9', 'Number of innovative programs in energy and climate change'),
(2, 'EC10', 'Impactful university programs on climate change'),
(2, 'EC11', 'Planning, implementation, monitoring and/or evaluation of all programs related to Energy and Climate Change through the utilization of Information and Communication Technology (ICT)');

-- Indikator WS
INSERT INTO indicators (category_id, indicator_code, indicator_description) VALUES
(3, 'WS1', '3R (Reduce, Reuse, Recycle) program for university waste'),
(3, 'WS2', 'Program to reduce the use of paper and plastic on campus'),
(3, 'WS3', 'Organic waste treatment'),
(3, 'WS4', 'Inorganic waste treatment'),
(3, 'WS5', 'Toxic waste treatment'),
(3, 'WS6', 'Sewage disposal'),
(3, 'WS7', 'Planning, implementation, monitoring and/or evaluation of all programs related to Waste Management through the utilization of Information and Communication Technology (ICT)');

-- Indikator WR
INSERT INTO indicators (category_id, indicator_code, indicator_description) VALUES
(4, 'WR1', 'Water conservation program and implementation'),
(4, 'WR2', 'Water recycling program implementation'),
(4, 'WR3', 'Water efficient appliances usage'),
(4, 'WR4', 'Consumption of treated water'),
(4, 'WR5', 'Water pollution control in the campus area'),
(4, 'WR6', 'Planning, implementation, monitoring and/or evaluation of all programs related to Water Management through the utilization of Information and Communication Technology (ICT)');

-- Indikator TR
INSERT INTO indicators (category_id, indicator_code, indicator_description) VALUES
(5, 'TR1', 'The total number of vehicles (cars and motorcycles with combustion engines) divided by the total campus population'),
(5, 'TR2', 'Shuttle services'),
(5, 'TR3', 'Zero Emission Vehicles (ZEV) availability on campus'),
(5, 'TR4', 'The total number of Zero Emission Vehicles (ZEV) divided by total campus population'),
(5, 'TR5', 'Ratio of the ground parking area to the total campus area'),
(5, 'TR6', 'Program to limit or decrease the parking area on campus for the last 3 years'),
(5, 'TR7', 'Number of initiatives to decrease private vehicles on campus'),
(5, 'TR8', 'Pedestrian path on campus'),
(5, 'TR9', 'Planning, implementation, monitoring and/or evaluation of all programs related to Transportation through the utilization of Information and Communication Technology (ICT)');

-- Indikator ED
INSERT INTO indicators (category_id, indicator_code, indicator_description) VALUES
(6, 'ED1', 'The ratio of sustainability courses to total courses/subjects'),
(6, 'ED2', 'The ratio of sustainability research funding to total research funding'),
(6, 'ED3', 'Ratio of scholarly publications on sustainability to lecturers/researchers on campus in one year period'),
(6, 'ED4', 'Number of events related to sustainability (environment)'),
(6, 'ED5', 'Number of activities organized by student organizations related to sustainability per year'),
(6, 'ED6', 'University-run sustainability website'),
(6, 'ED7', 'Sustainability report'),
(6, 'ED8', 'Number of cultural activities on campus'),
(6, 'ED9', 'Number of university sustainability programs with international collaborations'),
(6, 'ED10', 'Number of community services related to sustainability organized by university and involving students'),
(6, 'ED11', 'Number of sustainability-related startups'),
(6, 'ED12', 'Percentage of number of graduates with green jobs (for the last 3 years)'),
(6, 'ED13', 'Availability of unit or office that coordinate sustainability on campus'),
(6, 'ED14', 'Planning, implementation, monitoring and/or evaluation of university governance through the utilization of Information and Communication Technology (ICT)');
