<?php
session_set_cookie_params(0); 
session_start();
$session_timeout = 4800;
if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $session_timeout)) {
    session_unset();
    session_destroy();
    header("Location: login.php");
    exit;
}
$_SESSION['last_activity'] = time();

if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
  <html>
  <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>UI GreenMetric Dashboard</title>
    <link rel="stylesheet" href="dashboard.css">
  </head>
  <body>
    <div class="topnav">
      <a class="active" href="./home.php">Home</a>
      <a href="./dashboard_si.php">SI</a>
      <a href="./dashboard_ec.php">EC</a>
      <a href="./dashboard_ws.php">WS</a>
      <a href="./dashboard_wr.php">WR</a>
      <a href="./dashboard_tr.php">TR</a>
      <a href="./dashboard_ed.php">ED</a>
      <a href="./about.php">About</a>
    </div>
    
    <h2>Welcome, <?php echo $_SESSION['username']; ?>!</h2>
    <a href="logout.php" style="color: rgb(255, 255, 255)">Logout</a>
    <h1>UI GreenMetric - Monitoring & Evaluation Dashboard</h1>
    <br>
    <a></a>
    <div class="topnav">
      <a href="./dashboard_si.php">Dashboard SI</a>
      <br>
      <a href="./dashboard_ec.php">Dashboard EC</a>
      <br>
      <a href="./dashboard_ws.php">Dashboard WS</a>
      <br>
      <a href="./dashboard_wr.php">Dashboard WR</a>
      <br>
      <a href="./dashboard_tr.php">Dashboard TR</a>
      <br>
      <a href="./dashboard_ed.php">Dashboard ED</a>
      <br>
    </div>
  </body>
</html>
<!-- 
            // // send values to server to save SI.1 result
            // try {
            //   const payload = {
            //     total_area: parseFloat(value1_si1) || 0,
            //     ground_floor_area: parseFloat(value2_si1) || 0,
            //     percent: (!isNaN(percent) && isFinite(percent)) ? parseFloat(percent) : null
            //   };

            //   fetch('save_si1.php', {
            //     method: 'POST',
            //     credentials: 'same-origin',
            //     headers: { 'Content-Type': 'application/json' },
            //     body: JSON.stringify(payload)
            //   })
            //   .then(response => response.json())
            //   .then(data => {
            //     if (data && data.success) {
            //       console.log('SI.1 saved, id:', data.id);
            //     } else {
            //       console.warn('Failed to save SI.1:', data && data.error ? data.error : data);
            //     }
            //   })
            //   .catch(err => console.error('Error saving SI.1:', err));
            // } catch (e) {
            //   console.error(e);
            // } 
-->