<?php
/**
 * File ini dijalankan otomatis setiap awal bulan menggunakan Cron Job
 * Contoh Cron Job: 0 0 1 * * /usr/bin/php /path/to/cron_potong_simpanan.php
 * (Dijalankan setiap tanggal 1 pukul 00:00)
 */

include 'config.php';

$nominal_wajib = 50000;
$tanggal_setor = date('Y-m-d');
$bulan_tahun = date('Y-m');

// Cek apakah sudah dipotong bulan ini
$cek = $conn->query("
    SELECT COUNT(*) as total 
    FROM simpanan 
    WHERE jenis = 'wajib' 
    AND DATE_FORMAT(tanggal_setor, '%Y-%m') = '$bulan_tahun'
");
$result = $cek->fetch_assoc();

if ($result['total'] == 0) {
    // Belum dipotong, lakukan pemotongan
    $anggota = $conn->query("SELECT id_anggota, nama FROM anggota WHERE id_user IS NOT NULL");
    $conn->begin_transaction();
    
    try {
        $sukses_count = 0;
        $log_messages = [];
        
        while ($row = $anggota->fetch_assoc()) {
            $stmt = $conn->prepare("INSERT INTO simpanan (id_anggota, jenis, nominal, tanggal_setor) VALUES (?, 'wajib', ?, ?)");
            $stmt->bind_param("ids", $row['id_anggota'], $nominal_wajib, $tanggal_setor);
            
            if ($stmt->execute()) {
                $sukses_count++;
                $log_messages[] = "Berhasil potong simpanan untuk: " . $row['nama'];
            } else {
                $log_messages[] = "GAGAL potong simpanan untuk: " . $row['nama'];
            }
        }
        
        $conn->commit();
        
        // Simpan log
        $log_file = 'logs/simpanan_wajib_' . date('Y-m') . '.log';
        $log_content = date('Y-m-d H:i:s') . " - Pemotongan Simpanan Wajib\n";
        $log_content .= "Total Anggota Dipotong: $sukses_count\n";
        $log_content .= "Nominal: Rp " . number_format($nominal_wajib, 0, ',', '.') . "\n";
        $log_content .= "Detail:\n" . implode("\n", $log_messages) . "\n\n";
        
        // Buat folder logs jika belum ada
        if (!file_exists('logs')) {
            mkdir('logs', 0755, true);
        }
        
        file_put_contents($log_file, $log_content, FILE_APPEND);
        
        echo "SUCCESS: Pemotongan simpanan wajib berhasil untuk $sukses_count anggota\n";
        
    } catch (Exception $e) {
        $conn->rollback();
        
        // Log error
        $error_log = 'logs/error_' . date('Y-m') . '.log';
        file_put_contents($error_log, date('Y-m-d H:i:s') . " - ERROR: " . $e->getMessage() . "\n", FILE_APPEND);
        
        echo "ERROR: " . $e->getMessage() . "\n";
    }
} else {
    echo "INFO: Simpanan wajib bulan ini sudah dipotong sebelumnya\n";
}

$conn->close();
?>