<?php
session_start();
include 'config.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['role']) || $_SESSION['id_role'] != 7) {
    header("Location: index.php");
    exit;
}

$id_unit = 1; 
$nama_unit = "Simpan Pinjam";

// Proses simpan dana unit
if (isset($_POST['simpan_dana_unit'])) {
    $tahun = intval($_POST['tahun']);
    $bulan = intval($_POST['bulan']);
    $total_dana = floatval($_POST['total_dana']);
    $keterangan = mysqli_real_escape_string($conn, $_POST['keterangan']);
    
    // Pastikan hanya id_unit = 1 yang bisa disimpan
    $stmt_check = $conn->prepare("SELECT id_dana FROM dana_unit WHERE id_unit = 1 AND tahun = ? AND bulan = ?");
    $stmt_check->bind_param("ii", $tahun, $bulan);
    $stmt_check->execute();
    $check_result = $stmt_check->get_result();
    
    if ($check_result->num_rows > 0) {
        $stmt_update = $conn->prepare("UPDATE dana_unit SET total_dana = ?, keterangan = ?, tanggal_input = CURDATE() 
            WHERE id_unit = 1 AND tahun = ? AND bulan = ?");
        $stmt_update->bind_param("dsii", $total_dana, $keterangan, $tahun, $bulan);
        $stmt_update->execute();
    } else {
        $stmt_insert = $conn->prepare("INSERT INTO dana_unit (id_unit, tahun, bulan, total_dana, keterangan, tanggal_input) 
            VALUES (1, ?, ?, ?, ?, CURDATE())");
        $stmt_insert->bind_param("iids", $tahun, $bulan, $total_dana, $keterangan);
        $stmt_insert->execute();
    }
    
    header("Location: dana_unit.php?success=1");
    exit;
}

$tahun_filter = isset($_GET['tahun']) ? intval($_GET['tahun']) : date('Y');
$bulan_nama = ['', 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 
              'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'];
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dana Unit - Koperasi</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {
                            50: '#f5f7ff',
                            500: '#667eea',
                            600: '#5568d3',
                        },
                        purple: {
                            500: '#764ba2',
                        }
                    }
                }
            }
        }
    </script>
    <style>
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0,0,0,0.5);
        }
        .modal.show {
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .modal-content {
            background-color: #fefefe;
            padding: 0;
            border-radius: 1rem;
            width: 90%;
            max-width: 800px;
            max-height: 90vh;
            overflow-y: auto;
            animation: slideDown 0.3s ease-out;
        }
        @keyframes slideDown {
            from {
                transform: translateY(-50px);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }
    </style>
</head>
<body class="bg-gradient-to-br from-primary-500 via-purple-500 to-purple-600 min-h-screen">
    
    <!-- Sidebar -->
    <aside class="fixed top-0 left-0 h-screen w-64 bg-white shadow-2xl z-50 overflow-y-auto">
        <div class="p-6 border-b border-gray-200 bg-gradient-to-r from-primary-500 to-purple-500">
            <div class="flex items-center space-x-3 mb-4">
                <img src="img/logo.png" alt="Logo" class="w-16 h-16 object-contain bg-white rounded-xl p-2 shadow-lg">
                <div>
                    <h2 class="text-white font-bold text-lg">Koperasi</h2>
                    <p class="text-primary-100 text-xs">Unit <?= htmlspecialchars($nama_unit) ?></p>
                </div>
            </div>
            <div class="pt-3 border-t border-primary-400">
                <div class="flex items-center space-x-3">
                    <div class="w-10 h-10 bg-white rounded-lg flex items-center justify-center shadow">
                        <i class="fas fa-user-tie text-primary-600 text-xl"></i>
                    </div>
                    <div>
                        <h3 class="text-white font-bold text-sm">Kepala Unit <?= htmlspecialchars($nama_unit) ?></h3>
                        <p class="text-primary-100 text-xs">Dashboard</p>
                    </div>
                </div>
            </div>
        </div>

        <nav class="p-4 space-y-2">
            <a href="dashboard_kepalaunit_toko.php" class="flex items-center space-x-3 p-3 rounded-lg text-gray-700 hover:bg-gray-100">
                <i class="fas fa-hand-holding-usd w-5"></i>
                <span class="font-medium">Approval Pinjaman</span>
            </a>
            
            <a href="potong_gaji.php" class="flex items-center space-x-3 p-3 rounded-lg text-gray-700 hover:bg-gray-100">
                <i class="fas fa-cut w-5"></i>
                <span class="font-medium">Potong Gaji</span>
            </a>
            
            <a href="input_simpanan_sukarela.php" class="flex items-center space-x-3 p-3 rounded-lg text-gray-700 hover:bg-gray-100">
                <i class="fas fa-hand-holding-heart w-5"></i>
                <span class="font-medium">Simpanan Sukarela</span>
            </a>
            
            <a href="dana_unit.php" class="flex items-center space-x-3 p-3 rounded-lg bg-gradient-to-r from-primary-500 to-purple-500 text-white">
                <i class="fas fa-money-bill-wave w-5"></i>
                <span class="font-medium">Dana Unit</span>
            </a>

            <a href="konfigurasi_shu.php" class="flex items-center space-x-3 p-3 rounded-lg text-gray-700 hover:bg-gray-100">
                <i class="fas fa-chart-pie w-5"></i>
                <span class="font-medium">Konfigurasi SHU</span>
            </a>

            <div class="border-t border-gray-200 my-4"></div>

            <a href="logout.php" class="flex items-center space-x-3 p-3 rounded-lg text-red-600 hover:bg-red-50">
                <i class="fas fa-sign-out-alt w-5"></i>
                <span class="font-medium">Logout</span>
            </a>
        </nav>
    </aside>

    <!-- Main Content -->
    <main class="ml-64 p-8">
        <div class="max-w-7xl mx-auto">
            
            <!-- Header -->
            <div class="mb-8">
                <h1 class="text-4xl font-bold text-white mb-2">
                    Dana Unit <?= $nama_unit ?>
                </h1>
                <p class="text-primary-100">Kelola dana unit simpan pinjam</p>
            </div>

            <?php if (isset($_GET['success'])): ?>
            <div class="mb-6 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded-lg shadow">
                <i class="fas fa-check-circle mr-2"></i>
                Data berhasil disimpan!
            </div>
            <?php endif; ?>

            <!-- Dana Unit Content -->
            <div class="bg-white rounded-2xl shadow-2xl overflow-hidden">
                <div class="bg-gradient-to-r from-primary-500 to-purple-500 p-6 flex justify-between items-center">
                    <h2 class="text-2xl font-bold text-white">
                        <i class="fas fa-money-bill-wave mr-3"></i>Dana Unit <?= $nama_unit ?>
                    </h2>
                    <button onclick="openModalDanaUnit()" class="bg-white text-primary-600 px-6 py-2 rounded-lg font-semibold hover:bg-primary-50 transition">
                        <i class="fas fa-plus mr-2"></i>Input Dana
                    </button>
                </div>
                
                <div class="p-6">
                    <!-- Filter Tahun -->
                    <div class="mb-6">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Filter Tahun</label>
                        <select onchange="window.location.href='?tahun='+this.value" class="px-4 py-2 border rounded-lg focus:ring-2 focus:ring-primary-500">
                            <?php for($y = date('Y'); $y >= 2020; $y--): ?>
                            <option value="<?= $y ?>" <?= $tahun_filter == $y ? 'selected' : '' ?>><?= $y ?></option>
                            <?php endfor; ?>
                        </select>
                    </div>

                    <!-- Summary Card -->
                    <?php
                    // Hanya ambil data untuk id_unit = 1
                    $stmt_total = $conn->prepare("SELECT SUM(total_dana) as total FROM dana_unit 
                        WHERE id_unit = 1 AND tahun = ?");
                    $stmt_total->bind_param("i", $tahun_filter);
                    $stmt_total->execute();
                    $total_result = $stmt_total->get_result();
                    $total_dana = $total_result->fetch_assoc()['total'] ?? 0;
                    ?>
                    <div class="bg-gradient-to-br from-primary-50 to-purple-50 border border-primary-200 rounded-xl p-6 mb-8">
                        <h3 class="text-lg font-bold text-gray-800 mb-2">Total Dana Tahun <?= $tahun_filter ?></h3>
                        <p class="text-4xl font-bold text-primary-600">Rp <?= number_format($total_dana, 0, ',', '.') ?></p>
                    </div>

                    <!-- Tabel Detail -->
                    <div class="overflow-x-auto">
                        <table class="w-full">
                            <thead>
                                <tr class="bg-gray-50 border-b-2 border-primary-500">
                                    <th class="px-6 py-4 text-left text-xs font-bold text-gray-700 uppercase">Bulan</th>
                                    <th class="px-6 py-4 text-right text-xs font-bold text-gray-700 uppercase">Total Dana</th>
                                    <th class="px-6 py-4 text-left text-xs font-bold text-gray-700 uppercase">Keterangan</th>
                                    <th class="px-6 py-4 text-left text-xs font-bold text-gray-700 uppercase">Tanggal Input</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-200">
                                <?php
                                // Hanya ambil data untuk id_unit = 1
                                $stmt_detail = $conn->prepare("SELECT * FROM dana_unit 
                                    WHERE id_unit = 1 AND tahun = ? 
                                    ORDER BY bulan DESC");
                                $stmt_detail->bind_param("i", $tahun_filter);
                                $stmt_detail->execute();
                                $dana_detail = $stmt_detail->get_result();
                                
                                if ($dana_detail && $dana_detail->num_rows > 0):
                                    while ($dana = $dana_detail->fetch_assoc()):
                                ?>
                                <tr class="hover:bg-gray-50">
                                    <td class="px-6 py-4 font-semibold"><?= $bulan_nama[$dana['bulan']] ?></td>
                                    <td class="px-6 py-4 text-right">
                                        <span class="text-lg font-bold text-primary-600">Rp <?= number_format($dana['total_dana'], 0, ',', '.') ?></span>
                                    </td>
                                    <td class="px-6 py-4"><?= htmlspecialchars($dana['keterangan']) ?></td>
                                    <td class="px-6 py-4"><?= date('d/m/Y', strtotime($dana['tanggal_input'])) ?></td>
                                </tr>
                                <?php 
                                    endwhile;
                                else:
                                ?>
                                <tr>
                                    <td colspan="4" class="px-6 py-12 text-center text-gray-500">
                                        <i class="fas fa-inbox text-6xl mb-4 text-gray-300"></i>
                                        <p>Belum ada data</p>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </main>

    <!-- Modal Input Dana Unit -->
    <div id="modalDanaUnit" class="modal">
        <div class="modal-content">
            <div class="bg-gradient-to-r from-primary-500 to-purple-500 p-6 rounded-t-xl">
                <div class="flex justify-between items-center">
                    <h3 class="text-2xl font-bold text-white"><i class="fas fa-money-bill-wave mr-2"></i>Input Dana Unit</h3>
                    <button onclick="closeModalDanaUnit()" class="text-white hover:text-gray-200 transition">
                        <i class="fas fa-times text-2xl"></i>
                    </button>
                </div>
            </div>
            
            <form method="POST" class="p-6">
                <div class="space-y-4">
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Tahun</label>
                            <select name="tahun" required class="w-full px-4 py-3 border rounded-lg focus:ring-2 focus:ring-primary-500">
                                <?php for($y = date('Y'); $y >= 2020; $y--): ?>
                                <option value="<?= $y ?>"><?= $y ?></option>
                                <?php endfor; ?>
                            </select>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Bulan</label>
                            <select name="bulan" required class="w-full px-4 py-3 border rounded-lg focus:ring-2 focus:ring-primary-500">
                                <?php for($m = 1; $m <= 12; $m++): ?>
                                <option value="<?= $m ?>"><?= $bulan_nama[$m] ?></option>
                                <?php endfor; ?>
                            </select>
                        </div>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Total Dana (Rp)</label>
                        <input type="number" name="total_dana" step="0.01" required class="w-full px-4 py-3 border rounded-lg focus:ring-2 focus:ring-primary-500" placeholder="Masukkan total dana">
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Keterangan</label>
                        <textarea name="keterangan" rows="3" class="w-full px-4 py-3 border rounded-lg focus:ring-2 focus:ring-primary-500" placeholder="Keterangan..."></textarea>
                    </div>
                    
                    <div class="flex gap-4 mt-6">
                        <button type="button" onclick="closeModalDanaUnit()" class="flex-1 bg-gray-200 text-gray-800 px-6 py-3 rounded-lg font-semibold hover:bg-gray-300 transition">
                            Batal
                        </button>
                        <button type="submit" name="simpan_dana_unit" class="flex-1 bg-gradient-to-r from-primary-500 to-purple-500 text-white px-6 py-3 rounded-lg font-semibold hover:shadow-lg transition">
                            <i class="fas fa-save mr-2"></i>Simpan
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <script>
        function openModalDanaUnit() {
            document.getElementById('modalDanaUnit').classList.add('show');
        }
        
        function closeModalDanaUnit() {
            document.getElementById('modalDanaUnit').classList.remove('show');
        }
        
        window.onclick = function(event) {
            if (event.target.classList.contains('modal')) {
                event.target.classList.remove('show');
            }
        }
    </script>

</body>
</html>