<?php
session_start();
include 'config.php';

// Cek apakah user sudah login dan memiliki role Admin Koperasi
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'Admin Koperasi') {
    header("Location: index.php");
    exit;
}

$username = $_SESSION['username'];

// Ambil data ringkasan untuk dashboard
$totalAnggota = $conn->query("SELECT COUNT(*) AS total FROM anggota")->fetch_assoc()['total'] ?? 0;

// Total Pinjaman hanya yang sudah DISETUJUI
$totalPinjaman = $conn->query("SELECT IFNULL(SUM(jumlah_pinjaman), 0) AS total FROM pinjaman WHERE status = 'disetujui'")->fetch_assoc()['total'] ?? 0;

// Total Simpanan
$totalSimpanan = $conn->query("SELECT IFNULL(SUM(nominal), 0) AS total FROM simpanan")->fetch_assoc()['total'] ?? 0;

// Data untuk chart (Pinjaman pending, disetujui, ditolak)
$pinjamanStatus = $conn->query("SELECT status, COUNT(*) as jumlah FROM pinjaman GROUP BY status");
$statusData = ['pending' => 0, 'disetujui' => 0, 'ditolak' => 0];
while ($row = $pinjamanStatus->fetch_assoc()) {
    $statusData[$row['status']] = $row['jumlah'];
}

// Top 5 Anggota (berdasarkan jumlah pinjaman yang disetujui)
$topAnggota = $conn->query("SELECT a.nama, COUNT(p.id_pinjaman) as jumlah_pinjaman, SUM(p.jumlah_pinjaman) as total_pinjaman FROM anggota a LEFT JOIN pinjaman p ON a.id_anggota = p.id_anggota AND p.status = 'disetujui' GROUP BY a.id_anggota, a.nama HAVING jumlah_pinjaman > 0 ORDER BY total_pinjaman DESC LIMIT 5");

// Aktivitas terbaru (Anggota terbaru)
$anggotaTerbaru = $conn->query("SELECT nama, nip, jabatan, tanggal_masuk FROM anggota ORDER BY tanggal_masuk DESC LIMIT 5");
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Admin - Koperasi PUSDATIN</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.9.1/chart.min.js"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {
                            50: '#f5f7ff',
                            100: '#ebf0ff',
                            200: '#d6e0ff',
                            300: '#b3c7ff',
                            400: '#8ca5ff',
                            500: '#667eea',
                            600: '#5568d3',
                            700: '#4451b8',
                            800: '#343b96',
                            900: '#252b70',
                        },
                        purple: {
                            500: '#764ba2',
                            600: '#653a8f',
                            700: '#54297c',
                        }
                    }
                }
            }
        }
    </script>
    <style>
        @keyframes slideIn {
            from {
                transform: translateX(-100%);
                opacity: 0;
            }
            to {
                transform: translateX(0);
                opacity: 1;
            }
        }
        
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .animate-slide-in {
            animation: slideIn 0.3s ease-out;
        }
        
        .animate-fade-in {
            animation: fadeIn 0.5s ease-out;
        }
        
        .stat-card {
            transition: all 0.3s ease;
        }
        
        .stat-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
        }
        
        .menu-item {
            transition: all 0.3s ease;
        }
        
        .menu-item:hover {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            transform: translateX(8px);
        }
        
        .menu-item:hover i,
        .menu-item:hover span {
            color: white;
        }
        
        .chart-container {
            position: relative;
            height: 300px;
        }
        
        /* Custom Scrollbar */
        ::-webkit-scrollbar {
            width: 8px;
            height: 8px;
        }
        
        ::-webkit-scrollbar-track {
            background: #f1f1f1;
            border-radius: 10px;
        }
        
        ::-webkit-scrollbar-thumb {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 10px;
        }
        
        ::-webkit-scrollbar-thumb:hover {
            background: #5568d3;
        }
    </style>
</head>
<body class="bg-gradient-to-br from-primary-500 via-purple-500 to-purple-600 min-h-screen">
    
    <!-- Mobile Menu Toggle -->
    <button id="mobileMenuBtn" class="fixed top-4 left-4 z-50 lg:hidden bg-white rounded-lg p-3 shadow-lg">
        <i class="fas fa-bars text-primary-600 text-xl"></i>
    </button>

    <!-- Sidebar -->
    <aside id="sidebar" class="fixed left-0 top-0 h-full w-64 bg-white shadow-2xl z-40 transform -translate-x-full lg:translate-x-0 transition-transform duration-300 ease-in-out">
        <!-- Logo & Brand -->
        <div class="p-6 border-b border-gray-200">
            <div class="flex items-center space-x-3">
                <div class="w-12 h-12 bg-gradient-to-br from-primary-500 to-purple-600 rounded-xl flex items-center justify-center overflow-hidden">
                    <img src="img/logo.png" alt="Logo Pusdatin" class="w-full h-full object-cover">
                </div>
                <div>
                    <h1 class="text-xl font-bold bg-gradient-to-r from-primary-600 to-purple-600 bg-clip-text text-transparent">
                        PUSDATIN
                    </h1>
                    <p class="text-xs text-gray-500">Koperasi Admin</p>
                </div>
            </div>
        </div>

        <!-- User Profile -->
        <div class="p-6 border-b border-gray-200">
            <div class="flex items-center space-x-3">
                <div class="w-12 h-12 bg-gradient-to-br from-primary-400 to-purple-500 rounded-full flex items-center justify-center">
                    <span class="text-white font-bold text-lg"><?= strtoupper(substr($username, 0, 1)) ?></span>
                </div>
                <div class="flex-1">
                    <p class="text-sm font-semibold text-gray-800"><?= htmlspecialchars($username) ?></p>
                    <p class="text-xs text-gray-500">Administrator</p>
                </div>
            </div>
        </div>

        <!-- Navigation Menu -->
        <nav class="p-4 space-y-2 overflow-y-auto" style="max-height: calc(100vh - 280px);">
            <a href="dashboard_admin.php" class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg bg-gradient-to-r from-primary-500 to-purple-600 text-white">
                <i class="fas fa-home text-lg w-6"></i>
                <span class="font-medium">Dashboard</span>
            </a>
            
            <a href="kelola_anggota.php" class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg text-gray-700 hover:text-white">
                <i class="fas fa-users text-lg w-6"></i>
                <span class="font-medium">Kelola Anggota</span>
            </a>

            <div class="border-t border-gray-200 my-4"></div>

            <a href="logout.php" class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg text-red-600 hover:bg-red-600 hover:text-white">
                <i class="fas fa-sign-out-alt text-lg w-6"></i>
                <span class="font-medium">Logout</span>
            </a>
        </nav>
    </aside>

    <!-- Main Content -->
    <main class="lg:ml-64 min-h-screen">
        <!-- Header -->
        <header class="bg-white bg-opacity-95 backdrop-blur-lg shadow-lg sticky top-0 z-30">
            <div class="px-6 py-4">
                <div class="flex items-center justify-between">
                    <div>
                        <h2 class="text-2xl font-bold text-gray-800">Dashboard Overview</h2>
                        <p class="text-gray-600 text-sm mt-1">Selamat datang di panel administrasi Koperasi PUSDATIN</p>
                    </div>
                    <div class="flex items-center space-x-4">
                        <div class="hidden md:flex items-center space-x-2 bg-primary-50 px-4 py-2 rounded-lg">
                            <i class="fas fa-calendar text-primary-600"></i>
                            <span class="text-sm text-gray-700"><?= date('d F Y') ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </header>

        <!-- Content Area -->
        <div class="p-6 space-y-6">
            
            <!-- Statistics Cards -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <!-- Card 1 -->
                <div class="stat-card bg-gradient-to-br from-blue-500 to-blue-600 rounded-2xl shadow-xl p-6 text-white">
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-14 h-14 bg-white bg-opacity-20 rounded-xl flex items-center justify-center">
                            <i class="fas fa-users text-3xl"></i>
                        </div>
                        <div class="text-right">
                            <p class="text-sm opacity-80">Total</p>
                            <p class="text-xs opacity-70">Anggota</p>
                        </div>
                    </div>
                    <h3 class="text-4xl font-bold mb-2"><?= number_format($totalAnggota, 0, ',', '.') ?></h3>
                    <p class="text-sm opacity-90">Anggota Terdaftar</p>
                </div>

                <!-- Card 2 -->
                <div class="stat-card bg-gradient-to-br from-green-500 to-emerald-600 rounded-2xl shadow-xl p-6 text-white">
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-14 h-14 bg-white bg-opacity-20 rounded-xl flex items-center justify-center">
                            <i class="fas fa-piggy-bank text-3xl"></i>
                        </div>
                        <div class="text-right">
                            <p class="text-sm opacity-80">Total</p>
                            <p class="text-xs opacity-70">Simpanan</p>
                        </div>
                    </div>
                    <h3 class="text-3xl font-bold mb-2">Rp <?= number_format($totalSimpanan, 0, ',', '.') ?></h3>
                    <p class="text-sm opacity-90">Dana Tersimpan</p>
                </div>

                <!-- Card 3 -->
                <div class="stat-card bg-gradient-to-br from-orange-500 to-red-600 rounded-2xl shadow-xl p-6 text-white">
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-14 h-14 bg-white bg-opacity-20 rounded-xl flex items-center justify-center">
                            <i class="fas fa-hand-holding-usd text-3xl"></i>
                        </div>
                        <div class="text-right">
                            <p class="text-sm opacity-80">Total</p>
                            <p class="text-xs opacity-70">Pinjaman</p>
                        </div>
                    </div>
                    <h3 class="text-3xl font-bold mb-2">Rp <?= number_format($totalPinjaman, 0, ',', '.') ?></h3>
                    <p class="text-sm opacity-90">Pinjaman Disetujui</p>
                </div>
            </div>

            <!-- Charts and Top Members -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                <!-- Chart Status Pinjaman -->
                <div class="bg-white rounded-2xl shadow-xl p-6">
                    <div class="flex items-center justify-between mb-6">
                        <h3 class="text-xl font-bold text-gray-800">Status Pinjaman</h3>
                        <div class="w-10 h-10 bg-primary-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-chart-pie text-primary-600"></i>
                        </div>
                    </div>
                    <div class="chart-container">
                        <canvas id="chartStatus"></canvas>
                    </div>
                    <div class="grid grid-cols-3 gap-4 mt-6">
                        <div class="text-center p-3 bg-yellow-50 rounded-lg">
                            <div class="flex items-center justify-center mb-2">
                                <div class="w-3 h-3 bg-yellow-500 rounded-full mr-2"></div>
                                <span class="text-xs font-semibold text-gray-600">Pending</span>
                            </div>
                            <p class="text-2xl font-bold text-yellow-600"><?= $statusData['pending'] ?></p>
                        </div>
                        <div class="text-center p-3 bg-green-50 rounded-lg">
                            <div class="flex items-center justify-center mb-2">
                                <div class="w-3 h-3 bg-green-500 rounded-full mr-2"></div>
                                <span class="text-xs font-semibold text-gray-600">Disetujui</span>
                            </div>
                            <p class="text-2xl font-bold text-green-600"><?= $statusData['disetujui'] ?></p>
                        </div>
                        <div class="text-center p-3 bg-red-50 rounded-lg">
                            <div class="flex items-center justify-center mb-2">
                                <div class="w-3 h-3 bg-red-500 rounded-full mr-2"></div>
                                <span class="text-xs font-semibold text-gray-600">Ditolak</span>
                            </div>
                            <p class="text-2xl font-bold text-red-600"><?= $statusData['ditolak'] ?></p>
                        </div>
                    </div>
                </div>

                <!-- Top 5 Anggota -->
                <div class="bg-white rounded-2xl shadow-xl p-6">
                    <div class="flex items-center justify-between mb-6">
                        <h3 class="text-xl font-bold text-gray-800">Top 5 Anggota Peminjam</h3>
                        <div class="w-10 h-10 bg-yellow-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-trophy text-yellow-600"></i>
                        </div>
                    </div>
                    <div class="space-y-4">
                        <?php $ranking = 1; ?>
                        <?php while ($row = $topAnggota->fetch_assoc()): ?>
                            <div class="flex items-center space-x-4 p-4 bg-gradient-to-r from-primary-50 to-purple-50 rounded-xl hover:shadow-md transition-shadow">
                                <div class="flex-shrink-0">
                                    <div class="w-12 h-12 bg-gradient-to-br from-primary-500 to-purple-600 rounded-full flex items-center justify-center text-white font-bold text-lg">
                                        <?= $ranking++ ?>
                                    </div>
                                </div>
                                <div class="flex-1">
                                    <h4 class="font-semibold text-gray-800"><?= htmlspecialchars($row['nama']) ?></h4>
                                    <p class="text-sm text-gray-500"><?= $row['jumlah_pinjaman'] ?> Pinjaman Aktif</p>
                                </div>
                                <div class="text-right">
                                    <p class="font-bold text-primary-600">Rp <?= number_format($row['total_pinjaman'], 0, ',', '.') ?></p>
                                </div>
                            </div>
                        <?php endwhile; ?>
                        <?php if ($topAnggota->num_rows == 0): ?>
                            <div class="text-center text-gray-500 py-8">
                                <i class="fas fa-inbox text-4xl mb-3"></i>
                                <p>Belum ada data peminjam</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Anggota Terbaru -->
            <div class="bg-white rounded-2xl shadow-xl p-6">
                <div class="flex items-center justify-between mb-6">
                    <div class="flex items-center space-x-3">
                        <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-user-plus text-blue-600"></i>
                        </div>
                        <h3 class="text-xl font-bold text-gray-800">Anggota Terbaru</h3>
                    </div>
                    <span class="bg-blue-100 text-blue-800 text-xs font-semibold px-3 py-1 rounded-full">
                        <?= $anggotaTerbaru->num_rows ?> Anggota Baru
                    </span>
                </div>
                
                <?php if ($anggotaTerbaru->num_rows > 0): ?>
                    <div class="overflow-x-auto">
                        <table class="w-full">
                            <thead>
                                <tr class="border-b border-gray-200">
                                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">No</th>
                                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Nama Anggota</th>
                                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">NIP</th>
                                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Jabatan</th>
                                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Tanggal Masuk</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-100">
                                <?php $no = 1; while ($row = $anggotaTerbaru->fetch_assoc()): ?>
                                    <tr class="hover:bg-gray-50 transition-colors">
                                        <td class="px-4 py-4">
                                            <span class="font-semibold text-gray-800"><?= $no++ ?></span>
                                        </td>
                                        <td class="px-4 py-4">
                                            <div class="flex items-center space-x-3">
                                                <div class="w-10 h-10 bg-gradient-to-br from-primary-400 to-purple-500 rounded-full flex items-center justify-center text-white font-semibold">
                                                    <?= strtoupper(substr($row['nama'], 0, 1)) ?>
                                                </div>
                                                <span class="font-medium text-gray-800"><?= htmlspecialchars($row['nama']) ?></span>
                                            </div>
                                        </td>
                                        <td class="px-4 py-4">
                                            <code class="bg-gray-100 px-2 py-1 rounded text-sm"><?= htmlspecialchars($row['nip']) ?></code>
                                        </td>
                                        <td class="px-4 py-4">
                                            <span class="text-gray-700"><?= htmlspecialchars($row['jabatan']) ?></span>
                                        </td>
                                        <td class="px-4 py-4">
                                            <span class="text-gray-600"><?= date('d/m/Y', strtotime($row['tanggal_masuk'])) ?></span>
                                        </td>
                                    </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="bg-blue-50 border border-blue-200 rounded-xl p-6 text-center">
                        <i class="fas fa-info-circle text-blue-500 text-4xl mb-3"></i>
                        <p class="text-blue-700 font-medium">Belum ada anggota terbaru</p>
                    </div>
                <?php endif; ?>
            </div>

        </div>
    </main>

    <script>
        // Mobile Menu Toggle
        const mobileMenuBtn = document.getElementById('mobileMenuBtn');
        const sidebar = document.getElementById('sidebar');
        
        mobileMenuBtn.addEventListener('click', () => {
            sidebar.classList.toggle('-translate-x-full');
        });

        // Close sidebar when clicking outside on mobile
        document.addEventListener('click', (e) => {
            if (window.innerWidth < 1024) {
                if (!sidebar.contains(e.target) && !mobileMenuBtn.contains(e.target)) {
                    sidebar.classList.add('-translate-x-full');
                }
            }
        });

        // Chart Status Pinjaman
        const ctxStatus = document.getElementById('chartStatus').getContext('2d');
        const chartStatus = new Chart(ctxStatus, {
            type: 'doughnut',
            data: {
                labels: ['Pending', 'Disetujui', 'Ditolak'],
                datasets: [{
                    data: [
                        <?= $statusData['pending'] ?>,
                        <?= $statusData['disetujui'] ?>,
                        <?= $statusData['ditolak'] ?>
                    ],
                    backgroundColor: [
                        '#f59e0b',
                        '#10b981',
                        '#ef4444'
                    ],
                    borderColor: '#ffffff',
                    borderWidth: 3,
                    borderRadius: 8,
                    spacing: 2
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    },
                    tooltip: {
                        backgroundColor: 'rgba(0, 0, 0, 0.8)',
                        padding: 12,
                        cornerRadius: 8,
                        titleFont: {
                            size: 14,
                            weight: 'bold'
                        },
                        bodyFont: {
                            size: 13
                        }
                    }
                },
                cutout: '70%'
            }
        });
    </script>

</body>
</html>