<?php
session_start();
include 'config.php';

// Pastikan role adalah anggota
if (!isset($_SESSION['role']) || $_SESSION['role'] != 'Anggota') {
    header("Location: index.php");
    exit;
}

$id_anggota = $_SESSION['id_anggota'];

// Aktifkan error mysqli agar mudah debugging
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

// Query untuk mendapatkan data anggota
$anggotaQuery = "SELECT nama, nip, jabatan FROM anggota WHERE id_anggota = ?";
$stmt = $conn->prepare($anggotaQuery);
$stmt->bind_param("i", $id_anggota);
$stmt->execute();
$anggotaData = $stmt->get_result()->fetch_assoc();

// Query simpanan wajib
$simpananWajibQuery = "SELECT IFNULL(SUM(nominal),0) AS total FROM simpanan WHERE id_anggota = ? AND jenis = 'wajib'";
$stmt1 = $conn->prepare($simpananWajibQuery);
$stmt1->bind_param("i", $id_anggota);
$stmt1->execute();
$simpananWajib = $stmt1->get_result()->fetch_assoc()['total'] ?? 0;

// Query simpanan sukarela
$simpananSukarelaQuery = "SELECT IFNULL(SUM(nominal),0) AS total FROM simpanan WHERE id_anggota = ? AND jenis = 'sukarela'";
$stmt2 = $conn->prepare($simpananSukarelaQuery);
$stmt2->bind_param("i", $id_anggota);
$stmt2->execute();
$simpananSukarela = $stmt2->get_result()->fetch_assoc()['total'] ?? 0;

// Total simpananF
$totalSimpanan = $simpananWajib + $simpananSukarela;

// Query total pinjaman
$totalPinjamanQuery = "SELECT IFNULL(SUM(jumlah_pinjaman),0) AS total FROM pinjaman WHERE id_anggota = ? AND status = 'disetujui'";
$stmt3 = $conn->prepare($totalPinjamanQuery);
$stmt3->bind_param("i", $id_anggota);
$stmt3->execute();
$totalPinjaman = $stmt3->get_result()->fetch_assoc()['total'] ?? 0;
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Anggota - Koperasi Pusdatin</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#667eea',
                        secondary: '#764ba2',
                    }
                }
            }
        }
    </script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap');
        body {
            font-family: 'Inter', sans-serif;
        }
    </style>
</head>
<body class="bg-gradient-to-br from-purple-50 to-blue-50">
    
    <!-- Sidebar -->
    <aside id="sidebar" class="fixed top-0 left-0 z-40 w-64 h-screen transition-transform -translate-x-full sm:translate-x-0">
        <div class="h-full px-3 py-4 overflow-y-auto bg-gradient-to-b from-purple-600 to-indigo-700 shadow-2xl">
            <!-- Logo Section -->
            <div class="flex flex-col items-center mb-8 pb-6 border-b border-white/20">
                <div class="w-24 h-24 bg-white rounded-full flex items-center justify-center mb-3 shadow-lg">
                    <!-- Tempat Logo - Ganti src dengan path logo Anda -->
                    <img src="img/logo.png" alt="Logo Koperasi" class="w-20 h-20 object-contain" onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">
                    <i class="fas fa-university text-purple-600 text-4xl hidden"></i>
                </div>
                <h2 class="text-white font-bold text-lg text-center">Koperasi Pusdatin</h2>
                <p class="text-purple-200 text-xs mt-1">Sistem Informasi Koperasi</p>
            </div>

            <!-- Profile Section -->
            <div class="mb-6 p-4 bg-white/10 rounded-lg backdrop-blur-sm">
                <div class="flex items-center space-x-3">
                    <div class="w-12 h-12 bg-white rounded-full flex items-center justify-center">
                        <i class="fas fa-user text-purple-600 text-xl"></i>
                    </div>
                    <div class="flex-1 min-w-0">
                        <p class="text-white font-semibold text-sm truncate"><?= htmlspecialchars($anggotaData['nama'] ?? 'Anggota') ?></p>
                        <p class="text-purple-200 text-xs truncate"><?= htmlspecialchars($anggotaData['nip'] ?? '-') ?></p>
                    </div>
                </div>
            </div>

            <!-- Navigation Menu -->
            <nav class="space-y-2">
                <a href="dashboard_anggota.php" class="flex items-center p-3 text-white bg-white/20 rounded-lg hover:bg-white/30 transition-all duration-200 group">
                    <i class="fas fa-home w-6 text-center group-hover:scale-110 transition-transform"></i>
                    <span class="ml-3 font-medium">Dashboard</span>
                </a>
                
                <a href="ajukan_pinjaman.php" class="flex items-center p-3 text-white rounded-lg hover:bg-white/20 transition-all duration-200 group">
                    <i class="fas fa-money-bill-wave w-6 text-center group-hover:scale-110 transition-transform"></i>
                    <span class="ml-3 font-medium">Ajukan Pinjaman</span>
                </a>
                
                <a href="status_pinjaman.php" class="flex items-center p-3 text-white rounded-lg hover:bg-white/20 transition-all duration-200 group">
                    <i class="fas fa-file-contract w-6 text-center group-hover:scale-110 transition-transform"></i>
                    <span class="ml-3 font-medium">Status Pinjaman</span>
                </a>
                
                <a href="lihat_transaksi_defmart.php" class="flex items-center p-3 text-white rounded-lg hover:bg-white/20 transition-all duration-200 group">
                    <i class="fas fa-shopping-cart w-6 text-center group-hover:scale-110 transition-transform"></i>
                    <span class="ml-3 font-medium">Transaksi Defmart</span>
                </a>
                
                <a href="lihat_shu.php" class="flex items-center p-3 text-white rounded-lg hover:bg-white/20 transition-all duration-200 group">
                    <i class="fas fa-chart-line w-6 text-center group-hover:scale-110 transition-transform"></i>
                    <span class="ml-3 font-medium">Pembagian SHU</span>
                </a>

                <div class="pt-4 mt-4 border-t border-white/20">
                    <a href="logout.php" class="flex items-center p-3 text-white rounded-lg hover:bg-red-500/30 transition-all duration-200 group">
                        <i class="fas fa-sign-out-alt w-6 text-center group-hover:scale-110 transition-transform"></i>
                        <span class="ml-3 font-medium">Logout</span>
                    </a>
                </div>
            </nav>
        </div>
    </aside>

    <!-- Main Content -->
    <div class="sm:ml-64">
        <!-- Top Navbar -->
        <nav class="bg-white shadow-md sticky top-0 z-30">
            <div class="px-4 py-3 lg:px-6">
                <div class="flex items-center justify-between">
                    <button id="toggleSidebar" class="inline-flex items-center p-2 text-sm text-gray-500 rounded-lg sm:hidden hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-gray-200">
                        <i class="fas fa-bars text-xl"></i>
                    </button>
                    <h1 class="text-xl font-bold text-gray-800">Dashboard Anggota</h1>
                    <div class="flex items-center space-x-4">
                        <span class="text-sm text-gray-600 hidden md:block">
                            <i class="far fa-calendar-alt mr-2"></i>
                            <?= date('d F Y') ?>
                        </span>
                    </div>
                </div>
            </div>
        </nav>

        <!-- Main Content Area -->
        <div class="p-4 lg:p-6">
            <!-- Welcome Card -->
            <div class="bg-gradient-to-r from-purple-600 to-indigo-600 rounded-2xl shadow-xl p-6 mb-6 text-white">
                <div class="flex items-center justify-between">
                    <div>
                        <h2 class="text-2xl font-bold mb-2">
                            <i class="fas fa-hand-sparkles mr-2"></i>
                            Selamat Datang, <?= htmlspecialchars($anggotaData['nama'] ?? 'Anggota') ?>!
                        </h2>
                        <p class="opacity-90 mb-1">
                            <i class="fas fa-id-card mr-2"></i>
                            NIP: <?= htmlspecialchars($anggotaData['nip'] ?? '-') ?>
                        </p>
                        <p class="opacity-90">
                            <i class="fas fa-briefcase mr-2"></i>
                            Jabatan: <?= htmlspecialchars($anggotaData['jabatan'] ?? '-') ?>
                        </p>
                    </div>
                    <div class="hidden md:block">
                        <i class="fas fa-user-tie text-8xl opacity-20"></i>
                    </div>
                </div>
            </div>

            <!-- Statistics Cards -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
                <!-- Simpanan Wajib Card -->
                <div class="bg-white rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 overflow-hidden group">
                    <div class="p-6">
                        <div class="flex items-center justify-between mb-4">
                            <div class="p-3 bg-green-100 rounded-lg group-hover:scale-110 transition-transform">
                                <i class="fas fa-wallet text-green-600 text-2xl"></i>
                            </div>
                            <span class="text-xs font-semibold text-green-600 bg-green-100 px-3 py-1 rounded-full">WAJIB</span>
                        </div>
                        <h3 class="text-gray-500 text-sm font-medium mb-2">Simpanan Wajib</h3>
                        <p class="text-2xl font-bold text-gray-800 mb-1">Rp <?= number_format($simpananWajib, 0, ',', '.') ?></p>
                        <p class="text-xs text-gray-400">
                            <i class="fas fa-info-circle mr-1"></i>
                            Simpanan rutin bulanan
                        </p>
                    </div>
                    <div class="bg-green-50 px-6 py-3">
                        <p class="text-xs text-green-700">
                            <i class="fas fa-chart-line mr-1"></i>
                            Konsisten menabung
                        </p>
                    </div>
                </div>

                <!-- Simpanan Sukarela Card -->
                <div class="bg-white rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 overflow-hidden group">
                    <div class="p-6">
                        <div class="flex items-center justify-between mb-4">
                            <div class="p-3 bg-blue-100 rounded-lg group-hover:scale-110 transition-transform">
                                <i class="fas fa-piggy-bank text-blue-600 text-2xl"></i>
                            </div>
                            <span class="text-xs font-semibold text-blue-600 bg-blue-100 px-3 py-1 rounded-full">SUKARELA</span>
                        </div>
                        <h3 class="text-gray-500 text-sm font-medium mb-2">Simpanan Sukarela</h3>
                        <p class="text-2xl font-bold text-gray-800 mb-1">Rp <?= number_format($simpananSukarela, 0, ',', '.') ?></p>
                        <p class="text-xs text-gray-400">
                            <i class="fas fa-info-circle mr-1"></i>
                            Simpanan tambahan
                        </p>
                    </div>
                    <div class="bg-blue-50 px-6 py-3">
                        <p class="text-xs text-blue-700">
                            <i class="fas fa-hand-holding-heart mr-1"></i>
                            Tabungan fleksibel
                        </p>
                    </div>
                </div>

                <!-- Total Simpanan Card -->
                <div class="bg-white rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 overflow-hidden group">
                    <div class="p-6">
                        <div class="flex items-center justify-between mb-4">
                            <div class="p-3 bg-purple-100 rounded-lg group-hover:scale-110 transition-transform">
                                <i class="fas fa-coins text-purple-600 text-2xl"></i>
                            </div>
                            <span class="text-xs font-semibold text-purple-600 bg-purple-100 px-3 py-1 rounded-full">TOTAL</span>
                        </div>
                        <h3 class="text-gray-500 text-sm font-medium mb-2">Total Simpanan</h3>
                        <p class="text-2xl font-bold text-gray-800 mb-1">Rp <?= number_format($totalSimpanan, 0, ',', '.') ?></p>
                        <p class="text-xs text-gray-400">
                            <i class="fas fa-info-circle mr-1"></i>
                            Akumulasi simpanan
                        </p>
                    </div>
                    <div class="bg-purple-50 px-6 py-3">
                        <p class="text-xs text-purple-700">
                            <i class="fas fa-arrow-up mr-1"></i>
                            Saldo keseluruhan
                        </p>
                    </div>
                </div>

                <!-- Total Pinjaman Card -->
                <div class="bg-white rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 overflow-hidden group">
                    <div class="p-6">
                        <div class="flex items-center justify-between mb-4">
                            <div class="p-3 bg-red-100 rounded-lg group-hover:scale-110 transition-transform">
                                <i class="fas fa-credit-card text-red-600 text-2xl"></i>
                            </div>
                            <span class="text-xs font-semibold text-red-600 bg-red-100 px-3 py-1 rounded-full">AKTIF</span>
                        </div>
                        <h3 class="text-gray-500 text-sm font-medium mb-2">Total Pinjaman</h3>
                        <p class="text-2xl font-bold text-gray-800 mb-1">Rp <?= number_format($totalPinjaman, 0, ',', '.') ?></p>
                        <p class="text-xs text-gray-400">
                            <i class="fas fa-info-circle mr-1"></i>
                            Pinjaman disetujui
                        </p>
                    </div>
                    <div class="bg-red-50 px-6 py-3">
                        <p class="text-xs text-red-700">
                            <i class="fas fa-clock mr-1"></i>
                            Bayar tepat waktu
                        </p>
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="bg-white rounded-xl shadow-lg p-6">
                <h3 class="text-lg font-bold text-gray-800 mb-6 flex items-center">
                    <i class="fas fa-bolt text-yellow-500 mr-2"></i>
                    Aksi Cepat
                </h3>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                    <a href="ajukan_pinjaman.php" class="flex flex-col items-center p-6 bg-gradient-to-br from-purple-50 to-purple-100 rounded-xl hover:shadow-lg transition-all duration-300 group border-2 border-transparent hover:border-purple-300">
                        <div class="w-16 h-16 bg-purple-500 rounded-full flex items-center justify-center mb-3 group-hover:scale-110 transition-transform">
                            <i class="fas fa-money-bill-wave text-white text-2xl"></i>
                        </div>
                        <h4 class="font-semibold text-gray-800 mb-1">Ajukan Pinjaman</h4>
                        <p class="text-xs text-gray-500 text-center">Buat pengajuan baru</p>
                    </a>

                    <a href="status_pinjaman.php" class="flex flex-col items-center p-6 bg-gradient-to-br from-green-50 to-green-100 rounded-xl hover:shadow-lg transition-all duration-300 group border-2 border-transparent hover:border-green-300">
                        <div class="w-16 h-16 bg-green-500 rounded-full flex items-center justify-center mb-3 group-hover:scale-110 transition-transform">
                            <i class="fas fa-file-contract text-white text-2xl"></i>
                        </div>
                        <h4 class="font-semibold text-gray-800 mb-1">Status Pinjaman</h4>
                        <p class="text-xs text-gray-500 text-center">Cek status pengajuan</p>
                    </a>

                    <a href="lihat_transaksi_defmart.php" class="flex flex-col items-center p-6 bg-gradient-to-br from-blue-50 to-blue-100 rounded-xl hover:shadow-lg transition-all duration-300 group border-2 border-transparent hover:border-blue-300">
                        <div class="w-16 h-16 bg-blue-500 rounded-full flex items-center justify-center mb-3 group-hover:scale-110 transition-transform">
                            <i class="fas fa-shopping-cart text-white text-2xl"></i>
                        </div>
                        <h4 class="font-semibold text-gray-800 mb-1">Transaksi Defmart</h4>
                        <p class="text-xs text-gray-500 text-center">Riwayat belanja</p>
                    </a>

                    <a href="lihat_shu.php" class="flex flex-col items-center p-6 bg-gradient-to-br from-orange-50 to-orange-100 rounded-xl hover:shadow-lg transition-all duration-300 group border-2 border-transparent hover:border-orange-300">
                        <div class="w-16 h-16 bg-orange-500 rounded-full flex items-center justify-center mb-3 group-hover:scale-110 transition-transform">
                            <i class="fas fa-chart-line text-white text-2xl"></i>
                        </div>
                        <h4 class="font-semibold text-gray-800 mb-1">Pembagian SHU</h4>
                        <p class="text-xs text-gray-500 text-center">Lihat SHU Anda</p>
                    </a>
                </div>
            </div>

            <!-- Footer -->
            <div class="mt-8 text-center text-gray-500 text-sm">
                <p>&copy; 2025 Koperasi Pusdatin. All rights reserved.</p>
            </div>
        </div>
    </div>

    <script>
        // Toggle sidebar untuk mobile
        const sidebar = document.getElementById('sidebar');
        const toggleButton = document.getElementById('toggleSidebar');
        
        toggleButton.addEventListener('click', () => {
            sidebar.classList.toggle('-translate-x-full');
        });

        // Close sidebar when clicking outside on mobile
        document.addEventListener('click', (e) => {
            if (window.innerWidth < 640) {
                if (!sidebar.contains(e.target) && !toggleButton.contains(e.target)) {
                    sidebar.classList.add('-translate-x-full');
                }
            }
        });
    </script>
</body>
</html>