<?php
session_start();
include 'config.php';

// Cek apakah user sudah login dan memiliki role Kasir Defmart
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'Kasir Defmart') {
    header("Location: index.php");
    exit;
}

$id_user = $_SESSION['id_user'];
$username = $_SESSION['username'];

// Filter
$filter_bulan = isset($_GET['filter_bulan']) ? $_GET['filter_bulan'] : date('Y-m');

// Hitung statistik untuk bulan yang dipilih
$query_stats = "SELECT 
                COUNT(*) as total_transaksi,
                SUM(total_harga) as total_pendapatan,
                AVG(total_harga) as rata_rata
                FROM defmart_transaksi
                WHERE DATE_FORMAT(tanggal_transaksi, '%Y-%m') = ?";

$stmt_stats = $conn->prepare($query_stats);
if (!$stmt_stats) {
    die("Prepare statement gagal: " . $conn->error);
}
$stmt_stats->bind_param("s", $filter_bulan);
$stmt_stats->execute();
$stats = $stmt_stats->get_result()->fetch_assoc();

// Ambil total dana masuk Defmart dari tabel unit (keseluruhan)
$query_unit = "SELECT total_dana_masuk FROM unit WHERE nama_unit = 'Defmart'";
$result_unit = $conn->query($query_unit);
$unit_row = $result_unit->fetch_assoc();
$total_dana_defmart = $unit_row['total_dana_masuk'] ?? 0;

// Ambil data dana_unit untuk bulan yang dipilih
$tahun_filter = date('Y', strtotime($filter_bulan . '-01'));
$bulan_filter = date('n', strtotime($filter_bulan . '-01'));

$query_dana_unit = "SELECT du.*, u.nama_unit 
                    FROM dana_unit du 
                    JOIN unit u ON du.id_unit = u.id_unit 
                    WHERE u.nama_unit = 'Defmart' AND du.tahun = ? AND du.bulan = ?";
$stmt_dana_unit = $conn->prepare($query_dana_unit);
if (!$stmt_dana_unit) {
    die("Prepare statement gagal: " . $conn->error);
}
$stmt_dana_unit->bind_param("ii", $tahun_filter, $bulan_filter);
$stmt_dana_unit->execute();
$dana_unit_result = $stmt_dana_unit->get_result();
$dana_unit_data = $dana_unit_result->fetch_assoc();
$total_dana_bulan = $dana_unit_data['total_dana'] ?? 0;

// Ambil total potongan gaji Bon untuk bulan yang dipilih
$bulan_periode_filter = date('Y-m-01', strtotime($filter_bulan . '-01'));
$query_total_bon = "SELECT SUM(jumlah) as total_bon FROM potongan_gaji 
                    WHERE sumber = 'Defmart' AND bulan_periode = ? AND status = 'pending'";
$stmt_total_bon = $conn->prepare($query_total_bon);
if (!$stmt_total_bon) {
    die("Prepare statement gagal: " . $conn->error);
}
$stmt_total_bon->bind_param("s", $bulan_periode_filter);
$stmt_total_bon->execute();
$total_bon_result = $stmt_total_bon->get_result();
$total_bon_data = $total_bon_result->fetch_assoc();
$total_bon = $total_bon_data['total_bon'] ?? 0;

// Ambil transaksi terbaru (5 terakhir) untuk quick view
$query_latest = "SELECT dt.*, a.nama FROM defmart_transaksi dt 
                LEFT JOIN anggota a ON dt.id_anggota = a.id_anggota 
                WHERE DATE_FORMAT(dt.tanggal_transaksi, '%Y-%m') = ?
                ORDER BY dt.tanggal_transaksi DESC 
                LIMIT 5";
$stmt_latest = $conn->prepare($query_latest);
$stmt_latest->bind_param("s", $filter_bulan);
$stmt_latest->execute();
$latest_result = $stmt_latest->get_result();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Kasir - Koperasi PUSDATIN</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .gradient-primary { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
        .gradient-hover { transition: all 0.3s ease; }
        .gradient-hover:hover { transform: translateY(-2px); box-shadow: 0 10px 30px rgba(102, 126, 234, 0.3); }
    </style>
</head>
<body class="bg-gray-100">

<!-- Sidebar -->
<?php include 'sidebar_kasir.php'; ?>

<!-- Main Content -->
<div class="ml-64 min-h-screen">
    <!-- Top Bar -->
    <div class="bg-white shadow-sm sticky top-0 z-30">
        <div class="px-6 py-4 flex justify-between items-center">
            <h1 class="text-2xl font-bold text-gray-800">Dashboard Kasir Defmart</h1>
            <div class="flex items-center space-x-4">
                <i class="fas fa-bell text-gray-400 cursor-pointer hover:text-gray-600 text-xl"></i>
            </div>
        </div>
    </div>

    <!-- Content Area -->
    <div class="p-6">
        <!-- Filter Section -->
        <div class="bg-white rounded-xl shadow-sm p-6 mb-6">
            <h3 class="text-lg font-semibold text-gray-800 mb-4">Periode</h3>
            <div class="flex gap-4 items-end">
                <div class="flex-1">
                    <label class="block text-sm font-medium text-gray-700 mb-2">Pilih Bulan</label>
                    <input type="month" id="filter_bulan" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent" value="<?= $filter_bulan ?>">
                </div>
                <button onclick="applyFilter()" class="px-6 py-2 gradient-primary text-white font-semibold rounded-lg hover:shadow-lg transition">
                    <i class="fas fa-filter mr-2"></i>Terapkan
                </button>
            </div>
        </div>

        <!-- Statistics Row -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
            <div class="gradient-primary text-white rounded-xl p-6 gradient-hover">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-white text-opacity-75 text-sm">Total Transaksi</p>
                        <p class="text-3xl font-bold mt-2"><?= $stats['total_transaksi'] ?? 0 ?></p>
                        <p class="text-xs text-white text-opacity-60 mt-1">Bulan ini</p>
                    </div>
                    <i class="fas fa-exchange-alt text-4xl text-white text-opacity-30"></i>
                </div>
            </div>

            <div class="gradient-primary text-white rounded-xl p-6 gradient-hover" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-white text-opacity-75 text-sm">Pendapatan</p>
                        <p class="text-2xl font-bold mt-2">Rp <?= number_format($total_dana_bulan, 0, ',', '.') ?></p>
                        <p class="text-xs text-white text-opacity-60 mt-1">Bulan ini</p>
                    </div>
                    <i class="fas fa-calendar-alt text-4xl text-white text-opacity-30"></i>
                </div>
            </div>

            <div class="gradient-primary text-white rounded-xl p-6 gradient-hover" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-white text-opacity-75 text-sm">Rata-rata</p>
                        <p class="text-2xl font-bold mt-2">Rp <?= number_format($stats['rata_rata'] ?? 0, 0, ',', '.') ?></p>
                        <p class="text-xs text-white text-opacity-60 mt-1">Per transaksi</p>
                    </div>
                    <i class="fas fa-chart-bar text-4xl text-white text-opacity-30"></i>
                </div>
            </div>

            <div class="gradient-primary text-white rounded-xl p-6 gradient-hover" style="background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-white text-opacity-75 text-sm">Total Bon</p>
                        <p class="text-2xl font-bold mt-2">Rp <?= number_format($total_bon, 0, ',', '.') ?></p>
                        <p class="text-xs text-white text-opacity-60 mt-1">Belum dibayar</p>
                    </div>
                    <i class="fas fa-receipt text-4xl text-white text-opacity-30"></i>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
            <a href="tambah_transaksi_kasir.php" class="bg-white rounded-xl p-6 shadow-sm hover:shadow-lg transition border-2 border-transparent hover:border-blue-500">
                <div class="flex items-center space-x-4">
                    <div class="w-12 h-12 rounded-full gradient-primary flex items-center justify-center">
                        <i class="fas fa-plus text-white text-xl"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-gray-800">Transaksi Baru</h3>
                        <p class="text-sm text-gray-500">Tambah transaksi penjualan</p>
                    </div>
                </div>
            </a>

            <a href="riwayat_transaksi_kasir.php" class="bg-white rounded-xl p-6 shadow-sm hover:shadow-lg transition border-2 border-transparent hover:border-purple-500">
                <div class="flex items-center space-x-4">
                    <div class="w-12 h-12 rounded-full bg-purple-500 flex items-center justify-center">
                        <i class="fas fa-history text-white text-xl"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-gray-800">Riwayat Lengkap</h3>
                        <p class="text-sm text-gray-500">Lihat semua transaksi</p>
                    </div>
                </div>
            </a>

            <a href="barang_terlaris_kasir.php" class="bg-white rounded-xl p-6 shadow-sm hover:shadow-lg transition border-2 border-transparent hover:border-red-500">
                <div class="flex items-center space-x-4">
                    <div class="w-12 h-12 rounded-full bg-red-500 flex items-center justify-center">
                        <i class="fas fa-fire text-white text-xl"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-gray-800">Barang Terlaris</h3>
                        <p class="text-sm text-gray-500">Lihat produk populer</p>
                    </div>
                </div>
            </a>
        </div>

        <!-- Transaksi Terbaru -->
        <div class="bg-white rounded-xl shadow-sm overflow-hidden">
            <div class="p-6 border-b border-gray-200 flex justify-between items-center">
                <h3 class="text-lg font-semibold text-gray-800">
                    <i class="fas fa-clock mr-2 text-blue-500"></i>5 Transaksi Terbaru
                </h3>
                <a href="riwayat_transaksi_kasir.php" class="text-blue-600 hover:text-blue-700 font-semibold text-sm">
                    Lihat Semua <i class="fas fa-arrow-right ml-1"></i>
                </a>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead>
                        <tr class="bg-gray-50 border-b border-gray-200">
                            <th class="px-6 py-3 text-left text-sm font-semibold text-gray-700">Tanggal</th>
                            <th class="px-6 py-3 text-left text-sm font-semibold text-gray-700">Anggota</th>
                            <th class="px-6 py-3 text-left text-sm font-semibold text-gray-700">Barang</th>
                            <th class="px-6 py-3 text-left text-sm font-semibold text-gray-700">Qty</th>
                            <th class="px-6 py-3 text-left text-sm font-semibold text-gray-700">Total</th>
                            <th class="px-6 py-3 text-left text-sm font-semibold text-gray-700">Pembayaran</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        <?php while ($row = $latest_result->fetch_assoc()): ?>
                            <tr class="hover:bg-gray-50 transition">
                                <td class="px-6 py-4 text-sm text-gray-600"><?= date('d/m/Y H:i', strtotime($row['tanggal_transaksi'])) ?></td>
                                <td class="px-6 py-4 text-sm text-gray-600"><?= htmlspecialchars($row['nama'] ?? '-') ?></td>
                                <td class="px-6 py-4 text-sm text-gray-600"><?= htmlspecialchars($row['nama_barang']) ?></td>
                                <td class="px-6 py-4 text-sm text-gray-600"><?= $row['qty'] ?></td>
                                <td class="px-6 py-4 text-sm font-semibold text-gray-900">Rp <?= number_format($row['total_harga'], 0, ',', '.') ?></td>
                                <td class="px-6 py-4 text-sm">
                                    <?php if ($row['metode_pembayaran'] === 'Bon'): ?>
                                        <span class="px-3 py-1 rounded-full text-white text-xs font-semibold bg-orange-500">
                                            <i class="fas fa-receipt mr-1"></i>Bon
                                        </span>
                                    <?php else: ?>
                                        <span class="px-3 py-1 rounded-full text-white text-xs font-semibold gradient-primary">
                                            Cash
                                        </span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
                <?php if ($latest_result->num_rows == 0): ?>
                    <div class="p-6 text-center text-gray-500">
                        <i class="fas fa-inbox text-4xl mb-3 block text-gray-300"></i>
                        Belum ada transaksi bulan ini
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
    function applyFilter() {
        const bulan = document.getElementById('filter_bulan').value;
        window.location.href = `?filter_bulan=${bulan}`;
    }
</script>

</body>
</html>