<?php

session_start();

include 'config.php';

error_reporting(E_ALL);

ini_set('display_errors', 1);

if (!isset($_SESSION['role']) || $_SESSION['id_role'] != 7) {

header("Location: index.php");

exit;

}

$id_unit = 1;

$nama_unit = "Simpan Pinjam";

// Proses approve/reject pinjaman

if (isset($_POST['approve_pinjaman']) || isset($_POST['reject_pinjaman'])) {

$id_pinjaman = intval($_POST['id_pinjaman']);

$catatan = mysqli_real_escape_string($conn, $_POST['catatan'] ?? '');

$id_user = $_SESSION['id_user'];


$stmt_check = $conn->prepare("SELECT jumlah_pinjaman FROM pinjaman WHERE id_pinjaman = ?");

$stmt_check->bind_param("i", $id_pinjaman);

$stmt_check->execute();

$check_result = $stmt_check->get_result();


if ($check_result && $check_result->num_rows > 0) {

$pinjaman_data = $check_result->fetch_assoc();

$jumlah_pinjaman = $pinjaman_data['jumlah_pinjaman'];


if ($jumlah_pinjaman > 10000000) {

header("Location: dashboard_kepalaunit_toko.php?error=overlimit");

exit;

}


if (isset($_POST['approve_pinjaman'])) {

$persentase_bulanan = floatval($_POST['persentase_bulanan']);

$bunga_persen = floatval($_POST['bunga_persen']);


$stmt = $conn->prepare("UPDATE pinjaman SET

status = 'disetujui',

approved_by_kepalaunit = ?,

tanggal_approve_kepalaunit = NOW(),

catatan_kepalaunit = ?,

persentase_bulanan = ?,

bunga_persen = ?

WHERE id_pinjaman = ?");

$stmt->bind_param("isddi", $id_user, $catatan, $persentase_bulanan, $bunga_persen, $id_pinjaman);

$stmt->execute();


header("Location: dashboard_kepalaunit_toko.php?success=approve");

} else {

$stmt = $conn->prepare("UPDATE pinjaman SET

status = 'ditolak',

approved_by_kepalaunit = ?,

tanggal_approve_kepalaunit = NOW(),

catatan_kepalaunit = ?

WHERE id_pinjaman = ?");

$stmt->bind_param("isi", $id_user, $catatan, $id_pinjaman);

$stmt->execute();


header("Location: dashboard_kepalaunit_toko.php?success=reject");

}

}

exit;

}

// Ambil daftar pinjaman untuk approval

$sql_pinjaman = "SELECT p.*, a.nama, a.nip

FROM pinjaman p

JOIN anggota a ON p.id_anggota = a.id_anggota

WHERE p.status = 'pending' AND p.jumlah_pinjaman <= 10000000

ORDER BY p.tanggal_pengajuan DESC";

$result_pinjaman = $conn->query($sql_pinjaman);

?>

<!DOCTYPE html>

<html lang="id">

<head>

<meta charset="UTF-8">

<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Dashboard Kepala Unit <?= $nama_unit ?> - Koperasi</title>

<script src="https://cdn.tailwindcss.com"></script>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

<script>



tailwind.config = {

theme: {

extend: {

colors: {

primary: {

50: '#f5f7ff',

500: '#667eea',

600: '#5568d3',

},

purple: {

500: '#764ba2',

}

}

}

}

}

</script>

<style>

/* Modal Styles */
.modal {
    display: none;
    position: fixed;
    z-index: 1000;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    overflow: auto;
    background-color: rgba(0, 0, 0, 0.6);
    backdrop-filter: blur(5px);
    animation: fadeIn 0.3s ease-in;
}

.modal.show {
    display: flex;
    align-items: center;
    justify-content: center;
}

.modal-content {
    background-color: #fefefe;
    margin: auto;
    border-radius: 15px;
    width: 90%;
    max-width: 900px;
    max-height: 90vh;
    overflow-y: auto;
    box-shadow: 0 10px 40px rgba(0, 0, 0, 0.3);
    animation: slideIn 0.3s ease-out;
}

@keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
}

@keyframes slideIn {
    from {
        transform: translateY(-50px);
        opacity: 0;
    }
    to {
        transform: translateY(0);
        opacity: 1;
    }
}

/* Scrollbar Styling */
.modal-content::-webkit-scrollbar {
    width: 8px;
}

.modal-content::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 10px;
}

.modal-content::-webkit-scrollbar-thumb {
    background: #888;
    border-radius: 10px;
}

.modal-content::-webkit-scrollbar-thumb:hover {
    background: #555;
}

</style>

</head>

<body class="bg-gradient-to-br from-primary-500 via-purple-500 to-purple-600 min-h-screen">

<!-- Sidebar -->
<aside class="fixed top-0 left-0 h-screen w-64 bg-white shadow-2xl z-50 overflow-y-auto">
    <div class="p-6 border-b border-gray-200 bg-gradient-to-r from-primary-500 to-purple-500">
        <div class="flex items-center space-x-3 mb-4">
            <img src="img/logo.png" alt="Logo" class="w-16 h-16 object-contain bg-white rounded-xl p-2 shadow-lg">
            <div>
                <h2 class="text-white font-bold text-lg">Koperasi</h2>
                <p class="text-primary-100 text-xs">Unit <?= htmlspecialchars($nama_unit) ?></p>
            </div>
        </div>
        <div class="pt-3 border-t border-primary-400">
            <div class="flex items-center space-x-3">
                <div class="w-10 h-10 bg-white rounded-lg flex items-center justify-center shadow">
                    <i class="fas fa-user-tie text-primary-600 text-xl"></i>
                </div>
                <div>
                    <h3 class="text-white font-bold text-sm">Kepala Unit <?= htmlspecialchars($nama_unit) ?></h3>
                    <p class="text-primary-100 text-xs">Dashboard</p>
                </div>
            </div>
        </div>
    </div>

    <nav class="p-4 space-y-2">
        <a href="dashboard_kepalaunit_toko.php" class="flex items-center space-x-3 p-3 rounded-lg bg-gradient-to-r from-primary-500 to-purple-500 text-white">
            <i class="fas fa-hand-holding-usd w-5"></i>
            <span class="font-medium">Approval Pinjaman</span>
            <?php 
            $stmt_count = $conn->prepare("SELECT COUNT(*) as total FROM pinjaman WHERE status = 'pending' AND jumlah_pinjaman <= 10000000");
            $stmt_count->execute();
            $count_result = $stmt_count->get_result();
            $count_pending = $count_result->fetch_assoc()['total'];
            if ($count_pending > 0):
            ?>
            <span class="ml-auto bg-red-500 text-white text-xs font-bold px-2 py-1 rounded-full"><?= $count_pending ?></span>
            <?php endif; ?>
        </a>
        
        <a href="potong_gaji.php" class="flex items-center space-x-3 p-3 rounded-lg text-gray-700 hover:bg-gray-100">
            <i class="fas fa-cut w-5"></i>
            <span class="font-medium">Potong Gaji</span>
        </a>
        
        <a href="input_simpanan_sukarela.php" class="flex items-center space-x-3 p-3 rounded-lg text-gray-700 hover:bg-gray-100">
            <i class="fas fa-hand-holding-heart w-5"></i>
            <span class="font-medium">Simpanan Sukarela</span>
        </a>
        
        <a href="dana_unit.php" class="flex items-center space-x-3 p-3 rounded-lg text-gray-700 hover:bg-gray-100">
            <i class="fas fa-money-bill-wave w-5"></i>
            <span class="font-medium">Dana Unit</span>
        </a>

        <a href="konfigurasi_shu.php" class="flex items-center space-x-3 p-3 rounded-lg text-gray-700 hover:bg-gray-100">
            <i class="fas fa-chart-pie w-5"></i>
            <span class="font-medium">Konfigurasi SHU</span>
        </a>

        <div class="border-t border-gray-200 my-4"></div>

        <a href="logout.php" class="flex items-center space-x-3 p-3 rounded-lg text-red-600 hover:bg-red-50">
            <i class="fas fa-sign-out-alt w-5"></i>
            <span class="font-medium">Logout</span>
        </a>
    </nav>
</aside>

<!-- Main Content -->
<main class="ml-64 p-8">
    <div class="max-w-7xl mx-auto">
        
        <!-- Header -->
        <div class="mb-8">
            <h1 class="text-4xl font-bold text-white mb-2">
                Dashboard Unit <?= $nama_unit ?>
            </h1>
            <p class="text-primary-100">Kelola pinjaman anggota</p>
        </div>

        <?php if (isset($_GET['success'])): ?>
        <div class="mb-6 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded-lg shadow">
            <i class="fas fa-check-circle mr-2"></i>
            <?php if ($_GET['success'] == 'approve'): ?>
                Pinjaman berhasil disetujui!
            <?php elseif ($_GET['success'] == 'reject'): ?>
                Pinjaman berhasil ditolak!
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <?php if (isset($_GET['error'])): ?>
        <div class="mb-6 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg shadow">
            <i class="fas fa-exclamation-circle mr-2"></i>
            <?php if ($_GET['error'] == 'overlimit'): ?>
                Anda hanya dapat menyetujui pinjaman maksimal Rp 10.000.000! Pinjaman di atas 10 juta harus disetujui oleh Kepala Unit Simpan Pinjam Khusus.
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <!-- Approval Pinjaman Content -->
        <div class="bg-white rounded-2xl shadow-2xl overflow-hidden">
            <div class="bg-gradient-to-r from-green-500 to-teal-500 p-6">
                <h2 class="text-2xl font-bold text-white">
                    <i class="fas fa-hand-holding-usd mr-3"></i>Approval Pinjaman Anggota
                </h2>
                <p class="text-green-100 text-sm mt-1">Anda dapat menyetujui pinjaman maksimal Rp 10.000.000</p>
            </div>
            
            <div class="p-6">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead>
                            <tr class="bg-gray-50 border-b-2 border-green-500">
                                <th class="px-6 py-4 text-left text-xs font-bold text-gray-700 uppercase">ID</th>
                                <th class="px-6 py-4 text-left text-xs font-bold text-gray-700 uppercase">Anggota</th>
                                <th class="px-6 py-4 text-left text-xs font-bold text-gray-700 uppercase">NIP</th>
                                <th class="px-6 py-4 text-right text-xs font-bold text-gray-700 uppercase">Jumlah Pinjaman</th>
                                <th class="px-6 py-4 text-center text-xs font-bold text-gray-700 uppercase">Tenor</th>
                                <th class="px-6 py-4 text-left text-xs font-bold text-gray-700 uppercase">Tanggal Ajuan</th>
                                <th class="px-6 py-4 text-center text-xs font-bold text-gray-700 uppercase">Aksi</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200">
                            <?php if ($result_pinjaman && $result_pinjaman->num_rows > 0): ?>
                                <?php while ($row = $result_pinjaman->fetch_assoc()): ?>
                                    <tr class="hover:bg-gray-50">
                                        <td class="px-6 py-4 font-semibold">#<?= $row['id_pinjaman'] ?></td>
                                        <td class="px-6 py-4"><?= htmlspecialchars($row['nama']) ?></td>
                                        <td class="px-6 py-4"><?= htmlspecialchars($row['nip']) ?></td>
                                        <td class="px-6 py-4 text-right">
                                            <span class="text-lg font-bold text-green-600">Rp <?= number_format($row['jumlah_pinjaman'], 0, ',', '.') ?></span>
                                        </td>
                                        <td class="px-6 py-4 text-center">
                                            <span class="px-3 py-1 bg-blue-100 text-blue-800 rounded-full text-sm font-semibold"><?= $row['lama_bayar'] ?> bulan</span>
                                        </td>
                                        <td class="px-6 py-4"><?= date('d/m/Y', strtotime($row['tanggal_pengajuan'])) ?></td>
                                        <td class="px-6 py-4">
                                            <div class="flex justify-center space-x-2">
                                                <button onclick="openApprovalModal(<?= $row['id_pinjaman'] ?>)" class="px-4 py-2 bg-blue-500 text-white rounded-lg hover:bg-blue-600 transition">
    <i class="fas fa-eye"></i> Detail
</button>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endwhile; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="7" class="px-6 py-12 text-center text-gray-500">
                                        <i class="fas fa-check-circle text-6xl mb-4 text-gray-300"></i>
                                        <p>Tidak ada pinjaman yang menunggu persetujuan</p>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</main>

<!-- Modal Approval Pinjaman -->
    <div id="modalApproval" class="modal">
        <div class="modal-content">
            <div class="bg-gradient-to-r from-green-500 to-teal-500 p-6 rounded-t-xl">
                <div class="flex justify-between items-center">
                    <h3 class="text-2xl font-bold text-white"><i class="fas fa-file-invoice-dollar mr-2"></i>Detail Pinjaman</h3>
                    <button onclick="closeModalApproval()" class="text-white hover:text-gray-200 transition">
                        <i class="fas fa-times text-2xl"></i>
                    </button>
                </div>
            </div>
            
            <div id="modalContent" class="p-6">
                <!-- Loading state -->
                <div id="loadingState" class="text-center py-8">
                    <i class="fas fa-spinner fa-spin text-4xl text-green-500 mb-4"></i>
                    <p class="text-gray-600">Memuat data...</p>
                </div>
                
                <!-- Content will be loaded here -->
                <div id="detailContent" style="display: none;">
                    <!-- Data Anggota -->
                    <div class="bg-gradient-to-br from-blue-50 to-indigo-50 border-2 border-blue-200 rounded-xl p-6 mb-6">
                        <h4 class="text-lg font-bold text-gray-800 mb-4 flex items-center">
                            <i class="fas fa-user-circle text-blue-500 mr-2"></i>
                            Data Anggota
                        </h4>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <p class="text-sm text-gray-600">Nama Lengkap</p>
                                <p class="font-semibold text-gray-800" id="detail_nama">-</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-600">NIP</p>
                                <p class="font-semibold text-gray-800" id="detail_nip">-</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-600">Jabatan</p>
                                <p class="font-semibold text-gray-800" id="detail_jabatan">-</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-600">Email</p>
                                <p class="font-semibold text-gray-800" id="detail_email">-</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-600">No. Telepon</p>
                                <p class="font-semibold text-gray-800" id="detail_telp">-</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-600">Alamat</p>
                                <p class="font-semibold text-gray-800" id="detail_alamat">-</p>
                            </div>
                        </div>
                    </div>

                    <!-- Data Pinjaman -->
                    <div class="bg-gradient-to-br from-green-50 to-emerald-50 border-2 border-green-200 rounded-xl p-6 mb-6">
                        <h4 class="text-lg font-bold text-gray-800 mb-4 flex items-center">
                            <i class="fas fa-money-bill-wave text-green-500 mr-2"></i>
                            Detail Pinjaman
                        </h4>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div class="bg-white rounded-lg p-4 shadow-sm">
                                <p class="text-sm text-gray-600">Jumlah Pinjaman</p>
                                <p class="text-2xl font-bold text-green-600" id="detail_jumlah">Rp 0</p>
                            </div>
                            <div class="bg-white rounded-lg p-4 shadow-sm">
                                <p class="text-sm text-gray-600">Lama Bayar</p>
                                <p class="text-2xl font-bold text-blue-600" id="detail_tenor">0 bulan</p>
                            </div>
                            <div class="bg-white rounded-lg p-4 shadow-sm">
                                <p class="text-sm text-gray-600">Bunga per Bulan</p>
                                <p class="text-xl font-bold text-orange-600" id="detail_bunga_bulanan">0%</p>
                            </div>
                            <div class="bg-white rounded-lg p-4 shadow-sm">
                                <p class="text-sm text-gray-600">Total Bunga</p>
                                <p class="text-xl font-bold text-orange-600" id="detail_bunga">Rp 0</p>
                            </div>
                            <div class="bg-white rounded-lg p-4 shadow-sm">
                                <p class="text-sm text-gray-600">Persentase Total Bunga</p>
                                <p class="text-xl font-bold text-purple-600" id="detail_bunga_persen">0%</p>
                            </div>
                            <div class="bg-white rounded-lg p-4 shadow-sm">
                                <p class="text-sm text-gray-600">Total Bayar</p>
                                <p class="text-xl font-bold text-purple-600" id="detail_total">Rp 0</p>
                            </div>
                            <div class="bg-white rounded-lg p-4 shadow-sm md:col-span-2">
                                <p class="text-sm text-gray-600">Angsuran per Bulan</p>
                                <p class="text-2xl font-bold text-red-600" id="detail_angsuran">Rp 0</p>
                            </div>
                        </div>
                    </div>

                    <!-- Dokumen Pendukung -->
                    <div class="bg-gradient-to-br from-purple-50 to-pink-50 border-2 border-purple-200 rounded-xl p-6 mb-6">
                        <h4 class="text-lg font-bold text-gray-800 mb-4 flex items-center">
                            <i class="fas fa-file-alt text-purple-500 mr-2"></i>
                            Dokumen Pendukung
                        </h4>
                        <div id="dokumenContainer">
                            <!-- Dokumen akan dimuat di sini -->
                        </div>
                    </div>

                    <!-- Form Approval -->
                    <form method="POST" class="bg-gray-50 rounded-xl p-6" onsubmit="return validateApproval();">
                        <input type="hidden" name="id_pinjaman" id="approval_id_pinjaman">
                        
                        <!-- Setting Bunga -->
                        <div class="bg-gradient-to-br from-yellow-50 to-orange-50 border-2 border-yellow-200 rounded-xl p-6 mb-6">
                            <h4 class="text-lg font-bold text-gray-800 mb-4 flex items-center">
                                <i class="fas fa-percent text-yellow-500 mr-2"></i>
                                Setting Bunga Pinjaman
                            </h4>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        <i class="fas fa-calendar-alt mr-1"></i>
                                        Persentase Bunga per Bulan (%)
                                    </label>
                                    <input type="number" step="0.01" min="0" max="100" name="persentase_bulanan" id="persentase_bulanan" value="1.5" required class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-yellow-500 focus:border-transparent" placeholder="Contoh: 1.5" oninput="hitungUlangBunga()">
                                    <p class="text-xs text-gray-500 mt-1">Default: 1.5% per bulan</p>
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        <i class="fas fa-chart-line mr-1"></i>
                                        Total Persentase Bunga (%)
                                    </label>
                                    <input type="number" step="0.01" min="0" max="1000" name="bunga_persen" id="bunga_persen" value="" readonly class="w-full px-4 py-3 border border-gray-300 rounded-lg bg-gray-100 focus:ring-2 focus:ring-yellow-500 focus:border-transparent" placeholder="Auto calculate">
                                    <p class="text-xs text-gray-500 mt-1">Otomatis dihitung dari persentase bulanan × tenor</p>
                                </div>
                            </div>
                            
                            <!-- Preview Perhitungan -->
                            <div class="mt-4 p-4 bg-white rounded-lg border border-yellow-300">
                                <h5 class="font-semibold text-gray-800 mb-2">Preview Perhitungan:</h5>
                                <div class="grid grid-cols-2 gap-2 text-sm">
                                    <div>
                                        <span class="text-gray-600">Jumlah Pinjaman:</span>
                                        <span class="font-bold text-gray-800 ml-2" id="preview_pinjaman">Rp 0</span>
                                    </div>
                                    <div>
                                        <span class="text-gray-600">Tenor:</span>
                                        <span class="font-bold text-gray-800 ml-2" id="preview_tenor">0 bulan</span>
                                    </div>
                                    <div>
                                        <span class="text-gray-600">Bunga per Bulan:</span>
                                        <span class="font-bold text-orange-600 ml-2" id="preview_bunga_bulanan">0%</span>
                                    </div>
                                    <div>
                                        <span class="text-gray-600">Total Bunga:</span>
                                        <span class="font-bold text-orange-600 ml-2" id="preview_total_bunga">Rp 0</span>
                                    </div>
                                    <div>
                                        <span class="text-gray-600">Total Persentase:</span>
                                        <span class="font-bold text-purple-600 ml-2" id="preview_persen">0%</span>
                                    </div>
                                    <div>
                                        <span class="text-gray-600">Total Bayar:</span>
                                        <span class="font-bold text-red-600 ml-2" id="preview_total_bayar">Rp 0</span>
                                    </div>
                                    <div class="col-span-2">
                                        <span class="text-gray-600">Angsuran per Bulan:</span>
                                        <span class="font-bold text-green-600 ml-2 text-lg" id="preview_angsuran">Rp 0</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="mb-4">
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                <i class="fas fa-comment-alt mr-1"></i>
                                Catatan / Keterangan
                            </label>
                            <textarea name="catatan" rows="4" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-transparent" placeholder="Masukkan catatan (opsional)"></textarea>
                        </div>
                        
                        <div class="flex gap-4 mt-6">
                            <button type="submit" name="reject_pinjaman" class="flex-1 bg-gradient-to-r from-red-500 to-red-600 text-white px-6 py-3 rounded-lg font-semibold hover:from-red-600 hover:to-red-700 transition shadow-lg">
                                <i class="fas fa-times-circle mr-2"></i>Tolak Pinjaman
                            </button>
                            <button type="submit" name="approve_pinjaman" class="flex-1 bg-gradient-to-r from-green-500 to-green-600 text-white px-6 py-3 rounded-lg font-semibold hover:from-green-600 hover:to-green-700 transition shadow-lg">
                                <i class="fas fa-check-circle mr-2"></i>Setujui Pinjaman
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

   <script>
    let currentDokumenUrl = '';
    let currentPinjamanData = null;
    
    function openApprovalModal(id) {
        const modal = document.getElementById('modalApproval');
        modal.classList.add('show');
        document.getElementById('loadingState').style.display = 'block';
        document.getElementById('detailContent').style.display = 'none';
        
        // Fetch detail pinjaman
        fetch(`get_detail_pinjaman.php?id=${id}`)
            .then(response => {
                if (!response.ok) {
                    throw new Error('Network response was not ok');
                }
                return response.json();
            })
            .then(data => {
                if (data.error) {
                    alert('Error: ' + data.error);
                    closeModalApproval();
                    return;
                }
                
                console.log('Data received:', data);
                
                // Simpan data pinjaman untuk perhitungan
                currentPinjamanData = data;
                
                // Set form data
                document.getElementById('approval_id_pinjaman').value = data.id_pinjaman;
                
                // Set anggota data
                document.getElementById('detail_nama').textContent = data.nama || '-';
                document.getElementById('detail_nip').textContent = data.nip || '-';
                document.getElementById('detail_jabatan').textContent = data.jabatan || '-';
                document.getElementById('detail_email').textContent = data.email || '-';
                document.getElementById('detail_telp').textContent = data.no_telp || '-';
                document.getElementById('detail_alamat').textContent = data.alamat || '-';
                
                // Set pinjaman data dengan format currency
                document.getElementById('detail_jumlah').textContent = formatRupiah(data.jumlah_pinjaman);
                document.getElementById('detail_tenor').textContent = data.lama_bayar + ' bulan';
                document.getElementById('detail_bunga_bulanan').textContent = '1.5%';
                document.getElementById('detail_bunga').textContent = formatRupiah(data.bunga_total);
                document.getElementById('detail_bunga_persen').textContent = (1.5 * data.lama_bayar).toFixed(2) + '%';
                document.getElementById('detail_total').textContent = formatRupiah(data.total_bayar);
                document.getElementById('detail_angsuran').textContent = formatRupiah(data.angsuran_per_bulan);
                
                // Set dokumen
                const dokumenContainer = document.getElementById('dokumenContainer');
                if (data.dokumen_pendukung && data.dokumen_url) {
                    currentDokumenUrl = data.dokumen_url;
                    const fileExt = data.dokumen_pendukung.split('.').pop().toLowerCase();
                    
                    if (['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp'].includes(fileExt)) {
                        dokumenContainer.innerHTML = `
                            <div class="bg-white rounded-lg p-4 shadow-sm">
                                <div class="mb-3 text-center">
                                    <img src="${data.dokumen_url}" alt="Dokumen" class="max-w-full h-auto rounded-lg border-2 border-gray-200 mx-auto" style="max-height: 400px;" onerror="this.onerror=null; this.parentElement.innerHTML='<div class=\\'bg-red-50 border-2 border-red-200 rounded-lg p-6 text-center\\'><i class=\\'fas fa-exclamation-circle text-4xl text-red-500 mb-3\\'></i><p class=\\'text-gray-700 font-semibold\\'>Gagal memuat gambar</p><p class=\\'text-sm text-gray-600 mt-1\\'>File mungkin tidak ditemukan atau rusak</p></div>';">
                                </div>
                                <div class="flex gap-2">
                                    <a href="${data.dokumen_url}" target="_blank" class="flex-1 bg-blue-500 text-white px-4 py-2 rounded-lg hover:bg-blue-600 transition text-center">
                                        <i class="fas fa-external-link-alt mr-2"></i>Buka di Tab Baru
                                    </a>
                                    <a href="${data.dokumen_url}" download="${data.dokumen_pendukung}" class="flex-1 bg-green-500 text-white px-4 py-2 rounded-lg hover:bg-green-600 transition text-center">
                                        <i class="fas fa-download mr-2"></i>Download
                                    </a>
                                </div>
                            </div>
                        `;
                    } else if (fileExt === 'pdf') {
                        dokumenContainer.innerHTML = `
                            <div class="bg-white rounded-lg p-4 shadow-sm">
                                <div class="mb-3 bg-gray-100 rounded-lg overflow-hidden" style="height: 500px;">
                                    <iframe src="${data.dokumen_url}#toolbar=0" class="w-full h-full border-0" onerror="this.style.display='none'; this.parentElement.innerHTML='<div class=\\'bg-red-50 border-2 border-red-200 rounded-lg p-6 text-center h-full flex flex-col items-center justify-center\\'><i class=\\'fas fa-exclamation-circle text-4xl text-red-500 mb-3\\'></i><p class=\\'text-gray-700 font-semibold\\'>Gagal memuat PDF</p><p class=\\'text-sm text-gray-600 mt-1\\'>File mungkin tidak ditemukan atau rusak</p></div>';"></iframe>
                                </div>
                                <div class="flex gap-2">
                                    <a href="${data.dokumen_url}" target="_blank" class="flex-1 bg-blue-500 text-white px-4 py-2 rounded-lg hover:bg-blue-600 transition text-center">
                                        <i class="fas fa-external-link-alt mr-2"></i>Buka di Tab Baru
                                    </a>
                                    <a href="${data.dokumen_url}" download="${data.dokumen_pendukung}" class="flex-1 bg-green-500 text-white px-4 py-2 rounded-lg hover:bg-green-600 transition text-center">
                                        <i class="fas fa-download mr-2"></i>Download
                                    </a>
                                </div>
                            </div>
                        `;
                    } else {
                        dokumenContainer.innerHTML = `
                            <div class="bg-white rounded-lg p-6 shadow-sm text-center">
                                <i class="fas fa-file-alt text-6xl text-gray-400 mb-4"></i>
                                <p class="text-gray-700 mb-2 font-semibold">${data.dokumen_pendukung}</p>
                                <p class="text-sm text-gray-500 mb-4">File dengan ekstensi .${fileExt}</p>
                                <div class="flex gap-2 justify-center">
                                    <a href="${data.dokumen_url}" target="_blank" class="bg-blue-500 text-white px-6 py-3 rounded-lg hover:bg-blue-600 transition">
                                        <i class="fas fa-external-link-alt mr-2"></i>Buka di Tab Baru
                                    </a>
                                    <a href="${data.dokumen_url}" download="${data.dokumen_pendukung}" class="bg-green-500 text-white px-6 py-3 rounded-lg hover:bg-green-600 transition">
                                        <i class="fas fa-download mr-2"></i>Download
                                    </a>
                                </div>
                            </div>
                        `;
                    }
                } else {
                    dokumenContainer.innerHTML = `
                        <div class="bg-yellow-50 border-2 border-yellow-200 rounded-lg p-6 text-center">
                            <i class="fas fa-exclamation-triangle text-4xl text-yellow-500 mb-3"></i>
                            <p class="text-gray-700 font-semibold">Tidak ada dokumen pendukung</p>
                            <p class="text-sm text-gray-600 mt-1">Anggota tidak mengupload dokumen pendukung</p>
                        </div>
                    `;
                }
                
                // Hitung ulang bunga dengan default 1.5%
                hitungUlangBunga();
                
                // Show content
                document.getElementById('loadingState').style.display = 'none';
                document.getElementById('detailContent').style.display = 'block';
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Terjadi kesalahan saat memuat data: ' + error.message);
                closeModalApproval();
            });
    }
    
    function hitungUlangBunga() {
        if (!currentPinjamanData) return;
        
        const persentaseBulanan = parseFloat(document.getElementById('persentase_bulanan').value) || 1.5;
        const jumlahPinjaman = currentPinjamanData.jumlah_pinjaman;
        const lamaBayar = currentPinjamanData.lama_bayar;
        
        // Hitung bunga total
        const bungaTotal = (jumlahPinjaman * persentaseBulanan / 100) * lamaBayar;
        const bungaPersen = persentaseBulanan * lamaBayar;
        const totalBayar = jumlahPinjaman + bungaTotal;
        const angsuranPerBulan = totalBayar / lamaBayar;
        
        // Update field bunga_persen
        document.getElementById('bunga_persen').value = bungaPersen.toFixed(2);
        
        // Update preview
        document.getElementById('preview_pinjaman').textContent = formatRupiah(jumlahPinjaman);
        document.getElementById('preview_tenor').textContent = lamaBayar + ' bulan';
        document.getElementById('preview_bunga_bulanan').textContent = persentaseBulanan.toFixed(2) + '%';
        document.getElementById('preview_total_bunga').textContent = formatRupiah(bungaTotal);
        document.getElementById('preview_persen').textContent = bungaPersen.toFixed(2) + '%';
        document.getElementById('preview_total_bayar').textContent = formatRupiah(totalBayar);
        document.getElementById('preview_angsuran').textContent = formatRupiah(angsuranPerBulan);
        
        // Update detail section
        document.getElementById('detail_bunga_bulanan').textContent = persentaseBulanan.toFixed(2) + '%';
        document.getElementById('detail_bunga').textContent = formatRupiah(bungaTotal);
        document.getElementById('detail_bunga_persen').textContent = bungaPersen.toFixed(2) + '%';
        document.getElementById('detail_total').textContent = formatRupiah(totalBayar);
        document.getElementById('detail_angsuran').textContent = formatRupiah(angsuranPerBulan);
    }
    
    function validateApproval() {
        const persentaseBulanan = parseFloat(document.getElementById('persentase_bulanan').value);
        
        if (isNaN(persentaseBulanan) || persentaseBulanan < 0) {
            alert('Persentase bunga per bulan harus diisi dengan angka yang valid!');
            return false;
        }
        
        if (persentaseBulanan > 100) {
            alert('Persentase bunga per bulan tidak boleh lebih dari 100%!');
            return false;
        }
        
        return confirm('Apakah Anda yakin dengan keputusan ini?');
    }
    
    function closeModalApproval() {
        document.getElementById('modalApproval').classList.remove('show');
        currentDokumenUrl = '';
        currentPinjamanData = null;
    }
    
    function formatRupiah(angka) {
        return 'Rp ' + Math.round(angka).toLocaleString('id-ID');
    }
    
    // Close modal when clicking outside
    window.onclick = function(event) {
        const modal = document.getElementById('modalApproval');
        if (event.target === modal) {
            closeModalApproval();
        }
    }
    
    // Close modal with ESC key
    document.addEventListener('keydown', function(event) {
        if (event.key === 'Escape') {
            closeModalApproval();
        }
    });
</script>

</body>
</html>