<?php
session_start();
include 'config.php';

// Cek apakah user login dan role = Kepala Unit Toko (id_role = 2)
if (!isset($_SESSION['role']) || $_SESSION['id_role'] != 2) {
    header("Location: index.php");
    exit;
}

$id_unit = 2; // Unit Defmart
$nama_unit = "Defmart";

// Proses validasi transaksi toko
if (isset($_GET['action']) && isset($_GET['id_transaksi'])) {
    $id_transaksi = intval($_GET['id_transaksi']);
    $action = $_GET['action'];

    if ($action == 'approve') {
        $conn->query("UPDATE transaksi_defmart SET status = 'Divalidasi' WHERE id_transaksi = $id_transaksi");
    } elseif ($action == 'reject') {
        $conn->query("UPDATE transaksi_defmart SET status = 'Ditolak' WHERE id_transaksi = $id_transaksi");
    }

    header("Location: dashboard_kepalaunit_toko.php");
    exit;
}

// Proses simpan dana unit
if (isset($_POST['simpan_dana_unit'])) {
    $tahun = $_POST['tahun'];
    $bulan = $_POST['bulan'];
    $total_dana = $_POST['total_dana'];
    $keterangan = $_POST['keterangan'];
    
    $conn->query("INSERT INTO dana_unit (id_unit, tahun, bulan, total_dana, keterangan, tanggal_input) 
        VALUES ('$id_unit', '$tahun', '$bulan', '$total_dana', '$keterangan', CURDATE())
        ON DUPLICATE KEY UPDATE total_dana='$total_dana', keterangan='$keterangan'");
    
    // Update total dana di tabel unit
    $conn->query("UPDATE unit SET total_dana_masuk = (
        SELECT SUM(total_dana) FROM dana_unit WHERE id_unit = '$id_unit'
    ) WHERE id_unit = '$id_unit'");
    
    header("Location: dashboard_kepalaunit_toko.php?menu=dana_unit&success=1");
    exit;
}

// Proses sinkronisasi data transaksi Defmart ke dana unit
if (isset($_POST['sinkronisasi_defmart'])) {
    $tahun = $_POST['tahun_sync'];
    $bulan = $_POST['bulan_sync'];
    
    // Ambil total transaksi Defmart per bulan
    $query_transaksi = $conn->query("SELECT SUM(total_harga) as total_transaksi 
        FROM transaksi_defmart 
        WHERE YEAR(tanggal_transaksi) = '$tahun' AND MONTH(tanggal_transaksi) = '$bulan' AND status = 'Divalidasi'");
    
    if ($query_transaksi && $query_transaksi->num_rows > 0) {
        $row = $query_transaksi->fetch_assoc();
        $total_transaksi = $row['total_transaksi'] ?? 0;
        
        if ($total_transaksi > 0) {
            $keterangan = "Transaksi Defmart bulan " . date('F Y', strtotime("$tahun-$bulan-01"));
            
            $conn->query("INSERT INTO dana_unit (id_unit, tahun, bulan, total_dana, keterangan, tanggal_input) 
                VALUES ('$id_unit', '$tahun', '$bulan', '$total_transaksi', '$keterangan', CURDATE())
                ON DUPLICATE KEY UPDATE total_dana='$total_transaksi', keterangan='$keterangan'");
            
            $conn->query("UPDATE unit SET total_dana_masuk = (
                SELECT SUM(total_dana) FROM dana_unit WHERE id_unit = '$id_unit'
            ) WHERE id_unit = '$id_unit'");
            
            header("Location: dashboard_kepalaunit_toko.php?menu=dana_unit&success=1&sync=1");
            exit;
        }
    }
    
    header("Location: dashboard_kepalaunit_toko.php?menu=dana_unit&error=1");
    exit;
}

// Ambil daftar transaksi yang perlu divalidasi
$sql = "SELECT t.*, a.nama 
        FROM transaksi_defmart t
        JOIN anggota a ON t.id_anggota = a.id_anggota
        ORDER BY t.tanggal_transaksi DESC";
$result = $conn->query($sql);

$active_menu = isset($_GET['menu']) ? $_GET['menu'] : 'validasi_transaksi';
$tahun_filter = isset($_GET['tahun']) ? $_GET['tahun'] : date('Y');
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Kepala Unit <?= $nama_unit ?> - Koperasi</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {
                            50: '#f5f7ff',
                            500: '#667eea',
                            600: '#5568d3',
                        },
                        purple: {
                            500: '#764ba2',
                        }
                    }
                }
            }
        }
    </script>
    <style>
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0,0,0,0.5);
        }
        .modal.show {
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .modal-content {
            background-color: #fefefe;
            padding: 0;
            border-radius: 1rem;
            width: 90%;
            max-width: 800px;
            max-height: 90vh;
            overflow-y: auto;
        }
    </style>
</head>
<body class="bg-gradient-to-br from-primary-500 via-purple-500 to-purple-600 min-h-screen">
    
    <!-- Sidebar -->
    <aside class="fixed top-0 left-0 h-screen w-64 bg-white shadow-2xl z-50 overflow-y-auto">
        <div class="p-6 border-b border-gray-200 bg-gradient-to-r from-primary-500 to-purple-500">
            <div class="flex items-center space-x-3 mb-4">
                <img src="img/logo.png" alt="Logo" class="w-16 h-16 object-contain bg-white rounded-xl p-2 shadow-lg">
                <div>
                    <h2 class="text-white font-bold text-lg">Koperasi</h2>
                    <p class="text-primary-100 text-xs">Unit <?= $nama_unit ?></p>
                </div>
            </div>
            <div class="pt-3 border-t border-primary-400">
                <div class="flex items-center space-x-3">
                    <div class="w-10 h-10 bg-white rounded-lg flex items-center justify-center shadow">
                        <i class="fas fa-store text-primary-600 text-xl"></i>
                    </div>
                    <div>
                        <h3 class="text-white font-bold text-sm">Kepala Unit <?= $nama_unit ?></h3>
                        <p class="text-primary-100 text-xs">Dashboard</p>
                    </div>
                </div>
            </div>
        </div>

        <nav class="p-4 space-y-2">
            <a href="dashboard_kepalaunit_toko.php?menu=validasi_transaksi" class="flex items-center space-x-3 p-3 rounded-lg <?= $active_menu == 'validasi_transaksi' ? 'bg-gradient-to-r from-primary-500 to-purple-500 text-white' : 'text-gray-700 hover:bg-gray-100' ?>">
                <i class="fas fa-check-circle w-5"></i>
                <span class="font-medium">Validasi Transaksi</span>
            </a>
            
            <a href="dashboard_kepalaunit_toko.php?menu=dana_unit" class="flex items-center space-x-3 p-3 rounded-lg <?= $active_menu == 'dana_unit' ? 'bg-gradient-to-r from-primary-500 to-purple-500 text-white' : 'text-gray-700 hover:bg-gray-100' ?>">
                <i class="fas fa-money-bill-wave w-5"></i>
                <span class="font-medium">Dana Unit</span>
            </a>

            <div class="border-t border-gray-200 my-4"></div>

            <a href="logout.php" class="flex items-center space-x-3 p-3 rounded-lg text-red-600 hover:bg-red-50">
                <i class="fas fa-sign-out-alt w-5"></i>
                <span class="font-medium">Logout</span>
            </a>
        </nav>
    </aside>

    <!-- Main Content -->
    <main class="ml-64 p-8">
        <div class="max-w-7xl mx-auto">
            
            <!-- Header -->
            <div class="mb-8">
                <h1 class="text-4xl font-bold text-white mb-2">
                    Dashboard Unit <?= $nama_unit ?>
                </h1>
                <p class="text-primary-100">Kelola transaksi dan dana unit <?= $nama_unit ?></p>
            </div>

            <?php if (isset($_GET['success'])): ?>
            <div class="mb-6 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded">
                <i class="fas fa-check-circle mr-2"></i>Data berhasil disimpan!
            </div>
            <?php endif; ?>

            <?php if ($active_menu == 'validasi_transaksi'): ?>
            <!-- Validasi Transaksi Content -->
            <div class="bg-white rounded-2xl shadow-2xl overflow-hidden">
                <div class="bg-gradient-to-r from-primary-500 to-purple-500 p-6">
                    <h2 class="text-2xl font-bold text-white">
                        <i class="fas fa-shopping-cart mr-3"></i>Daftar Transaksi <?= $nama_unit ?>
                    </h2>
                </div>
                
                <div class="p-6">
                    <div class="overflow-x-auto">
                        <table class="w-full">
                            <thead>
                                <tr class="bg-gray-50 border-b-2 border-primary-500">
                                    <th class="px-6 py-4 text-left text-xs font-bold text-gray-700 uppercase">ID</th>
                                    <th class="px-6 py-4 text-left text-xs font-bold text-gray-700 uppercase">Anggota</th>
                                    <th class="px-6 py-4 text-left text-xs font-bold text-gray-700 uppercase">Total</th>
                                    <th class="px-6 py-4 text-left text-xs font-bold text-gray-700 uppercase">Tanggal</th>
                                    <th class="px-6 py-4 text-left text-xs font-bold text-gray-700 uppercase">Status</th>
                                    <th class="px-6 py-4 text-left text-xs font-bold text-gray-700 uppercase">Aksi</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-200">
                                <?php if ($result && $result->num_rows > 0): ?>
                                    <?php while ($row = $result->fetch_assoc()): ?>
                                        <tr class="hover:bg-gray-50">
                                            <td class="px-6 py-4">#<?= $row['id_transaksi'] ?></td>
                                            <td class="px-6 py-4"><?= htmlspecialchars($row['nama']) ?></td>
                                            <td class="px-6 py-4 font-bold text-primary-600">Rp <?= number_format($row['total_harga'], 0, ',', '.') ?></td>
                                            <td class="px-6 py-4"><?= date('d/m/Y', strtotime($row['tanggal_transaksi'])) ?></td>
                                            <td class="px-6 py-4">
                                                <?php if ($row['status'] == 'Pending'): ?>
                                                    <span class="px-3 py-1 rounded-full text-xs font-semibold bg-yellow-100 text-yellow-800">Pending</span>
                                                <?php elseif ($row['status'] == 'Divalidasi'): ?>
                                                    <span class="px-3 py-1 rounded-full text-xs font-semibold bg-green-100 text-green-800">Divalidasi</span>
                                                <?php else: ?>
                                                    <span class="px-3 py-1 rounded-full text-xs font-semibold bg-red-100 text-red-800">Ditolak</span>
                                                <?php endif; ?>
                                            </td>
                                            <td class="px-6 py-4">
                                                <?php if ($row['status'] == 'Pending'): ?>
                                                    <div class="flex space-x-2">
                                                        <a href="?action=approve&id_transaksi=<?= $row['id_transaksi'] ?>" class="px-3 py-2 bg-green-500 text-white rounded-lg hover:bg-green-600">
                                                            <i class="fas fa-check"></i> Setujui
                                                        </a>
                                                        <a href="?action=reject&id_transaksi=<?= $row['id_transaksi'] ?>" class="px-3 py-2 bg-red-500 text-white rounded-lg hover:bg-red-600">
                                                            <i class="fas fa-times"></i> Tolak
                                                        </a>
                                                    </div>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endwhile; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="6" class="px-6 py-12 text-center text-gray-500">
                                            <i class="fas fa-inbox text-6xl mb-4"></i>
                                            <p>Tidak ada data transaksi</p>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <?php elseif ($active_menu == 'dana_unit'): ?>
            <!-- Dana Unit Content -->
            <div class="bg-white rounded-2xl shadow-2xl overflow-hidden">
                <div class="bg-gradient-to-r from-primary-500 to-purple-500 p-6 flex justify-between items-center">
                    <h2 class="text-2xl font-bold text-white">
                        <i class="fas fa-money-bill-wave mr-3"></i>Dana Unit <?= $nama_unit ?>
                    </h2>
                    <div class="flex gap-2">
                        <button onclick="openModalSinkronisasi()" class="bg-yellow-500 text-white px-6 py-2 rounded-lg font-semibold hover:bg-yellow-600">
                            <i class="fas fa-sync mr-2"></i>Sinkronisasi
                        </button>
                        <button onclick="openModalDanaUnit()" class="bg-white text-primary-600 px-6 py-2 rounded-lg font-semibold hover:bg-primary-50">
                            <i class="fas fa-plus mr-2"></i>Input Dana
                        </button>
                    </div>
                </div>
                
                <div class="p-6">
                    <!-- Filter Tahun -->
                    <div class="mb-6">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Filter Tahun</label>
                        <select onchange="window.location.href='?menu=dana_unit&tahun='+this.value" class="px-4 py-2 border rounded-lg">
                            <?php for($y = date('Y'); $y >= 2020; $y--): ?>
                            <option value="<?= $y ?>" <?= $tahun_filter == $y ? 'selected' : '' ?>><?= $y ?></option>
                            <?php endfor; ?>
                        </select>
                    </div>

                    <!-- Summary Card -->
                    <?php
                    $total_dana = $conn->query("SELECT SUM(total_dana) as total FROM dana_unit 
                        WHERE id_unit = $id_unit AND tahun = '$tahun_filter'")->fetch_assoc()['total'] ?? 0;
                    ?>
                    <div class="bg-gradient-to-br from-primary-50 to-purple-50 border border-primary-200 rounded-xl p-6 mb-8">
                        <h3 class="text-lg font-bold text-gray-800 mb-2">Total Dana Tahun <?= $tahun_filter ?></h3>
                        <p class="text-4xl font-bold text-primary-600">Rp <?= number_format($total_dana, 0, ',', '.') ?></p>
                    </div>

                    <!-- Tabel Detail -->
                    <div class="overflow-x-auto">
                        <table class="w-full">
                            <thead>
                                <tr class="bg-gray-50 border-b-2 border-primary-500">
                                    <th class="px-6 py-4 text-left text-xs font-bold text-gray-700 uppercase">Bulan</th>
                                    <th class="px-6 py-4 text-right text-xs font-bold text-gray-700 uppercase">Total Dana</th>
                                    <th class="px-6 py-4 text-left text-xs font-bold text-gray-700 uppercase">Keterangan</th>
                                    <th class="px-6 py-4 text-left text-xs font-bold text-gray-700 uppercase">Tanggal Input</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-200">
                                <?php
                                $dana_detail = $conn->query("SELECT * FROM dana_unit 
                                    WHERE id_unit = $id_unit AND tahun = '$tahun_filter' 
                                    ORDER BY bulan DESC");
                                
                                $bulan_nama = ['', 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 
                                              'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'];
                                
                                if ($dana_detail->num_rows > 0):
                                    while ($dana = $dana_detail->fetch_assoc()):
                                ?>
                                <tr class="hover:bg-gray-50">
                                    <td class="px-6 py-4 font-semibold"><?= $bulan_nama[$dana['bulan']] ?></td>
                                    <td class="px-6 py-4 text-right">
                                        <span class="text-lg font-bold text-primary-600">Rp <?= number_format($dana['total_dana'], 0, ',', '.') ?></span>
                                    </td>
                                    <td class="px-6 py-4"><?= htmlspecialchars($dana['keterangan']) ?></td>
                                    <td class="px-6 py-4"><?= date('d/m/Y', strtotime($dana['tanggal_input'])) ?></td>
                                </tr>
                                <?php 
                                    endwhile;
                                else:
                                ?>
                                <tr>
                                    <td colspan="4" class="px-6 py-12 text-center text-gray-500">
                                        <i class="fas fa-inbox text-6xl mb-4"></i>
                                        <p>Belum ada data</p>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <?php endif; ?>

        </div>
    </main>

    <!-- Modal Input Dana Unit -->
    <div id="modalDanaUnit" class="modal">
        <div class="modal-content">
            <div class="bg-gradient-to-r from-primary-500 to-purple-500 p-6 rounded-t-xl">
                <div class="flex justify-between items-center">
                    <h3 class="text-2xl font-bold text-white"><i class="fas fa-money-bill-wave mr-2"></i>Input Dana Unit</h3>
                    <button onclick="closeModalDanaUnit()" class="text-white hover:text-gray-200">
                        <i class="fas fa-times text-2xl"></i>
                    </button>
                </div>
            </div>
            
            <form method="POST" class="p-6">
                <input type="hidden" name="id_unit" value="<?= $id_unit ?>">
                
                <div class="space-y-4">
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Tahun</label>
                            <select name="tahun" required class="w-full px-4 py-3 border rounded-lg">
                                <?php for($y = date('Y'); $y >= 2020; $y--): ?>
                                <option value="<?= $y ?>"><?= $y ?></option>
                                <?php endfor; ?>
                            </select>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Bulan</label>
                            <select name="bulan" required class="w-full px-4 py-3 border rounded-lg">
                                <?php 
                                $bulan_nama = ['', 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 
                                              'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'];
                                for($m = 1; $m <= 12; $m++): 
                                ?>
                                <option value="<?= $m ?>"><?= $bulan_nama[$m] ?></option>
                                <?php endfor; ?>
                            </select>
                        </div>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Total Dana (Rp)</label>
                        <input type="number" name="total_dana" step="0.01" required class="w-full px-4 py-3 border rounded-lg" placeholder="Masukkan total dana">
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Keterangan</label>
                        <textarea name="keterangan" rows="3" class="w-full px-4 py-3 border rounded-lg" placeholder="Keterangan..."></textarea>
                    </div>
                    
                    <div class="flex gap-4 mt-6">
                        <button type="button" onclick="closeModalDanaUnit()" class="flex-1 bg-gray-200 text-gray-800 px-6 py-3 rounded-lg font-semibold hover:bg-gray-300">
                            Batal
                        </button>
                        <button type="submit" name="simpan_dana_unit" class="flex-1 bg-gradient-to-r from-primary-500 to-purple-500 text-white px-6 py-3 rounded-lg font-semibold">
                            <i class="fas fa-save mr-2"></i>Simpan
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Modal Sinkronisasi -->
    <div id="modalSinkronisasi" class="modal">
        <div class="modal-content">
            <div class="bg-gradient-to-r from-yellow-500 to-orange-500 p-6 rounded-t-xl">
                <div class="flex justify-between items-center">
                    <h3 class="text-2xl font-bold text-white"><i class="fas fa-sync mr-2"></i>Sinkronisasi Data</h3>
                    <button onclick="closeModalSinkronisasi()" class="text-white hover:text-gray-200">
                        <i class="fas fa-times text-2xl"></i>
                    </button>
                </div>
            </div>
            
            <form method="POST" class="p-6">
                <div class="space-y-4">
                    <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4 mb-4">
                        <p class="text-sm text-yellow-800">
                            <i class="fas fa-info-circle mr-2"></i>
                            Fitur ini akan mengambil total transaksi <?= $nama_unit ?> dan memasukkannya ke dana unit.
                        </p>
                    </div>
                    
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Tahun</label>
                            <select name="tahun_sync" required class="w-full px-4 py-3 border rounded-lg">
                                <?php for($y = date('Y'); $y >= 2020; $y--): ?>
                                <option value="<?= $y ?>"><?= $y ?></option>
                                <?php endfor; ?>
                            </select>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Bulan</label>
                            <select name="bulan_sync" required class="w-full px-4 py-3 border rounded-lg">
                                <?php for($m = 1; $m <= 12; $m++): ?>
                                <option value="<?= $m ?>" <?= $m == date('n') ? 'selected' : '' ?>><?= $bulan_nama[$m] ?></option>
                                <?php endfor; ?>
                            </select>
                        </div>
                    </div>
                    
                    <div class="flex gap-4 mt-6">
                        <button type="button" onclick="closeModalSinkronisasi()" class="flex-1 bg-gray-200 text-gray-800 px-6 py-3 rounded-lg font-semibold">
                            Batal
                        </button>
                        <button type="submit" name="sinkronisasi_defmart" class="flex-1 bg-gradient-to-r from-yellow-500 to-orange-500 text-white px-6 py-3 rounded-lg font-semibold">
                            <i class="fas fa-sync mr-2"></i>Sinkronisasi
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <script>
        function openModalDanaUnit() {
            document.getElementById('modalDanaUnit').classList.add('show');
        }
        
        function closeModalDanaUnit() {
            document.getElementById('modalDanaUnit').classList.remove('show');
        }
        
        function openModalSinkronisasi() {
            document.getElementById('modalSinkronisasi').classList.add('show');
        }
        
        function closeModalSinkronisasi() {
            document.getElementById('modalSinkronisasi').classList.remove('show');
        }
        
        window.onclick = function(event) {
            if (event.target.classList.contains('modal')) {
                event.target.classList.remove('show');
            }
        }
    </script>

</body>
</html>