<?php
session_start();
include 'config.php';

// Cek akses - hanya kepala unit yang bisa download
if (!isset($_SESSION['role']) || $_SESSION['id_role'] != 7) {
    header("Location: index.php");
    exit;
}

if (!isset($_GET['id'])) {
    die('ID pinjaman tidak ditemukan');
}

$id_pinjaman = intval($_GET['id']);

// Ambil nama file dokumen dari database
$stmt = $conn->prepare("SELECT dokumen_pendukung FROM pinjaman WHERE id_pinjaman = ?");
$stmt->bind_param("i", $id_pinjaman);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows == 0) {
    die('Data pinjaman tidak ditemukan');
}

$data = $result->fetch_assoc();
$filename = $data['dokumen_pendukung'];

if (empty($filename)) {
    die('Tidak ada dokumen pendukung untuk pinjaman ini');
}

$filepath = 'uploads/dokumen_pinjaman/' . $filename;

// Cek apakah file ada
if (!file_exists($filepath)) {
    die('File tidak ditemukan: ' . htmlspecialchars($filename));
}

// Set header untuk download
header('Content-Description: File Transfer');
header('Content-Type: application/octet-stream');
header('Content-Disposition: attachment; filename="' . basename($filename) . '"');
header('Content-Transfer-Encoding: binary');
header('Expires: 0');
header('Cache-Control: must-revalidate');
header('Pragma: public');
header('Content-Length: ' . filesize($filepath));

// Clear output buffer
ob_clean();
flush();

// Baca file dan kirim ke output
readfile($filepath);
exit;
?>