<?php
session_start();
include 'config.php';

// Pastikan user login dan rolenya Anggota
if (!isset($_SESSION['role']) || $_SESSION['role'] != 'Anggota') {
    header("Location: index.php");
    exit;
}

// Ambil ID anggota yang sedang login
$id_anggota = $_SESSION['id_anggota'];

// Ambil data anggota
$query_anggota = "SELECT a.*, u.username FROM anggota a 
                  LEFT JOIN user u ON a.id_user = u.id_user 
                  WHERE a.id_anggota = ?";
$stmt_anggota = $conn->prepare($query_anggota);
$stmt_anggota->bind_param("i", $id_anggota);
$stmt_anggota->execute();
$result_anggota = $stmt_anggota->get_result();
$anggotaData = $result_anggota->fetch_assoc();

// Filter
$filter_bulan = isset($_POST['bulan']) ? $_POST['bulan'] : '';
$filter_tahun = isset($_POST['tahun']) ? $_POST['tahun'] : '';

// Build query dengan filter
$where = ["dt.id_anggota = ?"];
$params = [$id_anggota];
$types = "i";

if ($filter_bulan) {
    $where[] = "MONTH(dt.tanggal_transaksi) = ?";
    $params[] = $filter_bulan;
    $types .= "i";
}

if ($filter_tahun) {
    $where[] = "YEAR(dt.tanggal_transaksi) = ?";
    $params[] = $filter_tahun;
    $types .= "i";
}

$where_clause = "WHERE " . implode(" AND ", $where);

// Ambil data transaksi
$query = "
    SELECT 
        dt.*
    FROM defmart_transaksi dt 
    $where_clause
    ORDER BY dt.tanggal_transaksi DESC, dt.id_transaksi DESC
";

$stmt = $conn->prepare($query);
$stmt->bind_param($types, ...$params);
$stmt->execute();
$transaksi = $stmt->get_result();

// Statistik
$stats_query = "
    SELECT 
        COUNT(*) as total_transaksi,
        SUM(total_harga) as total_belanja,
        AVG(total_harga) as rata_rata,
        SUM(qty) as total_item
    FROM defmart_transaksi dt
    $where_clause
";

$stats_stmt = $conn->prepare($stats_query);
$stats_stmt->bind_param($types, ...$params);
$stats_stmt->execute();
$stats_result = $stats_stmt->get_result();
$stats = $stats_result->fetch_assoc();

// Set header untuk download Excel
header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=Riwayat_Transaksi_Defmart_" . $anggotaData['nama'] . "_" . date('Y-m-d_His') . ".xls");
header("Pragma: no-cache");
header("Expires: 0");

?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Riwayat Transaksi Defmart</title>
    <style>
        table {
            border-collapse: collapse;
            width: 100%;
        }
        th, td {
            border: 1px solid black;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #4CAF50;
            color: white;
            font-weight: bold;
        }
        .text-center {
            text-align: center;
        }
        .text-right {
            text-align: right;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .info-anggota {
            margin-bottom: 20px;
        }
        .summary {
            margin-top: 20px;
            background-color: #f2f2f2;
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>RIWAYAT TRANSAKSI DEFMART</h2>
        <h3>KOPERASI PUSDATIN</h3>
        <p>Tanggal Export: <?= date('d/m/Y H:i:s') ?></p>
        <?php if ($filter_bulan || $filter_tahun): ?>
            <p>
                Periode: 
                <?php if ($filter_bulan): ?>
                    <?php
                    $bulan_nama = [
                        1 => 'Januari', 2 => 'Februari', 3 => 'Maret', 4 => 'April',
                        5 => 'Mei', 6 => 'Juni', 7 => 'Juli', 8 => 'Agustus',
                        9 => 'September', 10 => 'Oktober', 11 => 'November', 12 => 'Desember'
                    ];
                    echo $bulan_nama[$filter_bulan];
                    ?>
                <?php endif; ?>
                <?php if ($filter_tahun): ?>
                    <?= $filter_tahun ?>
                <?php endif; ?>
            </p>
        <?php endif; ?>
    </div>

    <div class="info-anggota">
        <h3>INFORMASI ANGGOTA</h3>
        <table style="width: 50%; margin-bottom: 20px;">
            <tr>
                <td style="width: 30%;"><strong>Nama</strong></td>
                <td>: <?= htmlspecialchars($anggotaData['nama']) ?></td>
            </tr>
            <tr>
                <td><strong>NIP</strong></td>
                <td>: <?= htmlspecialchars($anggotaData['nip']) ?></td>
            </tr>
            <tr>
                <td><strong>Jabatan</strong></td>
                <td>: <?= htmlspecialchars($anggotaData['jabatan']) ?></td>
            </tr>
            <tr>
                <td><strong>Tanggal Masuk</strong></td>
                <td>: <?= date('d/m/Y', strtotime($anggotaData['tanggal_masuk'])) ?></td>
            </tr>
        </table>
    </div>

    <table>
        <thead>
            <tr>
                <th class="text-center">No</th>
                <th>Tanggal Transaksi</th>
                <th>Nama Barang</th>
                <th class="text-center">Qty</th>
                <th class="text-right">Harga Satuan</th>
                <th class="text-right">Total Harga</th>
                <th>Metode Pembayaran</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            if ($transaksi->num_rows > 0):
                $no = 1;
                while ($row = $transaksi->fetch_assoc()): 
            ?>
                <tr>
                    <td class="text-center"><?= $no++ ?></td>
                    <td><?= date('d/m/Y H:i', strtotime($row['tanggal_transaksi'])) ?></td>
                    <td><?= htmlspecialchars($row['nama_barang']) ?></td>
                    <td class="text-center"><?= $row['qty'] ?></td>
                    <td class="text-right">Rp <?= number_format($row['harga_satuan'], 0, ',', '.') ?></td>
                    <td class="text-right">Rp <?= number_format($row['total_harga'], 0, ',', '.') ?></td>
                    <td><?= htmlspecialchars($row['metode_pembayaran']) ?></td>
                </tr>
            <?php 
                endwhile;
            else: 
            ?>
                <tr>
                    <td colspan="7" class="text-center">Tidak ada data transaksi</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <br><br>

    <table class="summary">
        <thead>
            <tr>
                <th colspan="2" class="text-center">RINGKASAN TRANSAKSI</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td style="width: 50%;"><strong>Total Transaksi</strong></td>
                <td class="text-right"><?= number_format($stats['total_transaksi']) ?> transaksi</td>
            </tr>
            <tr>
                <td><strong>Total Belanja Keseluruhan</strong></td>
                <td class="text-right">Rp <?= number_format($stats['total_belanja'], 0, ',', '.') ?></td>
            </tr>
            <tr>
                <td><strong>Rata-rata Belanja</strong></td>
                <td class="text-right">Rp <?= number_format($stats['rata_rata'], 0, ',', '.') ?></td>
            </tr>
            <tr>
                <td><strong>Total Item Dibeli</strong></td>
                <td class="text-right"><?= number_format($stats['total_item']) ?> item</td>
            </tr>
        </tbody>
    </table>

    <br><br>
    <p style="text-align: right;">
        Dicetak oleh: <?= htmlspecialchars($anggotaData['nama']) ?><br>
        Username: <?= htmlspecialchars($anggotaData['username']) ?><br>
        Tanggal: <?= date('d/m/Y H:i:s') ?>
    </p>
</body>
</html>