<?php
session_start();
include 'config.php';

// Cek apakah user sudah login
if (!isset($_SESSION['role'])) {
    header("Location: index.php");
    exit;
}

$tahun = isset($_GET['tahun']) ? intval($_GET['tahun']) : date('Y');

// Query untuk laporan agregat SHU Defmart per anggota
$query_shu = "SELECT 
                a.id_anggota,
                a.nama,
                a.nip,
                COALESCE(SUM(dt.total_harga), 0) as total_transaksi,
                COUNT(dt.id_transaksi) as jumlah_transaksi,
                COALESCE(sp.shu_toko, 0) as shu_toko_tahun_ini,
                COALESCE(sp.total_shu, 0) as total_shu_tahun_ini
            FROM anggota a
            LEFT JOIN defmart_transaksi dt ON a.id_anggota = dt.id_anggota 
                AND YEAR(dt.tanggal_transaksi) = ?
            LEFT JOIN shu_pembagian sp ON a.id_anggota = sp.id_anggota 
                AND sp.tahun = ?
            GROUP BY a.id_anggota, a.nama, a.nip, sp.shu_toko, sp.total_shu
            HAVING total_transaksi > 0
            ORDER BY total_transaksi DESC";

$stmt_shu = $conn->prepare($query_shu);
$stmt_shu->bind_param("ii", $tahun, $tahun);
$stmt_shu->execute();
$shu_result = $stmt_shu->get_result();

// Hitung total keseluruhan
$query_total = "SELECT 
                    COALESCE(SUM(total_harga), 0) as grand_total_transaksi,
                    COUNT(id_transaksi) as grand_jumlah_transaksi
                FROM defmart_transaksi 
                WHERE YEAR(tanggal_transaksi) = ?";
$stmt_total = $conn->prepare($query_total);
$stmt_total->bind_param("i", $tahun);
$stmt_total->execute();
$total_result = $stmt_total->get_result();
$total_data = $total_result->fetch_assoc();

// Set header untuk download Excel
header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=Laporan_SHU_Defmart_{$tahun}.xls");
header("Pragma: no-cache");
header("Expires: 0");

?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <style>
        table {
            border-collapse: collapse;
            width: 100%;
        }
        th, td {
            border: 1px solid #000;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #667eea;
            color: white;
            font-weight: bold;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .summary {
            margin-bottom: 20px;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>LAPORAN AGREGAT SHU DEFMART</h2>
        <h3>KOPERASI PUSDATIN</h3>
        <p>Tahun <?= $tahun ?></p>
        <p>Dicetak pada: <?= date('d/m/Y H:i:s') ?></p>
    </div>

    <div class="summary">
        <table style="width: 50%;">
            <tr>
                <th colspan="2" style="text-align: center;">RINGKASAN</th>
            </tr>
            <tr>
                <td><strong>Total Transaksi Defmart</strong></td>
                <td class="text-right">Rp <?= number_format($total_data['grand_total_transaksi'], 0, ',', '.') ?></td>
            </tr>
            <tr>
                <td><strong>Jumlah Transaksi</strong></td>
                <td class="text-right"><?= number_format($total_data['grand_jumlah_transaksi'], 0, ',', '.') ?></td>
            </tr>
        </table>
    </div>

    <table>
        <thead>
            <tr>
                <th>No</th>
                <th>NIP</th>
                <th>Nama Anggota</th>
                <th>Jumlah Transaksi</th>
                <th>Total Pembelian (Rp)</th>
                <th>Persentase (%)</th>
                <th>SHU Toko (Rp)</th>
                <th>Total SHU (Rp)</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            $no = 1;
            while ($shu = $shu_result->fetch_assoc()): 
                $persentase = $total_data['grand_total_transaksi'] > 0 ? 
                    ($shu['total_transaksi'] / $total_data['grand_total_transaksi']) * 100 : 0;
            ?>
                <tr>
                    <td class="text-center"><?= $no++ ?></td>
                    <td><?= htmlspecialchars($shu['nip']) ?></td>
                    <td><?= htmlspecialchars($shu['nama']) ?></td>
                    <td class="text-center"><?= number_format($shu['jumlah_transaksi'], 0, ',', '.') ?></td>
                    <td class="text-right"><?= number_format($shu['total_transaksi'], 0, ',', '.') ?></td>
                    <td class="text-right"><?= number_format($persentase, 2, ',', '.') ?></td>
                    <td class="text-right"><?= $shu['shu_toko_tahun_ini'] > 0 ? number_format($shu['shu_toko_tahun_ini'], 0, ',', '.') : '-' ?></td>
                    <td class="text-right"><?= $shu['total_shu_tahun_ini'] > 0 ? number_format($shu['total_shu_tahun_ini'], 0, ',', '.') : '-' ?></td>
                </tr>
            <?php endwhile; ?>
        </tbody>
    </table>

    <div style="margin-top: 30px;">
        <p><strong>Keterangan:</strong></p>
        <ul>
            <li>Laporan ini menampilkan agregat transaksi anggota di Defmart untuk perhitungan SHU</li>
            <li>Semakin banyak transaksi anggota di Defmart, semakin besar SHU yang akan diterima</li>
            <li>Persentase menunjukkan kontribusi transaksi anggota terhadap total transaksi Defmart</li>
            <li>SHU Toko dan Total SHU akan muncul setelah pembagian SHU dilakukan oleh admin</li>
        </ul>
    </div>
</body>
</html>