<?php
session_start();
include 'config.php';

// Cek apakah user sudah login dan memiliki role Admin Koperasi
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'Admin Koperasi') {
    header("Location: index.php");
    exit;
}

// Filter
$filter_anggota = isset($_GET['anggota']) ? intval($_GET['anggota']) : '';
$filter_jenis = isset($_GET['jenis']) ? $_GET['jenis'] : '';
$filter_bulan = isset($_GET['bulan']) ? $_GET['bulan'] : '';
$filter_tahun = isset($_GET['tahun']) ? $_GET['tahun'] : '';

// Build query dengan filter
$where = [];
if ($filter_anggota) $where[] = "s.id_anggota = $filter_anggota";
if ($filter_jenis) $where[] = "s.jenis = '$filter_jenis'";
if ($filter_bulan) $where[] = "MONTH(s.tanggal_setor) = $filter_bulan";
if ($filter_tahun) $where[] = "YEAR(s.tanggal_setor) = $filter_tahun";

$where_clause = count($where) > 0 ? "WHERE " . implode(" AND ", $where) : "";

// Ambil data simpanan
$simpanan = $conn->query("
    SELECT s.*, a.nama, a.nip 
    FROM simpanan s 
    JOIN anggota a ON s.id_anggota = a.id_anggota 
    $where_clause
    ORDER BY s.tanggal_setor DESC, s.id_simpanan DESC
");

// Statistik
$stats = $conn->query("
    SELECT 
        COUNT(*) as total_transaksi,
        SUM(CASE WHEN jenis = 'wajib' THEN nominal ELSE 0 END) as total_wajib,
        SUM(CASE WHEN jenis = 'sukarela' THEN nominal ELSE 0 END) as total_sukarela,
        SUM(nominal) as total_keseluruhan
    FROM simpanan
    $where_clause
")->fetch_assoc();

// Set header untuk download Excel
header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=Laporan_Simpanan_" . date('Y-m-d_His') . ".xls");
header("Pragma: no-cache");
header("Expires: 0");

?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Laporan Simpanan</title>
    <style>
        table {
            border-collapse: collapse;
            width: 100%;
        }
        th, td {
            border: 1px solid black;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #4CAF50;
            color: white;
            font-weight: bold;
        }
        .text-center {
            text-align: center;
        }
        .text-right {
            text-align: right;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .summary {
            margin-top: 20px;
            background-color: #f2f2f2;
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>LAPORAN SIMPANAN ANGGOTA</h2>
        <h3>KOPERASI PUSDATIN</h3>
        <p>Tanggal Export: <?= date('d/m/Y H:i:s') ?></p>
        <?php if ($filter_bulan || $filter_tahun): ?>
            <p>
                Periode: 
                <?php if ($filter_bulan): ?>
                    <?= date('F', mktime(0, 0, 0, $filter_bulan, 1)) ?>
                <?php endif; ?>
                <?php if ($filter_tahun): ?>
                    <?= $filter_tahun ?>
                <?php endif; ?>
            </p>
        <?php endif; ?>
    </div>

    <table>
        <thead>
            <tr>
                <th class="text-center">No</th>
                <th>Tanggal Setor</th>
                <th>NIP</th>
                <th>Nama Anggota</th>
                <th class="text-center">Jenis</th>
                <th class="text-right">Nominal</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            if ($simpanan->num_rows > 0):
                $no = 1;
                while ($row = $simpanan->fetch_assoc()): 
            ?>
                <tr>
                    <td class="text-center"><?= $no++ ?></td>
                    <td><?= date('d/m/Y', strtotime($row['tanggal_setor'])) ?></td>
                    <td><?= htmlspecialchars($row['nip']) ?></td>
                    <td><?= htmlspecialchars($row['nama']) ?></td>
                    <td class="text-center"><?= ucfirst($row['jenis']) ?></td>
                    <td class="text-right">Rp <?= number_format($row['nominal'], 0, ',', '.') ?></td>
                </tr>
            <?php 
                endwhile;
            else: 
            ?>
                <tr>
                    <td colspan="6" class="text-center">Tidak ada data</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <br><br>

    <table class="summary">
        <thead>
            <tr>
                <th colspan="2" class="text-center">RINGKASAN</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td><strong>Total Transaksi</strong></td>
                <td class="text-right"><?= number_format($stats['total_transaksi']) ?> transaksi</td>
            </tr>
            <tr>
                <td><strong>Total Simpanan Wajib</strong></td>
                <td class="text-right">Rp <?= number_format($stats['total_wajib'], 0, ',', '.') ?></td>
            </tr>
            <tr>
                <td><strong>Total Simpanan Sukarela</strong></td>
                <td class="text-right">Rp <?= number_format($stats['total_sukarela'], 0, ',', '.') ?></td>
            </tr>
            <tr>
                <td><strong>TOTAL KESELURUHAN</strong></td>
                <td class="text-right"><strong>Rp <?= number_format($stats['total_keseluruhan'], 0, ',', '.') ?></strong></td>
            </tr>
        </tbody>
    </table>

    <br><br>
    <p style="text-align: right;">
        Dicetak oleh: <?= htmlspecialchars($_SESSION['username']) ?><br>
        Tanggal: <?= date('d/m/Y H:i:s') ?>
    </p>
</body>
</html>