<?php
session_start();
include 'config.php';

// Cek apakah user sudah login dan memiliki role Admin Koperasi
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'Admin Koperasi') {
    header("Location: index.php");
    exit;
}

// Filter
$filter_anggota = isset($_GET['anggota']) ? intval($_GET['anggota']) : '';
$filter_bulan = isset($_GET['bulan']) ? $_GET['bulan'] : '';
$filter_tahun = isset($_GET['tahun']) ? $_GET['tahun'] : '';

// Build query dengan filter
$where = [];
if ($filter_anggota) $where[] = "dt.id_anggota = $filter_anggota";
if ($filter_bulan) $where[] = "MONTH(dt.tanggal_transaksi) = $filter_bulan";
if ($filter_tahun) $where[] = "YEAR(dt.tanggal_transaksi) = $filter_tahun";

$where_clause = count($where) > 0 ? "WHERE " . implode(" AND ", $where) : "";

// Ambil data transaksi dengan menghitung fee 5%
$query = "
    SELECT 
        dt.*,
        a.nama, 
        a.nip,
        dt.total_harga as total_belanja,
        (dt.total_harga * 0.05) as defmart_fee
    FROM defmart_transaksi dt 
    JOIN anggota a ON dt.id_anggota = a.id_anggota 
    $where_clause
    ORDER BY dt.tanggal_transaksi DESC, dt.id_transaksi DESC
";

$transaksi = $conn->query($query);
if (!$transaksi) {
    die("Error query transaksi: " . $conn->error);
}

// Statistik
$stats_query = "
    SELECT 
        COUNT(*) as total_transaksi,
        SUM(total_harga) as total_belanja,
        SUM(total_harga * 0.05) as total_fee
    FROM defmart_transaksi dt
    $where_clause
";

$stats_result = $conn->query($stats_query);
if (!$stats_result) {
    die("Error query statistik: " . $conn->error);
}
$stats = $stats_result->fetch_assoc();

// Set header untuk download Excel
header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=Laporan_Transaksi_Defmart_" . date('Y-m-d_His') . ".xls");
header("Pragma: no-cache");
header("Expires: 0");

?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Laporan Transaksi Defmart</title>
    <style>
        table {
            border-collapse: collapse;
            width: 100%;
        }
        th, td {
            border: 1px solid black;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #4CAF50;
            color: white;
            font-weight: bold;
        }
        .text-center {
            text-align: center;
        }
        .text-right {
            text-align: right;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .summary {
            margin-top: 20px;
            background-color: #f2f2f2;
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>LAPORAN TRANSAKSI DEFMART</h2>
        <h3>KOPERASI PUSDATIN</h3>
        <p>Tanggal Export: <?= date('d/m/Y H:i:s') ?></p>
        <?php if ($filter_bulan || $filter_tahun): ?>
            <p>
                Periode: 
                <?php if ($filter_bulan): ?>
                    <?= date('F', mktime(0, 0, 0, $filter_bulan, 1)) ?>
                <?php endif; ?>
                <?php if ($filter_tahun): ?>
                    <?= $filter_tahun ?>
                <?php endif; ?>
            </p>
        <?php endif; ?>
    </div>

    <table>
        <thead>
            <tr>
                <th class="text-center">No</th>
                <th>Tanggal Transaksi</th>
                <th>NIP</th>
                <th>Nama Anggota</th>
                <th>Nama Barang</th>
                <th class="text-center">Qty</th>
                <th class="text-right">Harga Satuan</th>
                <th class="text-right">Total Belanja</th>
                <th class="text-right">Fee Defmart (5%)</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            if ($transaksi->num_rows > 0):
                $no = 1;
                while ($row = $transaksi->fetch_assoc()): 
            ?>
                <tr>
                    <td class="text-center"><?= $no++ ?></td>
                    <td><?= date('d/m/Y H:i', strtotime($row['tanggal_transaksi'])) ?></td>
                    <td><?= htmlspecialchars($row['nip']) ?></td>
                    <td><?= htmlspecialchars($row['nama']) ?></td>
                    <td><?= htmlspecialchars($row['nama_barang']) ?></td>
                    <td class="text-center"><?= $row['qty'] ?></td>
                    <td class="text-right">Rp <?= number_format($row['harga_satuan'], 0, ',', '.') ?></td>
                    <td class="text-right">Rp <?= number_format($row['total_belanja'], 0, ',', '.') ?></td>
                    <td class="text-right">Rp <?= number_format($row['defmart_fee'], 0, ',', '.') ?></td>
                </tr>
            <?php 
                endwhile;
            else: 
            ?>
                <tr>
                    <td colspan="9" class="text-center">Tidak ada data</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <br><br>

    <table class="summary">
        <thead>
            <tr>
                <th colspan="2" class="text-center">RINGKASAN</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td><strong>Total Transaksi</strong></td>
                <td class="text-right"><?= number_format($stats['total_transaksi']) ?> transaksi</td>
            </tr>
            <tr>
                <td><strong>Total Belanja Keseluruhan</strong></td>
                <td class="text-right">Rp <?= number_format($stats['total_belanja'], 0, ',', '.') ?></td>
            </tr>
            <tr>
                <td><strong>Total Fee Defmart (5%)</strong></td>
                <td class="text-right">Rp <?= number_format($stats['total_fee'], 0, ',', '.') ?></td>
            </tr>
        </tbody>
    </table>

    <br><br>
    <p style="text-align: right;">
        Dicetak oleh: <?= htmlspecialchars($_SESSION['username']) ?><br>
        Tanggal: <?= date('d/m/Y H:i:s') ?>
    </p>
</body>
</html>