<?php
session_start();
include 'config.php';

// Cek apakah user sudah login dan memiliki role Kasir Defmart
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'Kasir Defmart') {
    header("Location: index.php");
    exit;
}

// Ambil parameter filter dari URL
$filter_bulan = isset($_GET['filter_bulan']) ? $_GET['filter_bulan'] : date('Y-m');
$sort_by = isset($_GET['sort_by']) ? $_GET['sort_by'] : 'tanggal';
$urutan = isset($_GET['urutan']) ? $_GET['urutan'] : 'DESC';

// Build query dengan filter
$query_transaksi = "SELECT dt.*, a.nama, a.nip 
                    FROM defmart_transaksi dt 
                    LEFT JOIN anggota a ON dt.id_anggota = a.id_anggota 
                    WHERE DATE_FORMAT(dt.tanggal_transaksi, '%Y-%m') = ?";
$params_types = "s";
$params = [$filter_bulan];

if ($sort_by === 'tanggal') {
    $query_transaksi .= " ORDER BY dt.tanggal_transaksi " . $urutan;
} else if ($sort_by === 'total') {
    $query_transaksi .= " ORDER BY dt.total_harga " . $urutan;
}

$stmt_transaksi = $conn->prepare($query_transaksi);
$stmt_transaksi->bind_param($params_types, ...$params);
$stmt_transaksi->execute();
$transaksi_result = $stmt_transaksi->get_result();

// Set header untuk download Excel
$filename = "Riwayat_Transaksi_Defmart_" . str_replace('-', '_', $filter_bulan) . ".xls";
header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=\"$filename\"");
header("Pragma: no-cache");
header("Expires: 0");

// Nama bulan untuk display
$bulan_nama = date('F Y', strtotime($filter_bulan . '-01'));

// Output HTML table yang akan dibaca sebagai Excel
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <style>
        table {
            border-collapse: collapse;
            width: 100%;
        }
        th, td {
            border: 1px solid #000;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #667eea;
            color: white;
            font-weight: bold;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .total-row {
            background-color: #f0f0f0;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>KOPERASI PUSDATIN</h2>
        <h3>Laporan Riwayat Transaksi Defmart</h3>
        <p>Periode: <?= $bulan_nama ?></p>
        <p>Dicetak pada: <?= date('d F Y H:i:s') ?></p>
    </div>

    <table>
        <thead>
            <tr>
                <th>No</th>
                <th>Tanggal Transaksi</th>
                <th>NIP</th>
                <th>Nama Anggota</th>
                <th>Nama Barang</th>
                <th class="text-center">Qty</th>
                <th class="text-right">Harga Satuan</th>
                <th class="text-right">Total Harga</th>
                <th class="text-center">Metode Pembayaran</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            $no = 1;
            $total_qty = 0;
            $total_nilai = 0;
            $total_transaksi = 0;
            
            while ($row = $transaksi_result->fetch_assoc()): 
                $total_qty += $row['qty'];
                $total_nilai += $row['total_harga'];
                $total_transaksi++;
            ?>
                <tr>
                    <td class="text-center"><?= $no++ ?></td>
                    <td><?= date('d/m/Y H:i:s', strtotime($row['tanggal_transaksi'])) ?></td>
                    <td><?= htmlspecialchars($row['nip'] ?? '-') ?></td>
                    <td><?= htmlspecialchars($row['nama'] ?? '-') ?></td>
                    <td><?= htmlspecialchars($row['nama_barang']) ?></td>
                    <td class="text-center"><?= $row['qty'] ?></td>
                    <td class="text-right"><?= number_format($row['harga_satuan'], 0, ',', '.') ?></td>
                    <td class="text-right"><?= number_format($row['total_harga'], 0, ',', '.') ?></td>
                    <td class="text-center"><?= htmlspecialchars($row['metode_pembayaran']) ?></td>
                </tr>
            <?php endwhile; ?>
            
            <?php if ($total_transaksi == 0): ?>
                <tr>
                    <td colspan="9" class="text-center">Tidak ada data transaksi untuk periode ini</td>
                </tr>
            <?php else: ?>
                <tr class="total-row">
                    <td colspan="5" class="text-right">TOTAL</td>
                    <td class="text-center"><?= number_format($total_qty) ?></td>
                    <td></td>
                    <td class="text-right"><?= number_format($total_nilai, 0, ',', '.') ?></td>
                    <td></td>
                </tr>
                <tr class="total-row">
                    <td colspan="8" class="text-right">Total Transaksi:</td>
                    <td class="text-center"><?= number_format($total_transaksi) ?></td>
                </tr>
                <tr class="total-row">
                    <td colspan="8" class="text-right">Rata-rata per Transaksi:</td>
                    <td class="text-right"><?= number_format($total_nilai / $total_transaksi, 0, ',', '.') ?></td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <br><br>
    <table style="border: none;">
        <tr>
            <td style="border: none; width: 50%;"></td>
            <td style="border: none; width: 50%; text-align: center;">
                <p>Kasir Defmart</p>
                <br><br><br>
                <p><?= htmlspecialchars($_SESSION['username']) ?></p>
            </td>
        </tr>
    </table>

    <br>
    <p style="font-size: 10px; color: #666;">
        <i>Dokumen ini digenerate otomatis oleh Sistem Koperasi Pusdatin</i>
    </p>
</body>
</html>
<?php
$stmt_transaksi->close();
$conn->close();
?>