<?php
session_start();
include 'config.php';

// Cek apakah user sudah login dan memiliki role Kasir Defmart
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'Kasir Defmart') {
    header("Location: index.php");
    exit;
}

// Filter dan Sorting
$filter_bulan = isset($_GET['filter_bulan']) ? $_GET['filter_bulan'] : date('Y-m');
$filter_anggota = isset($_GET['filter_anggota']) ? $_GET['filter_anggota'] : '';
$sort_by = isset($_GET['sort_by']) ? $_GET['sort_by'] : 'tanggal';
$urutan = isset($_GET['urutan']) ? $_GET['urutan'] : 'DESC';

// Ambil data transaksi dengan filter
$query_transaksi = "SELECT dt.*, a.nama FROM defmart_transaksi dt 
                    LEFT JOIN anggota a ON dt.id_anggota = a.id_anggota 
                    WHERE DATE_FORMAT(dt.tanggal_transaksi, '%Y-%m') = ?";
$params_types = "s";
$params = [$filter_bulan];

if ($filter_anggota !== '') {
    $query_transaksi .= " AND dt.id_anggota = ?";
    $params_types .= "i";
    $params[] = intval($filter_anggota);
}

if ($sort_by === 'tanggal') {
    $query_transaksi .= " ORDER BY dt.tanggal_transaksi " . $urutan;
} else if ($sort_by === 'total') {
    $query_transaksi .= " ORDER BY dt.total_harga " . $urutan;
}

$stmt_transaksi = $conn->prepare($query_transaksi);
$stmt_transaksi->bind_param($params_types, ...$params);
$stmt_transaksi->execute();
$transaksi_result = $stmt_transaksi->get_result();

// Hitung total
$total_pendapatan = 0;
$transaksi_data = [];
while ($row = $transaksi_result->fetch_assoc()) {
    $transaksi_data[] = $row;
    $total_pendapatan += $row['total_harga'];
}

// Nama anggota untuk judul
$nama_anggota = "Semua Anggota";
if ($filter_anggota !== '') {
    $stmt_nama = $conn->prepare("SELECT nama FROM anggota WHERE id_anggota = ?");
    $stmt_nama->bind_param("i", $filter_anggota);
    $stmt_nama->execute();
    $result_nama = $stmt_nama->get_result();
    if ($row_nama = $result_nama->fetch_assoc()) {
        $nama_anggota = $row_nama['nama'];
    }
}

// Format tanggal
$bulan_tahun = date('F Y', strtotime($filter_bulan . '-01'));
$bulan_indo = [
    'January' => 'Januari', 'February' => 'Februari', 'March' => 'Maret',
    'April' => 'April', 'May' => 'Mei', 'June' => 'Juni',
    'July' => 'Juli', 'August' => 'Agustus', 'September' => 'September',
    'October' => 'Oktober', 'November' => 'November', 'December' => 'Desember'
];
$bulan_tahun = str_replace(array_keys($bulan_indo), array_values($bulan_indo), $bulan_tahun);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Laporan Transaksi Defmart - <?= $bulan_tahun ?></title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: Arial, sans-serif;
            padding: 20px;
            color: #333;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 3px solid #667eea;
            padding-bottom: 20px;
        }
        
        .header h1 {
            color: #667eea;
            font-size: 24px;
            margin-bottom: 5px;
        }
        
        .header h2 {
            color: #666;
            font-size: 18px;
            font-weight: normal;
        }
        
        .info-box {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            border-left: 4px solid #667eea;
        }
        
        .info-box table {
            width: 100%;
        }
        
        .info-box td {
            padding: 5px 0;
        }
        
        .info-box td:first-child {
            font-weight: bold;
            width: 150px;
        }
        
        table.data-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        
        table.data-table thead {
            background: #667eea;
            color: white;
        }
        
        table.data-table th,
        table.data-table td {
            border: 1px solid #ddd;
            padding: 10px;
            text-align: left;
        }
        
        table.data-table th {
            font-weight: bold;
            font-size: 12px;
        }
        
        table.data-table td {
            font-size: 11px;
        }
        
        table.data-table tbody tr:nth-child(even) {
            background: #f8f9fa;
        }
        
        table.data-table tbody tr:hover {
            background: #e9ecef;
        }
        
        .text-right {
            text-align: right;
        }
        
        .text-center {
            text-align: center;
        }
        
        .badge {
            display: inline-block;
            padding: 3px 8px;
            border-radius: 12px;
            font-size: 10px;
            font-weight: bold;
        }
        
        .badge-cash {
            background: #667eea;
            color: white;
        }
        
        .badge-debit {
            background: #4facfe;
            color: white;
        }
        
        .badge-bon {
            background: #f5576c;
            color: white;
        }
        
        .summary {
            margin-top: 30px;
            background: #667eea;
            color: white;
            padding: 20px;
            border-radius: 8px;
        }
        
        .summary-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
            font-size: 14px;
        }
        
        .summary-row.total {
            font-size: 18px;
            font-weight: bold;
            border-top: 2px solid white;
            padding-top: 10px;
            margin-top: 10px;
        }
        
        .footer {
            margin-top: 40px;
            text-align: center;
            color: #666;
            font-size: 11px;
        }
        
        @media print {
            body {
                padding: 10px;
            }
            
            .no-print {
                display: none;
            }
        }
        
        .btn-print {
            background: #667eea;
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
            margin-bottom: 20px;
        }
        
        .btn-print:hover {
            background: #5568d3;
        }
    </style>
</head>
<body>
    <button onclick="window.print()" class="btn-print no-print">🖨️ Cetak / Simpan PDF</button>
    
    <div class="header">
        <h1>LAPORAN TRANSAKSI DEFMART</h1>
        <h2>Koperasi PUSDATIN</h2>
    </div>
    
    <div class="info-box">
        <table>
            <tr>
                <td>Periode</td>
                <td>: <?= $bulan_tahun ?></td>
            </tr>
            <tr>
                <td>Filter Anggota</td>
                <td>: <?= htmlspecialchars($nama_anggota) ?></td>
            </tr>
            <tr>
                <td>Tanggal Cetak</td>
                <td>: <?= date('d/m/Y H:i') ?> WIB</td>
            </tr>
            <tr>
                <td>Total Transaksi</td>
                <td>: <?= count($transaksi_data) ?> transaksi</td>
            </tr>
        </table>
    </div>
    
    <table class="data-table">
        <thead>
            <tr>
                <th width="30">No</th>
                <th width="100">Tanggal</th>
                <th>Anggota</th>
                <th>Barang</th>
                <th width="50">Qty</th>
                <th width="100">Harga Satuan</th>
                <th width="100">Total</th>
                <th width="80">Pembayaran</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            $no = 1;
            foreach ($transaksi_data as $row): 
                $badge_class = 'badge-cash';
                if ($row['metode_pembayaran'] === 'Debit') $badge_class = 'badge-debit';
                if ($row['metode_pembayaran'] === 'Bon') $badge_class = 'badge-bon';
            ?>
                <tr>
                    <td class="text-center"><?= $no++ ?></td>
                    <td><?= date('d/m/Y H:i', strtotime($row['tanggal_transaksi'])) ?></td>
                    <td><?= htmlspecialchars($row['nama'] ?? '-') ?></td>
                    <td><?= htmlspecialchars($row['nama_barang']) ?></td>
                    <td class="text-center"><?= $row['qty'] ?></td>
                    <td class="text-right">Rp <?= number_format($row['harga_satuan'], 0, ',', '.') ?></td>
                    <td class="text-right"><strong>Rp <?= number_format($row['total_harga'], 0, ',', '.') ?></strong></td>
                    <td class="text-center">
                        <span class="badge <?= $badge_class ?>">
                            <?= $row['metode_pembayaran'] ?>
                        </span>
                    </td>
                </tr>
            <?php endforeach; ?>
            
            <?php if (count($transaksi_data) == 0): ?>
                <tr>
                    <td colspan="8" class="text-center" style="padding: 30px;">
                        Tidak ada data transaksi untuk periode ini
                    </td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
    
    <?php if (count($transaksi_data) > 0): ?>
    <div class="summary">
        <div class="summary-row">
            <span>Total Transaksi:</span>
            <span><?= count($transaksi_data) ?> transaksi</span>
        </div>
        <div class="summary-row">
            <span>Rata-rata per Transaksi:</span>
            <span>Rp <?= number_format($total_pendapatan / count($transaksi_data), 0, ',', '.') ?></span>
        </div>
        <div class="summary-row total">
            <span>TOTAL PENDAPATAN:</span>
            <span>Rp <?= number_format($total_pendapatan, 0, ',', '.') ?></span>
        </div>
    </div>
    <?php endif; ?>
    
    <div class="footer">
        <p>Dokumen ini dicetak secara otomatis dari Sistem Koperasi PUSDATIN</p>
        <p>© <?= date('Y') ?> Koperasi PUSDATIN - Semua hak dilindungi</p>
    </div>
</body>
</html>