<?php
session_start();
include 'config.php';

header('Content-Type: application/json');

if (!isset($_SESSION['role']) || $_SESSION['id_role'] != 7) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

$id_anggota = isset($_GET['id_anggota']) ? intval($_GET['id_anggota']) : 0;
$tahun = isset($_GET['tahun']) ? intval($_GET['tahun']) : date('Y');

$stmt = $conn->prepare("
    SELECT bulan, saldo, jasa 
    FROM tabungan_usipa 
    WHERE id_anggota = ? AND tahun = ?
    ORDER BY bulan ASC
");
$stmt->bind_param("ii", $id_anggota, $tahun);
$stmt->execute();
$result = $stmt->get_result();

$data = [];
$total_jasa = 0;
while ($row = $result->fetch_assoc()) {
    $data[] = $row;
    $total_jasa += floatval($row['jasa']);
}

echo json_encode([
    'success' => true,
    'data' => $data,
    'total_jasa' => $total_jasa,
    'jumlah_bulan' => count($data)
]);

$stmt->close();
$conn->close();