<?php
session_start();
include 'config.php';

header('Content-Type: application/json');

if (!isset($_SESSION['role']) || $_SESSION['id_role'] != 7) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

$id_anggota = isset($_GET['id_anggota']) ? intval($_GET['id_anggota']) : 0;
$tahun = isset($_GET['tahun']) ? intval($_GET['tahun']) : 0;

if ($id_anggota == 0 || $tahun == 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid parameters']);
    exit;
}

$stmt = $conn->prepare("
    SELECT bulan, saldo, setoran, pengambilan, tanggal_transaksi
    FROM tabungan_usipa
    WHERE id_anggota = ? AND tahun = ?
    ORDER BY bulan ASC
");

$stmt->bind_param("ii", $id_anggota, $tahun);
$stmt->execute();
$result = $stmt->get_result();

$data = [];
$total = 0;
$jumlah_bulan = 0;

while ($row = $result->fetch_assoc()) {
    $data[] = $row;
    $total += floatval($row['saldo']);
    $jumlah_bulan++;
}

echo json_encode([
    'success' => true,
    'data' => $data,
    'total' => $total,
    'jumlah_bulan' => $jumlah_bulan
]);
?>