<?php
session_start();
include 'config.php';

header('Content-Type: application/json');

if (!isset($_SESSION['role']) || $_SESSION['id_role'] != 7) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

$tahun = isset($_GET['tahun']) ? intval($_GET['tahun']) : date('Y');

$stmt = $conn->prepare("SELECT SUM(persentase_jasa) as total_persentase 
    FROM konfigurasi_jasa_bulanan 
    WHERE tahun = ? AND status = 'approved'");
$stmt->bind_param("i", $tahun);
$stmt->execute();
$result = $stmt->get_result();
$data = $result->fetch_assoc();

echo json_encode([
    'success' => true,
    'suku_bunga' => $data['total_persentase'] ?? 0
]);

$stmt->close();
$conn->close();