<?php
session_start();
include 'config.php';

// Jika sudah login, redirect ke dashboard sesuai role
if (isset($_SESSION['role']) && isset($_SESSION['id_role'])) {
    switch ($_SESSION['id_role']) {
        case 1: // Admin Koperasi
            header("Location: dashboard_admin.php");
            break;
        case 2: // Kepala Unit Toko
            header("Location: dashboard_kepalaunit_toko.php");
            break;
        case 3: // Payroll
            header("Location: dashboard_payroll.php");
            break;
        case 4: // Kasir Defmart
            header("Location: dashboard_kasir.php");
            break;
        case 5: // Anggota
            header("Location: dashboard_anggota.php");
            break;
        case 6: // Kepala Unit Jasa Umum
            header("Location: dashboard_kepalaunit_jasa.php");
            break;
        case 7: // Kepala Unit Simpan Pinjam Umum
            header("Location: dashboard_kepalaunit_sp.php");
            break;
        case 8: // Kepala Unit Simpan Pinjam Khusus
            header("Location: dashboard_kepalaunit_spkhusus.php");
            break;
        default:
            header("Location: index.php");
    }
    exit;
}

// Jika tombol login ditekan
if (isset($_POST['login'])) {
    $username = trim($_POST['username']);
    $password = md5($_POST['password']);

    $stmt = $conn->prepare("SELECT user.*, role.nama_role, role.id_role 
                            FROM user 
                            JOIN role ON user.id_role = role.id_role
                            WHERE username = ? AND password = ?");
    $stmt->bind_param("ss", $username, $password);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows == 1) {
        $data = $result->fetch_assoc();

        // Simpan data user ke session
        $_SESSION['id_user'] = $data['id_user'];
        $_SESSION['username'] = $data['username'];
        $_SESSION['role'] = $data['nama_role'];
        $_SESSION['id_role'] = $data['id_role'];
        $_SESSION['id_anggota'] = $data['id_anggota'];

        // Arahkan berdasarkan id_role
        switch ($data['id_role']) {
            case 1: // Admin Koperasi
                header("Location: dashboard_admin.php");
                break;
            case 2: // Kepala Unit Toko
                header("Location: dashboard_kepalaunit_toko.php");
                break;
            case 3: // Payroll
                header("Location: dashboard_payroll.php");
                break;
            case 4: // Kasir Defmart
                header("Location: dashboard_kasir.php");
                break;
            case 5: // Anggota
                header("Location: dashboard_anggota.php");
                break;
            case 6: // Kepala Unit Jasa Umum
                header("Location: dashboard_kepalaunit_jasa.php");
                break;
            case 7: // Kepala Unit Simpan Pinjam Umum
                header("Location: dashboard_kepalaunit_sp.php");
                break;
            case 8: // Kepala Unit Simpan Pinjam Khusus
                header("Location: dashboard_kepalaunit_spkhusus.php");
                break;
            default:
                header("Location: index.php");
        }
        exit;
    } else {
        $error = "Username atau password salah!";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Koperasi PUSDATIN</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            position: relative;
            overflow: hidden;
        }

        /* Animated Background Particles */
        .particles {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            overflow: hidden;
            z-index: 0;
        }

        .particle {
            position: absolute;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            animation: float-particle 15s infinite ease-in-out;
        }

        .particle:nth-child(1) { width: 80px; height: 80px; left: 10%; animation-delay: 0s; }
        .particle:nth-child(2) { width: 60px; height: 60px; left: 30%; animation-delay: 2s; }
        .particle:nth-child(3) { width: 100px; height: 100px; left: 50%; animation-delay: 4s; }
        .particle:nth-child(4) { width: 70px; height: 70px; left: 70%; animation-delay: 6s; }
        .particle:nth-child(5) { width: 90px; height: 90px; left: 85%; animation-delay: 8s; }

        @keyframes float-particle {
            0%, 100% {
                transform: translateY(0) rotate(0deg);
                opacity: 0.3;
            }
            50% {
                transform: translateY(-100vh) rotate(360deg);
                opacity: 0.8;
            }
        }
        
        .login-container {
            max-width: 1100px;
            margin: 0 auto;
            position: relative;
            z-index: 1;
            animation: slideIn 0.8s ease-out;
        }

        @keyframes slideIn {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .login-card {
            background: rgba(255, 255, 255, 0.98);
            backdrop-filter: blur(20px);
            border-radius: 30px;
            box-shadow: 0 30px 80px rgba(0, 0, 0, 0.4);
            overflow: hidden;
            border: 1px solid rgba(255, 255, 255, 0.3);
            transition: transform 0.3s ease;
        }

        .login-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 35px 90px rgba(0, 0, 0, 0.5);
        }
        
        .login-left {
            background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
            color: white;
            padding: 4rem 3rem;
            display: flex;
            flex-direction: column;
            justify-content: center;
            position: relative;
            overflow: hidden;
        }
        
        .login-left::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 1px, transparent 1px);
            background-size: 50px 50px;
            animation: float-bg 20s linear infinite;
        }
        
        @keyframes float-bg {
            0% { transform: translate(0, 0) rotate(0deg); }
            100% { transform: translate(-50px, -50px) rotate(360deg); }
        }

        /* Logo Container */
        .logo-container {
            position: relative;
            z-index: 2;
            text-align: center;
            margin-bottom: 2rem;
            animation: fadeInDown 1s ease-out;
        }

        @keyframes fadeInDown {
            from {
                opacity: 0;
                transform: translateY(-20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .logo-wrapper {
            width: 140px;
            height: 140px;
            margin: 0 auto 1.5rem;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            animation: pulse 2s ease-in-out infinite;
            position: relative;
            overflow: hidden;
        }

        .logo-wrapper::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(45deg, transparent, rgba(255, 255, 255, 0.3), transparent);
            transform: rotate(45deg);
            animation: shine 3s infinite;
        }

        @keyframes shine {
            0% { transform: translateX(-100%) translateY(-100%) rotate(45deg); }
            100% { transform: translateX(100%) translateY(100%) rotate(45deg); }
        }

        @keyframes pulse {
            0%, 100% {
                transform: scale(1);
                box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            }
            50% {
                transform: scale(1.05);
                box-shadow: 0 15px 40px rgba(0, 0, 0, 0.3);
            }
        }

        .logo-wrapper img {
            width: 100%;
            height: 100%;
            object-fit: contain;
            position: relative;
            z-index: 1;
        }

        /* Jika tidak ada logo, tampilkan icon default */
        .logo-icon {
            font-size: 5rem;
            position: relative;
            z-index: 1;
            animation: rotate-icon 4s linear infinite;
        }

        @keyframes rotate-icon {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .brand-title {
            font-size: 2.8rem;
            font-weight: 800;
            margin-bottom: 1rem;
            position: relative;
            z-index: 2;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.1);
            animation: fadeIn 1.2s ease-out;
        }

        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        
        .brand-subtitle {
            font-size: 1.2rem;
            opacity: 0.95;
            margin-bottom: 3rem;
            position: relative;
            z-index: 2;
            font-weight: 300;
            animation: fadeIn 1.4s ease-out;
        }
        
        .feature-item {
            display: flex;
            align-items: center;
            margin-bottom: 1.5rem;
            position: relative;
            z-index: 2;
            animation: slideInLeft 0.6s ease-out backwards;
        }

        .feature-item:nth-child(1) { animation-delay: 0.2s; }
        .feature-item:nth-child(2) { animation-delay: 0.4s; }
        .feature-item:nth-child(3) { animation-delay: 0.6s; }

        @keyframes slideInLeft {
            from {
                opacity: 0;
                transform: translateX(-30px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }
        
        .feature-icon {
            background: rgba(255, 255, 255, 0.25);
            border-radius: 50%;
            width: 50px;
            height: 50px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 1.2rem;
            font-size: 1.3rem;
            transition: all 0.3s ease;
        }

        .feature-item:hover .feature-icon {
            background: rgba(255, 255, 255, 0.4);
            transform: rotate(360deg) scale(1.1);
        }
        
        .login-right {
            padding: 4rem 3rem;
            animation: fadeInRight 0.8s ease-out;
        }

        @keyframes fadeInRight {
            from {
                opacity: 0;
                transform: translateX(30px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }
        
        .form-control {
            border: 2px solid #e9ecef;
            border-radius: 15px;
            padding: 14px 18px;
            font-size: 1rem;
            transition: all 0.3s ease;
            background: #f8f9fa;
        }
        
        .form-control:focus {
            border-color: #4facfe;
            box-shadow: 0 0 0 0.25rem rgba(79, 172, 254, 0.15);
            background: white;
            transform: translateY(-2px);
        }
        
        .btn-login {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 15px;
            padding: 14px 28px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1.5px;
            transition: all 0.4s ease;
            position: relative;
            overflow: hidden;
        }

        .btn-login::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
            transition: left 0.5s ease;
        }

        .btn-login:hover::before {
            left: 100%;
        }
        
        .btn-login:hover {
            transform: translateY(-3px);
            box-shadow: 0 15px 35px rgba(102, 126, 234, 0.5);
        }

        .btn-login:active {
            transform: translateY(-1px);
        }
        
        .alert {
            border-radius: 15px;
            border: none;
            animation: shake 0.5s ease;
        }

        @keyframes shake {
            0%, 100% { transform: translateX(0); }
            25% { transform: translateX(-10px); }
            75% { transform: translateX(10px); }
        }
        
        .input-group {
            position: relative;
        }
        
        .input-icon {
            position: absolute;
            left: 18px;
            top: 50%;
            transform: translateY(-50%);
            color: #6c757d;
            z-index: 10;
            transition: all 0.3s ease;
        }

        .form-control:focus ~ .input-icon,
        .form-control:focus + .input-icon {
            color: #4facfe;
            transform: translateY(-50%) scale(1.1);
        }
        
        .form-control.with-icon {
            padding-left: 50px;
        }

        .form-label {
            font-weight: 600;
            color: #495057;
            margin-bottom: 0.5rem;
        }

        /* Password Toggle */
        .password-toggle {
            position: absolute;
            right: 18px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: #6c757d;
            z-index: 10;
            transition: color 0.3s ease;
        }

        .password-toggle:hover {
            color: #4facfe;
        }
        
        @media (max-width: 768px) {
            .login-left {
                display: none;
            }
            .login-right {
                padding: 2.5rem 2rem;
            }
            .brand-title {
                font-size: 2.2rem;
            }
        }

        /* Loading animation */
        .btn-login.loading {
            pointer-events: none;
        }

        .btn-login.loading::after {
            content: '';
            position: absolute;
            width: 16px;
            height: 16px;
            top: 50%;
            left: 50%;
            margin-left: -8px;
            margin-top: -8px;
            border: 2px solid #ffffff;
            border-radius: 50%;
            border-top-color: transparent;
            animation: spinner 0.6s linear infinite;
        }

        @keyframes spinner {
            to { transform: rotate(360deg); }
        }
    </style>
</head>
<body>

<!-- Animated Background Particles -->
<div class="particles">
    <div class="particle"></div>
    <div class="particle"></div>
    <div class="particle"></div>
    <div class="particle"></div>
    <div class="particle"></div>
</div>

<div class="container login-container">
    <div class="row justify-content-center">
        <div class="col-lg-11">
            <div class="card login-card border-0">
                <div class="row g-0">
                    <!-- Left Side - Branding -->
                    <div class="col-lg-6 login-left">
                        <div class="logo-container">
                            <div class="logo-wrapper">
                                <!-- Ganti path 'assets/images/logo.png' dengan path logo Anda -->
                                <!-- Jika logo belum ada, icon default akan ditampilkan -->
                                <img src="img/logo.png" alt="Logo Koperasi" onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">
                                <i class="fas fa-university logo-icon" style="display: none;"></i>
                            </div>
                            <h1 class="brand-title">KOPERASI<br>PUSDATIN</h1>
                            <p class="brand-subtitle">Sistem ERP Koperasi Terpadu</p>
                        </div>
                        
                        <div>
                            <div class="feature-item">
                                <div class="feature-icon">
                                    <i class="fas fa-shield-alt"></i>
                                </div>
                                <div>
                                    <h6 class="mb-1 fw-bold">Keamanan Terjamin</h6>
                                    <small style="opacity: 0.9;">Sistem keamanan berlapis untuk melindungi data</small>
                                </div>
                            </div>
                            
                            <div class="feature-item">
                                <div class="feature-icon">
                                    <i class="fas fa-chart-line"></i>
                                </div>
                                <div>
                                    <h6 class="mb-1 fw-bold">Laporan Real-time</h6>
                                    <small style="opacity: 0.9;">Pantau keuangan dan transaksi secara langsung</small>
                                </div>
                            </div>
                            
                            <div class="feature-item">
                                <div class="feature-icon">
                                    <i class="fas fa-users"></i>
                                </div>
                                <div>
                                    <h6 class="mb-1 fw-bold">Multi-User Access</h6>
                                    <small style="opacity: 0.9;">Akses terbatas sesuai dengan peran pengguna</small>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Right Side - Login Form -->
                    <div class="col-lg-6 login-right">
                        <div class="text-center mb-4">
                            <h3 class="fw-bold text-dark mb-2">Selamat Datang</h3>
                            <p class="text-muted">Silakan masukkan kredensial Anda untuk melanjutkan</p>
                        </div>

                        <?php if (isset($error)): ?>
                            <div class="alert alert-danger d-flex align-items-center mb-4" role="alert">
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                <div><?= $error ?></div>
                            </div>
                        <?php endif; ?>

                        <form method="POST" class="needs-validation" novalidate id="loginForm">
                            <div class="mb-4">
                                <label for="username" class="form-label">Username</label>
                                <div class="input-group">
                                    <input type="text" 
                                           id="username"
                                           name="username" 
                                           class="form-control with-icon" 
                                           placeholder="Masukkan username Anda"
                                           value="<?= isset($_POST['username']) ? htmlspecialchars($_POST['username']) : '' ?>"
                                           required>
                                    <i class="fas fa-user input-icon"></i>
                                </div>
                            </div>
                            
                            <div class="mb-4">
                                <label for="password" class="form-label">Password</label>
                                <div class="input-group">
                                    <input type="password" 
                                           id="password"
                                           name="password" 
                                           class="form-control with-icon" 
                                           placeholder="Masukkan password Anda"
                                           required>
                                    <i class="fas fa-lock input-icon"></i>
                                    <i class="fas fa-eye password-toggle" onclick="togglePassword()"></i>
                                </div>
                            </div>
                            
                            <button type="submit" name="login" class="btn btn-login btn-primary w-100 mb-4">
                                <i class="fas fa-sign-in-alt me-2"></i>
                                Masuk ke Sistem
                            </button>
                        </form>

                        <div class="text-center">
                            <hr class="my-4">
                            <small class="text-muted">
                                <i class="fas fa-copyright me-1"></i>
                                2025 Koperasi Pusdatin - Sistem ERP Koperasi
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
    // Form validation
    (function() {
        'use strict';
        window.addEventListener('load', function() {
            var forms = document.getElementsByClassName('needs-validation');
            var validation = Array.prototype.filter.call(forms, function(form) {
                form.addEventListener('submit', function(event) {
                    if (form.checkValidity() === false) {
                        event.preventDefault();
                        event.stopPropagation();
                    } else {
                        // Add loading state to button
                        var btn = form.querySelector('.btn-login');
                        btn.classList.add('loading');
                        btn.innerHTML = '<span style="opacity: 0;">Loading...</span>';
                    }
                    form.classList.add('was-validated');
                }, false);
            });
        }, false);
    })();

    // Toggle password visibility
    function togglePassword() {
        var passwordInput = document.getElementById('password');
        var toggleIcon = document.querySelector('.password-toggle');
        
        if (passwordInput.type === 'password') {
            passwordInput.type = 'text';
            toggleIcon.classList.remove('fa-eye');
            toggleIcon.classList.add('fa-eye-slash');
        } else {
            passwordInput.type = 'password';
            toggleIcon.classList.remove('fa-eye-slash');
            toggleIcon.classList.add('fa-eye');
        }
    }

    // Add focus animation to inputs
    document.querySelectorAll('.form-control').forEach(input => {
        input.addEventListener('focus', function() {
            this.parentElement.classList.add('focused');
        });
        
        input.addEventListener('blur', function() {
            this.parentElement.classList.remove('focused');
        });
    });
</script>

</body>
</html>