<?php
session_start();
include 'config.php';

// Cek role user
if (!isset($_SESSION['role']) || ($_SESSION['role'] != 'Kasir' && $_SESSION['role'] != 'Admin')) {
    header("Location: index.php");
    exit;
}

// Ambil data anggota untuk dropdown
$q_anggota = $conn->query("SELECT id_anggota, nama_anggota FROM anggota ORDER BY nama_anggota ASC");

// Jika form disubmit
if (isset($_POST['simpan'])) {
    $id_anggota = $_POST['id_anggota'];
    $nama_barang = $_POST['nama_barang'];
    $qty = $_POST['qty'];
    $harga_satuan = $_POST['harga_satuan'];
    $metode_pembayaran = $_POST['metode_pembayaran'];

    $total_harga = $qty * $harga_satuan;

    $stmt = $conn->prepare("
        INSERT INTO defmart_transaksi (id_anggota, nama_barang, qty, harga_satuan, total_harga, metode_pembayaran)
        VALUES (?, ?, ?, ?, ?, ?)
    ");
    $stmt->bind_param("isidds", $id_anggota, $nama_barang, $qty, $harga_satuan, $total_harga, $metode_pembayaran);

    if ($stmt->execute()) {
        $success = "Transaksi berhasil disimpan.";
    } else {
        $error = "Gagal menyimpan transaksi: " . $conn->error;
    }
}

// Ambil semua transaksi terbaru
$q_transaksi = $conn->query("
    SELECT t.id_transaksi, a.nama_anggota, t.nama_barang, t.qty, t.harga_satuan, 
           t.total_harga, t.metode_pembayaran, t.tanggal_transaksi
    FROM defmart_transaksi t
    JOIN anggota a ON t.id_anggota = a.id_anggota
    ORDER BY t.tanggal_transaksi DESC
");
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Kasir Defmart - Input Transaksi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container py-5">
    <h2 class="text-center mb-4">📦 Input Transaksi Defmart</h2>
    <a href="dashboard_admin.php" class="btn btn-secondary mb-3">← Kembali ke Dashboard</a>

    <?php if (isset($success)): ?>
        <div class="alert alert-success"><?= $success ?></div>
    <?php elseif (isset($error)): ?>
        <div class="alert alert-danger"><?= $error ?></div>
    <?php endif; ?>

    <div class="card shadow-sm mb-5">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0">Form Input Transaksi</h5>
        </div>
        <div class="card-body">
            <form method="POST">
                <div class="mb-3">
                    <label class="form-label">Nama Anggota</label>
                    <select name="id_anggota" class="form-select" required>
                        <option value="">-- Pilih Anggota --</option>
                        <?php while ($row = $q_anggota->fetch_assoc()) { ?>
                            <option value="<?= $row['id_anggota'] ?>"><?= htmlspecialchars($row['nama_anggota']) ?></option>
                        <?php } ?>
                    </select>
                </div>

                <div class="mb-3">
                    <label class="form-label">Nama Barang</label>
                    <input type="text" name="nama_barang" class="form-control" required>
                </div>

                <div class="row">
                    <div class="col-md-4 mb-3">
                        <label class="form-label">Qty</label>
                        <input type="number" name="qty" class="form-control" min="1" required>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label class="form-label">Harga Satuan (Rp)</label>
                        <input type="number" name="harga_satuan" class="form-control" step="0.01" required>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label class="form-label">Metode Pembayaran</label>
                        <select name="metode_pembayaran" class="form-select" required>
                            <option value="Cash">Cash</option>
                            <option value="Debit">Debit</option>
                            <option value="Bon">Bon</option>
                        </select>
                    </div>
                </div>

                <button type="submit" name="simpan" class="btn btn-success">Simpan Transaksi</button>
            </form>
        </div>
    </div>

    <div class="card shadow-sm">
        <div class="card-header bg-dark text-white">
            <h5 class="mb-0">Daftar Transaksi Terbaru</h5>
        </div>
        <div class="card-body table-responsive">
            <table class="table table-striped align-middle">
                <thead class="table-dark">
                    <tr>
                        <th>No</th>
                        <th>Nama Anggota</th>
                        <th>Barang</th>
                        <th>Qty</th>
                        <th>Harga Satuan (Rp)</th>
                        <th>Total Harga (Rp)</th>
                        <th>Metode</th>
                        <th>Tanggal</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $no = 1; while ($row = $q_transaksi->fetch_assoc()) { ?>
                        <tr>
                            <td><?= $no++ ?></td>
                            <td><?= htmlspecialchars($row['nama_anggota']) ?></td>
                            <td><?= htmlspecialchars($row['nama_barang']) ?></td>
                            <td><?= $row['qty'] ?></td>
                            <td><?= number_format($row['harga_satuan'], 0, ',', '.') ?></td>
                            <td><?= number_format($row['total_harga'], 0, ',', '.') ?></td>
                            <td><?= $row['metode_pembayaran'] ?></td>
                            <td><?= $row['tanggal_transaksi'] ?></td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

</body>
</html>
