<?php
session_start();
include 'config.php';

// Cek apakah user sudah login dan memiliki role Admin Koperasi
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'Admin Koperasi') {
    header("Location: index.php");
    exit;
}

$username = $_SESSION['username'];
$sukses = $error = '';

// Proses Tambah Anggota + User
if (isset($_POST['tambah_anggota'])) {
    $nama = trim($_POST['nama']);
    $nip = trim($_POST['nip']);
    $jabatan = trim($_POST['jabatan']);
    $gaji = floatval($_POST['gaji']);
    $tanggal_masuk = $_POST['tanggal_masuk'];
    $username_baru = trim($_POST['username']);
    $password = $_POST['password'];
    $id_role = intval($_POST['id_role']);

    // Validasi
    if (!$nama || !$nip || !$jabatan || !$tanggal_masuk || !$username_baru || !$password) {
        $error = "Semua field wajib diisi!";
    } elseif (strlen($password) < 6) {
        $error = "Password minimal 6 karakter!";
    } else {
        // Cek NIP sudah ada
        $cek_nip = $conn->query("SELECT id_anggota FROM anggota WHERE nip = '$nip'");
        if ($cek_nip->num_rows > 0) {
            $error = "NIP sudah terdaftar!";
        } else {
            // Cek username sudah ada
            $cek_user = $conn->query("SELECT id_user FROM user WHERE username = '$username_baru'");
            if ($cek_user->num_rows > 0) {
                $error = "Username sudah terdaftar!";
            } else {
                // Mulai transaction
                $conn->begin_transaction();
                try {
                    // Insert User terlebih dahulu
                    $password_hash = md5($password);
                    $stmt_user = $conn->prepare("INSERT INTO user (username, password, id_role) VALUES (?, ?, ?)");
                    $stmt_user->bind_param("ssi", $username_baru, $password_hash, $id_role);
                    $stmt_user->execute();
                    $id_user = $conn->insert_id;

                    // Insert Anggota
                    $stmt_anggota = $conn->prepare("INSERT INTO anggota (nama, nip, jabatan, gaji, tanggal_masuk, id_user) VALUES (?, ?, ?, ?, ?, ?)");
                    $stmt_anggota->bind_param("sssdsi", $nama, $nip, $jabatan, $gaji, $tanggal_masuk, $id_user);
                    $stmt_anggota->execute();
                    $id_anggota_baru = $conn->insert_id;

                    // Update user table dengan id_anggota yang baru dibuat
                    $stmt_update = $conn->prepare("UPDATE user SET id_anggota = ? WHERE id_user = ?");
                    $stmt_update->bind_param("ii", $id_anggota_baru, $id_user);
                    $stmt_update->execute();

                    $conn->commit();
                    $sukses = "Anggota dan User berhasil ditambahkan!";
                    
                    // Redirect untuk mencegah resubmit
                    header("Location: " . $_SERVER['PHP_SELF'] . "?success=1");
                    exit;
                } catch (Exception $e) {
                    $conn->rollback();
                    $error = "Gagal menambahkan data: " . $e->getMessage();
                }
            }
        }
    }
}

// Proses Edit Anggota
if (isset($_POST['edit_anggota'])) {
    $id_anggota = intval($_POST['id_anggota']);
    $nama = trim($_POST['nama']);
    $nip = trim($_POST['nip']);
    $jabatan = trim($_POST['jabatan']);
    $gaji = floatval($_POST['gaji']);
    $tanggal_masuk = $_POST['tanggal_masuk'];

    if (!$nama || !$nip || !$jabatan || !$tanggal_masuk) {
        $error = "Semua field wajib diisi!";
    } else {
        // Cek apakah NIP sudah digunakan oleh anggota lain
        $cek_nip = $conn->query("SELECT id_anggota FROM anggota WHERE nip = '$nip' AND id_anggota != $id_anggota");
        if ($cek_nip->num_rows > 0) {
            $error = "NIP sudah digunakan oleh anggota lain!";
        } else {
            $stmt = $conn->prepare("UPDATE anggota SET nama = ?, nip = ?, jabatan = ?, gaji = ?, tanggal_masuk = ? WHERE id_anggota = ?");
            $stmt->bind_param("sssdsi", $nama, $nip, $jabatan, $gaji, $tanggal_masuk, $id_anggota);
            
            if ($stmt->execute()) {
                $sukses = "Data anggota berhasil diperbarui!";
                header("Location: " . $_SERVER['PHP_SELF'] . "?success=2");
                exit;
            } else {
                $error = "Gagal memperbarui data!";
            }
        }
    }
}

// Proses Ubah Password
if (isset($_POST['ubah_password'])) {
    $id_user = intval($_POST['id_user']);
    $password_baru = $_POST['password_baru'];
    $konfirmasi_password = $_POST['konfirmasi_password'];

    if (!$password_baru || !$konfirmasi_password) {
        $error = "Password dan konfirmasi password wajib diisi!";
    } elseif (strlen($password_baru) < 6) {
        $error = "Password minimal 6 karakter!";
    } elseif ($password_baru !== $konfirmasi_password) {
        $error = "Password dan konfirmasi password tidak cocok!";
    } else {
        $password_hash = md5($password_baru);
        $stmt = $conn->prepare("UPDATE user SET password = ? WHERE id_user = ?");
        $stmt->bind_param("si", $password_hash, $id_user);
        
        if ($stmt->execute()) {
            $sukses = "Password berhasil diubah!";
            header("Location: " . $_SERVER['PHP_SELF'] . "?success=4");
            exit;
        } else {
            $error = "Gagal mengubah password!";
        }
    }
}

// Proses Hapus Anggota
if (isset($_GET['hapus'])) {
    $id_anggota = intval($_GET['hapus']);
    
    // Ambil id_user
    $anggota = $conn->query("SELECT id_user FROM anggota WHERE id_anggota = $id_anggota")->fetch_assoc();
    
    if ($anggota) {
        $conn->begin_transaction();
        try {
            // Hapus dari anggota
            $conn->query("DELETE FROM anggota WHERE id_anggota = $id_anggota");
            
            // Hapus dari user jika ada
            if ($anggota['id_user']) {
                $conn->query("DELETE FROM user WHERE id_user = " . $anggota['id_user']);
            }
            
            $conn->commit();
            header("Location: " . $_SERVER['PHP_SELF'] . "?success=3");
            exit;
        } catch (Exception $e) {
            $conn->rollback();
            $error = "Gagal menghapus data: " . $e->getMessage();
        }
    }
}

// Handle success messages from redirect
if (isset($_GET['success'])) {
    switch ($_GET['success']) {
        case 1:
            $sukses = "Anggota dan User berhasil ditambahkan!";
            break;
        case 2:
            $sukses = "Data anggota berhasil diperbarui!";
            break;
        case 3:
            $sukses = "Anggota berhasil dihapus!";
            break;
        case 4:
            $sukses = "Password berhasil diubah!";
            break;
    }
}

// Ambil data role
$roles = $conn->query("SELECT id_role, nama_role FROM role WHERE id_role != 1");

// Ambil data anggota dengan join ke user
$anggota = $conn->query("SELECT a.*, u.username, u.id_user, r.nama_role FROM anggota a LEFT JOIN user u ON a.id_user = u.id_user LEFT JOIN role r ON u.id_role = r.id_role ORDER BY a.id_anggota DESC");
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kelola Anggota - Koperasi PUSDATIN</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {
                            50: '#f5f7ff',
                            100: '#ebf0ff',
                            200: '#d6e0ff',
                            300: '#b3c7ff',
                            400: '#8ca5ff',
                            500: '#667eea',
                            600: '#5568d3',
                            700: '#4451b8',
                            800: '#343b96',
                            900: '#252b70',
                        },
                        purple: {
                            500: '#764ba2',
                            600: '#653a8f',
                            700: '#54297c',
                        }
                    }
                }
            }
        }
    </script>
    <style>
        .menu-item {
            transition: all 0.3s ease;
        }
        
        .menu-item:hover {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            transform: translateX(8px);
        }
        
        .menu-item:hover i,
        .menu-item:hover span {
            color: white;
        }
        
        /* Custom Scrollbar */
        ::-webkit-scrollbar {
            width: 8px;
            height: 8px;
        }
        
        ::-webkit-scrollbar-track {
            background: #f1f1f1;
            border-radius: 10px;
        }
        
        ::-webkit-scrollbar-thumb {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 10px;
        }
        
        ::-webkit-scrollbar-thumb:hover {
            background: #5568d3;
        }

        .modal {
            display: none;
            position: fixed;
            z-index: 50;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0,0,0,0.4);
        }

        .modal.show {
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .modal-content {
            background-color: #fefefe;
            margin: auto;
            padding: 0;
            border: none;
            border-radius: 1rem;
            width: 90%;
            max-width: 800px;
            max-height: 90vh;
            overflow-y: auto;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
        }
    </style>
</head>
<body class="bg-gradient-to-br from-primary-500 via-purple-500 to-purple-600 min-h-screen">
    
    <!-- Mobile Menu Toggle -->
    <button id="mobileMenuBtn" class="fixed top-4 left-4 z-50 lg:hidden bg-white rounded-lg p-3 shadow-lg">
        <i class="fas fa-bars text-primary-600 text-xl"></i>
    </button>

    <!-- Sidebar -->
    <aside id="sidebar" class="fixed left-0 top-0 h-full w-64 bg-white shadow-2xl z-40 transform -translate-x-full lg:translate-x-0 transition-transform duration-300 ease-in-out">
        <!-- Logo & Brand -->
        <div class="p-6 border-b border-gray-200">
            <div class="flex items-center space-x-3">
                <div class="w-12 h-12 bg-gradient-to-br from-primary-500 to-purple-600 rounded-xl flex items-center justify-center overflow-hidden">
                    <img src="img/logo.png" alt="Logo Pusdatin" class="w-full h-full object-cover">
                </div>
                <div>
                    <h1 class="text-xl font-bold bg-gradient-to-r from-primary-600 to-purple-600 bg-clip-text text-transparent">
                        PUSDATIN
                    </h1>
                    <p class="text-xs text-gray-500">Koperasi Admin</p>
                </div>
            </div>
        </div>

        <!-- User Profile -->
        <div class="p-6 border-b border-gray-200">
            <div class="flex items-center space-x-3">
                <div class="w-12 h-12 bg-gradient-to-br from-primary-400 to-purple-500 rounded-full flex items-center justify-center">
                    <span class="text-white font-bold text-lg"><?= strtoupper(substr($username, 0, 1)) ?></span>
                </div>
                <div class="flex-1">
                    <p class="text-sm font-semibold text-gray-800"><?= htmlspecialchars($username) ?></p>
                    <p class="text-xs text-gray-500">Administrator</p>
                </div>
            </div>
        </div>

        <!-- Navigation Menu -->
        <nav class="p-4 space-y-2 overflow-y-auto" style="max-height: calc(100vh - 280px);">
            <a href="dashboard_admin.php" class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg text-gray-700 hover:text-white">
                <i class="fas fa-home text-lg w-6"></i>
                <span class="font-medium">Dashboard</span>
            </a>
            
            <a href="kelola_anggota.php" class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg bg-gradient-to-r from-primary-500 to-purple-600 text-white">
                <i class="fas fa-users text-lg w-6"></i>
                <span class="font-medium">Kelola Anggota</span>
            </a>

            <div class="border-t border-gray-200 my-4"></div>

            <a href="logout.php" class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg text-red-600 hover:bg-red-600 hover:text-white">
                <i class="fas fa-sign-out-alt text-lg w-6"></i>
                <span class="font-medium">Logout</span>
            </a>
        </nav>
    </aside>

    <!-- Main Content -->
    <main class="lg:ml-64 min-h-screen">
        <!-- Header -->
        <header class="bg-white bg-opacity-95 backdrop-blur-lg shadow-lg sticky top-0 z-30">
            <div class="px-6 py-4">
                <div class="flex items-center justify-between">
                    <div>
                        <h2 class="text-2xl font-bold text-gray-800">Kelola Anggota</h2>
                        <p class="text-gray-600 text-sm mt-1">Manajemen data anggota koperasi PUSDATIN</p>
                    </div>
                    <div class="flex items-center space-x-4">
                        <div class="hidden md:flex items-center space-x-2 bg-primary-50 px-4 py-2 rounded-lg">
                            <i class="fas fa-calendar text-primary-600"></i>
                            <span class="text-sm text-gray-700"><?= date('d F Y') ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </header>

        <!-- Content Area -->
        <div class="p-6 space-y-6">
            
            <!-- Alert Messages -->
            <?php if ($sukses): ?>
                <div class="bg-green-50 border-l-4 border-green-500 rounded-lg p-4 shadow-md animate-fade-in">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <i class="fas fa-check-circle text-green-500 text-2xl"></i>
                        </div>
                        <div class="ml-3">
                            <p class="text-sm font-medium text-green-800"><?= $sukses ?></p>
                        </div>
                        <div class="ml-auto pl-3">
                            <button onclick="this.parentElement.parentElement.parentElement.remove()" class="text-green-500 hover:text-green-700">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if ($error): ?>
                <div class="bg-red-50 border-l-4 border-red-500 rounded-lg p-4 shadow-md animate-fade-in">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <i class="fas fa-exclamation-circle text-red-500 text-2xl"></i>
                        </div>
                        <div class="ml-3">
                            <p class="text-sm font-medium text-red-800"><?= $error ?></p>
                        </div>
                        <div class="ml-auto pl-3">
                            <button onclick="this.parentElement.parentElement.parentElement.remove()" class="text-red-500 hover:text-red-700">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Action Buttons -->
            <div class="flex flex-wrap gap-3">
                <button onclick="openModal('modalTambahAnggota')" class="inline-flex items-center px-6 py-3 bg-gradient-to-r from-primary-500 to-purple-600 text-white font-semibold rounded-xl shadow-lg hover:shadow-xl transition-all hover:scale-105">
                    <i class="fas fa-plus-circle mr-2"></i>
                    Tambah Anggota Baru
                </button>
                <a href="dashboard_admin.php" class="inline-flex items-center px-6 py-3 bg-white text-gray-700 font-semibold rounded-xl shadow-lg hover:shadow-xl transition-all hover:scale-105">
                    <i class="fas fa-arrow-left mr-2"></i>
                    Kembali ke Dashboard
                </a>
            </div>

            <!-- Data Table -->
            <div class="bg-white rounded-2xl shadow-xl overflow-hidden">
                <div class="bg-gradient-to-r from-primary-500 to-purple-600 px-6 py-4">
                    <h3 class="text-xl font-bold text-white flex items-center">
                        <i class="fas fa-table mr-3"></i>
                        Data Anggota Koperasi
                    </h3>
                </div>
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">No</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Nama</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">NIP</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Jabatan</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Gaji</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Tanggal Masuk</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Username</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Role</th>
                                <th class="px-6 py-4 text-center text-xs font-semibold text-gray-700 uppercase tracking-wider">Aksi</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200">
                            <?php 
                            $no = 1;
                            if ($anggota->num_rows > 0):
                                while ($row = $anggota->fetch_assoc()): 
                            ?>
                                <tr class="hover:bg-gray-50 transition-colors">
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?= $no++ ?></td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="flex items-center">
                                            <div class="w-10 h-10 bg-gradient-to-br from-primary-400 to-purple-500 rounded-full flex items-center justify-center">
                                                <span class="text-white font-bold text-sm"><?= strtoupper(substr($row['nama'], 0, 1)) ?></span>
                                            </div>
                                            <div class="ml-3">
                                                <p class="text-sm font-semibold text-gray-900"><?= htmlspecialchars($row['nama']) ?></p>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?= htmlspecialchars($row['nip']) ?></td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?= htmlspecialchars($row['jabatan']) ?></td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">Rp <?= number_format($row['gaji'], 0, ',', '.') ?></td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?= date('d/m/Y', strtotime($row['tanggal_masuk'])) ?></td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        <?= $row['username'] ? htmlspecialchars($row['username']) : '<span class="text-gray-400">-</span>' ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                                        <?php if ($row['nama_role']): ?>
                                            <span class="px-3 py-1 rounded-full text-xs font-semibold bg-primary-100 text-primary-800">
                                                <?= htmlspecialchars($row['nama_role']) ?>
                                            </span>
                                        <?php else: ?>
                                            <span class="text-gray-400">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-center text-sm">
                                        <button onclick='openEditModal(<?= json_encode($row) ?>)' class="text-primary-600 hover:text-primary-800 mx-1" title="Edit Data">
                                            <i class="fas fa-edit text-lg"></i>
                                        </button>
                                        <?php if ($row['id_user']): ?>
                                        <button onclick='openPasswordModal(<?= json_encode($row) ?>)' class="text-yellow-600 hover:text-yellow-800 mx-1" title="Ubah Password">
                                            <i class="fas fa-key text-lg"></i>
                                        </button>
                                        <?php endif; ?>
                                        <button onclick="confirmDelete(<?= $row['id_anggota'] ?>, '<?= htmlspecialchars($row['nama']) ?>')" class="text-red-600 hover:text-red-800 mx-1" title="Hapus">
                                            <i class="fas fa-trash text-lg"></i>
                                        </button>
                                    </td>
                                </tr>
                            <?php 
                                endwhile;
                            else:
                            ?>
                                <tr>
                                    <td colspan="9" class="px-6 py-12 text-center">
                                        <div class="flex flex-col items-center justify-center">
                                            <i class="fas fa-users text-6xl text-gray-300 mb-4"></i>
                                            <p class="text-gray-500 text-lg">Belum ada data anggota</p>
                                        </div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>

        </div>
    </main>

    <!-- Modal Tambah Anggota -->
    <div id="modalTambahAnggota" class="modal">
        <div class="modal-content">
            <div class="bg-gradient-to-r from-primary-500 to-purple-600 px-6 py-4 rounded-t-xl">
                <div class="flex items-center justify-between">
                    <h3 class="text-xl font-bold text-white flex items-center">
                        <i class="fas fa-user-plus mr-3"></i>
                        Tambah Anggota Baru
                    </h3>
                    <button onclick="closeModal('modalTambahAnggota')" class="text-white hover:text-gray-200">
                        <i class="fas fa-times text-2xl"></i>
                    </button>
                </div>
            </div>
            
            <form method="POST" class="p-6">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    
                    <!-- Data Anggota Section -->
                    <div class="md:col-span-2">
                        <h4 class="text-lg font-semibold text-gray-800 mb-4 flex items-center">
                            <i class="fas fa-id-card text-primary-600 mr-2"></i>
                            Data Anggota
                        </h4>
                    </div>

                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            Nama Lengkap <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="nama" required 
                            class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent transition-all"
                            placeholder="Masukkan nama lengkap">
                    </div>

                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            NIP <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="nip" required 
                            class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent transition-all"
                            placeholder="Masukkan NIP">
                    </div>

                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            Jabatan <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="jabatan" required 
                            class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent transition-all"
                            placeholder="Masukkan jabatan">
                    </div>

                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            Gaji <span class="text-red-500">*</span>
                        </label>
                        <input type="number" name="gaji" step="0.01" required 
                            class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent transition-all"
                            placeholder="Masukkan gaji">
                    </div>

                    <div class="md:col-span-2">
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            Tanggal Masuk <span class="text-red-500">*</span>
                        </label>
                        <input type="date" name="tanggal_masuk" required 
                            class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent transition-all">
                    </div>

                    <!-- Data User Section -->
                    <div class="md:col-span-2 mt-4">
                        <div class="border-t border-gray-200 pt-4">
                            <h4 class="text-lg font-semibold text-gray-800 mb-4 flex items-center">
                                <i class="fas fa-user-lock text-primary-600 mr-2"></i>
                                Data Akun User
                            </h4>
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            Username <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="username" required 
                            class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent transition-all"
                            placeholder="Masukkan username">
                    </div>

                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            Password <span class="text-red-500">*</span>
                        </label>
                        <div class="relative">
                            <input type="password" id="password_tambah" name="password" required 
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent transition-all"
                                placeholder="Minimal 6 karakter">
                            <button type="button" onclick="togglePassword('password_tambah')" 
                                class="absolute right-3 top-1/2 transform -translate-y-1/2 text-gray-500 hover:text-gray-700">
                                <i class="fas fa-eye"></i>
                            </button>
                        </div>
                        <p class="text-xs text-gray-500 mt-1">Minimal 6 karakter</p>
                    </div>

                    <div class="md:col-span-2">
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            Role <span class="text-red-500">*</span>
                        </label>
                        <select name="id_role" required 
                            class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent transition-all">
                            <option value="">-- Pilih Role --</option>
                            <?php 
                            $roles->data_seek(0);
                            while ($role = $roles->fetch_assoc()): 
                            ?>
                                <option value="<?= $role['id_role'] ?>"><?= htmlspecialchars($role['nama_role']) ?></option>
                            <?php endwhile; ?>
                        </select>
                    </div>

                </div>

                <div class="flex justify-end space-x-3 mt-6 pt-6 border-t border-gray-200">
                    <button type="button" onclick="closeModal('modalTambahAnggota')" 
                        class="px-6 py-3 bg-gray-200 text-gray-700 font-semibold rounded-lg hover:bg-gray-300 transition-all">
                        <i class="fas fa-times mr-2"></i>
                        Batal
                    </button>
                    <button type="submit" name="tambah_anggota" 
                        class="px-6 py-3 bg-gradient-to-r from-primary-500 to-purple-600 text-white font-semibold rounded-lg hover:shadow-lg transition-all">
                        <i class="fas fa-save mr-2"></i>
                        Simpan
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Modal Edit Anggota -->
    <div id="modalEditAnggota" class="modal">
        <div class="modal-content">
            <div class="bg-gradient-to-r from-primary-500 to-purple-600 px-6 py-4 rounded-t-xl">
                <div class="flex items-center justify-between">
                    <h3 class="text-xl font-bold text-white flex items-center">
                        <i class="fas fa-edit mr-3"></i>
                        Edit Data Anggota
                    </h3>
                    <button onclick="closeModal('modalEditAnggota')" class="text-white hover:text-gray-200">
                        <i class="fas fa-times text-2xl"></i>
                    </button>
                </div>
            </div>
            
            <form method="POST" class="p-6">
                <input type="hidden" name="id_anggota" id="edit_id_anggota">
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            Nama Lengkap <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="nama" id="edit_nama" required 
                            class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent transition-all"
                            placeholder="Masukkan nama lengkap">
                    </div>

                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            NIP <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="nip" id="edit_nip" required 
                            class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent transition-all"
                            placeholder="Masukkan NIP">
                    </div>

                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            Jabatan <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="jabatan" id="edit_jabatan" required 
                            class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent transition-all"
                            placeholder="Masukkan jabatan">
                    </div>

                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            Gaji <span class="text-red-500">*</span>
                        </label>
                        <input type="number" name="gaji" id="edit_gaji" step="0.01" required 
                            class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent transition-all"
                            placeholder="Masukkan gaji">
                    </div>

                    <div class="md:col-span-2">
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            Tanggal Masuk <span class="text-red-500">*</span>
                        </label>
                        <input type="date" name="tanggal_masuk" id="edit_tanggal_masuk" required 
                            class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent transition-all">
                    </div>

                    <div class="md:col-span-2">
                        <div class="bg-blue-50 border-l-4 border-blue-500 p-4 rounded">
                            <div class="flex">
                                <div class="flex-shrink-0">
                                    <i class="fas fa-info-circle text-blue-500"></i>
                                </div>
                                <div class="ml-3">
                                    <p class="text-sm text-blue-700">
                                        <strong>Informasi:</strong> Data username dan password tidak dapat diubah melalui form ini. Untuk mengubah password, gunakan tombol <i class="fas fa-key"></i> di tabel data.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

                <div class="flex justify-end space-x-3 mt-6 pt-6 border-t border-gray-200">
                    <button type="button" onclick="closeModal('modalEditAnggota')" 
                        class="px-6 py-3 bg-gray-200 text-gray-700 font-semibold rounded-lg hover:bg-gray-300 transition-all">
                        <i class="fas fa-times mr-2"></i>
                        Batal
                    </button>
                    <button type="submit" name="edit_anggota" 
                        class="px-6 py-3 bg-gradient-to-r from-primary-500 to-purple-600 text-white font-semibold rounded-lg hover:shadow-lg transition-all">
                        <i class="fas fa-save mr-2"></i>
                        Update
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Modal Ubah Password -->
    <div id="modalUbahPassword" class="modal">
        <div class="modal-content" style="max-width: 500px;">
            <div class="bg-gradient-to-r from-yellow-500 to-orange-600 px-6 py-4 rounded-t-xl">
                <div class="flex items-center justify-between">
                    <h3 class="text-xl font-bold text-white flex items-center">
                        <i class="fas fa-key mr-3"></i>
                        Ubah Password
                    </h3>
                    <button onclick="closeModal('modalUbahPassword')" class="text-white hover:text-gray-200">
                        <i class="fas fa-times text-2xl"></i>
                    </button>
                </div>
            </div>
            
            <form method="POST" class="p-6">
                <input type="hidden" name="id_user" id="password_id_user">
                
                <div class="mb-6">
                    <div class="bg-yellow-50 border-l-4 border-yellow-500 p-4 rounded">
                        <div class="flex">
                            <div class="flex-shrink-0">
                                <i class="fas fa-user text-yellow-500"></i>
                            </div>
                            <div class="ml-3">
                                <p class="text-sm text-yellow-700">
                                    <strong>Anggota:</strong> <span id="password_nama_anggota"></span><br>
                                    <strong>Username:</strong> <span id="password_username"></span>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            Password Baru <span class="text-red-500">*</span>
                        </label>
                        <div class="relative">
                            <input type="password" id="password_baru" name="password_baru" required 
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-yellow-500 focus:border-transparent transition-all"
                                placeholder="Masukkan password baru (minimal 6 karakter)">
                            <button type="button" onclick="togglePassword('password_baru')" 
                                class="absolute right-3 top-1/2 transform -translate-y-1/2 text-gray-500 hover:text-gray-700">
                                <i class="fas fa-eye"></i>
                            </button>
                        </div>
                        <p class="text-xs text-gray-500 mt-1">Minimal 6 karakter</p>
                    </div>

                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            Konfirmasi Password <span class="text-red-500">*</span>
                        </label>
                        <div class="relative">
                            <input type="password" id="konfirmasi_password" name="konfirmasi_password" required 
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-yellow-500 focus:border-transparent transition-all"
                                placeholder="Ulangi password baru">
                            <button type="button" onclick="togglePassword('konfirmasi_password')" 
                                class="absolute right-3 top-1/2 transform -translate-y-1/2 text-gray-500 hover:text-gray-700">
                                <i class="fas fa-eye"></i>
                            </button>
                        </div>
                    </div>

                    <div class="bg-red-50 border-l-4 border-red-500 p-4 rounded">
                        <div class="flex">
                            <div class="flex-shrink-0">
                                <i class="fas fa-exclamation-triangle text-red-500"></i>
                            </div>
                            <div class="ml-3">
                                <p class="text-sm text-red-700">
                                    <strong>Peringatan:</strong> Pastikan password yang dimasukkan sudah benar. Anggota harus menggunakan password baru untuk login setelah perubahan ini.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="flex justify-end space-x-3 mt-6 pt-6 border-t border-gray-200">
                    <button type="button" onclick="closeModal('modalUbahPassword')" 
                        class="px-6 py-3 bg-gray-200 text-gray-700 font-semibold rounded-lg hover:bg-gray-300 transition-all">
                        <i class="fas fa-times mr-2"></i>
                        Batal
                    </button>
                    <button type="submit" name="ubah_password" 
                        class="px-6 py-3 bg-gradient-to-r from-yellow-500 to-orange-600 text-white font-semibold rounded-lg hover:shadow-lg transition-all">
                        <i class="fas fa-save mr-2"></i>
                        Ubah Password
                    </button>
                </div>
            </form>
        </div>
    </div>

    <script>
        // Mobile Menu Toggle
        document.getElementById('mobileMenuBtn').addEventListener('click', function() {
            const sidebar = document.getElementById('sidebar');
            sidebar.classList.toggle('-translate-x-full');
        });

        // Close sidebar when clicking outside on mobile
        document.addEventListener('click', function(event) {
            const sidebar = document.getElementById('sidebar');
            const menuBtn = document.getElementById('mobileMenuBtn');
            
            if (window.innerWidth < 1024) {
                if (!sidebar.contains(event.target) && !menuBtn.contains(event.target)) {
                    sidebar.classList.add('-translate-x-full');
                }
            }
        });

        // Modal Functions
        function openModal(modalId) {
            document.getElementById(modalId).classList.add('show');
            document.body.style.overflow = 'hidden';
        }

        function closeModal(modalId) {
            document.getElementById(modalId).classList.remove('show');
            document.body.style.overflow = 'auto';
        }

        // Close modal when clicking outside
        window.onclick = function(event) {
            if (event.target.classList.contains('modal')) {
                event.target.classList.remove('show');
                document.body.style.overflow = 'auto';
            }
        }

        // Toggle Password Visibility
        function togglePassword(inputId) {
            const input = document.getElementById(inputId);
            const icon = event.currentTarget.querySelector('i');
            
            if (input.type === 'password') {
                input.type = 'text';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            } else {
                input.type = 'password';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            }
        }

        // Open Edit Modal with Data
        function openEditModal(data) {
            document.getElementById('edit_id_anggota').value = data.id_anggota;
            document.getElementById('edit_nama').value = data.nama;
            document.getElementById('edit_nip').value = data.nip;
            document.getElementById('edit_jabatan').value = data.jabatan;
            document.getElementById('edit_gaji').value = data.gaji;
            document.getElementById('edit_tanggal_masuk').value = data.tanggal_masuk;
            
            openModal('modalEditAnggota');
        }

        // Open Password Modal with Data
        function openPasswordModal(data) {
            document.getElementById('password_id_user').value = data.id_user;
            document.getElementById('password_nama_anggota').textContent = data.nama;
            document.getElementById('password_username').textContent = data.username;
            
            // Reset form
            document.getElementById('password_baru').value = '';
            document.getElementById('konfirmasi_password').value = '';
            
            openModal('modalUbahPassword');
        }

        // Confirm Delete
        function confirmDelete(id, nama) {
            if (confirm('Apakah Anda yakin ingin menghapus anggota "' + nama + '"?\n\nData yang dihapus tidak dapat dikembalikan!')) {
                window.location.href = '?hapus=' + id;
            }
        }

        // Auto close alerts after 5 seconds
        setTimeout(function() {
            const alerts = document.querySelectorAll('.animate-fade-in');
            alerts.forEach(function(alert) {
                alert.style.transition = 'opacity 0.5s';
                alert.style.opacity = '0';
                setTimeout(function() {
                    alert.remove();
                }, 500);
            });
        }, 5000);

        // Add fade-in animation
        const style = document.createElement('style');
        style.textContent = `
            @keyframes fadeIn {
                from {
                    opacity: 0;
                    transform: translateY(-10px);
                }
                to {
                    opacity: 1;
                    transform: translateY(0);
                }
            }
            .animate-fade-in {
                animation: fadeIn 0.3s ease-in-out;
            }
        `;
        document.head.appendChild(style);
    </script>

</body>
</html>