<div class="fixed left-0 top-0 h-screen w-64 gradient-primary text-white z-40">
    <div class="p-6 border-b border-white border-opacity-20">
        <div class="flex items-center space-x-3 mb-4">
            <img src="img/logo.png" alt="Logo" class="w-12 h-12 rounded-full object-cover bg-white p-1" onerror="this.src='data:image/svg+xml,%3Csvg xmlns=%22http://www.w3.org/2000/svg%22 viewBox=%220 0 100 100%22%3E%3Crect fill=%22%23667eea%22 width=%22100%22 height=%22100%22/%3E%3Ctext x=%2250%22 y=%2250%22 font-size=%2240%22 fill=%22white%22 text-anchor=%22middle%22 dy=%22.3em%22%3E%F0%9F%8F%AA%3C/text%3E%3C/svg%3E'">
            <div>
                <h2 class="font-bold text-lg">DEFMART</h2>
                <p class="text-xs text-white text-opacity-75">Kasir</p>
            </div>
        </div>
    </div>

    <nav class="mt-6 px-4 space-y-2">
        <?php
        $current_page = basename($_SERVER['PHP_SELF']);
        ?>
        <a href="kasir_defmart.php" class="nav-item flex items-center space-x-3 px-4 py-3 rounded-lg <?= $current_page == 'kasir_defmart.php' ? 'bg-white bg-opacity-20' : '' ?> text-white transition hover:bg-white hover:bg-opacity-20">
            <i class="fas fa-chart-line w-5"></i>
            <span>Dashboard</span>
        </a>
        <a href="tambah_transaksi_kasir.php" class="nav-item flex items-center space-x-3 px-4 py-3 rounded-lg <?= $current_page == 'tambah_transaksi_kasir.php' ? 'bg-white bg-opacity-20' : '' ?> text-white transition hover:bg-white hover:bg-opacity-20">
            <i class="fas fa-plus-circle w-5"></i>
            <span>Tambah Transaksi</span>
        </a>
        <a href="riwayat_transaksi_kasir.php" class="nav-item flex items-center space-x-3 px-4 py-3 rounded-lg <?= $current_page == 'riwayat_transaksi_kasir.php' ? 'bg-white bg-opacity-20' : '' ?> text-white transition hover:bg-white hover:bg-opacity-20">
            <i class="fas fa-list w-5"></i>
            <span>Riwayat Transaksi</span>
        </a>
        <a href="barang_terlaris_kasir.php" class="nav-item flex items-center space-x-3 px-4 py-3 rounded-lg <?= $current_page == 'barang_terlaris_kasir.php' ? 'bg-white bg-opacity-20' : '' ?> text-white transition hover:bg-white hover:bg-opacity-20">
            <i class="fas fa-fire w-5"></i>
            <span>Barang Terlaris</span>
        </a>
    </nav>

    <div class="absolute bottom-0 left-0 right-0 p-4 border-t border-white border-opacity-20">
        <div class="bg-white bg-opacity-20 rounded-lg p-3 mb-3">
            <p class="text-xs text-white text-opacity-75">Pengguna</p>
            <p class="font-semibold text-sm"><?= htmlspecialchars($_SESSION['username']) ?></p>
        </div>
        <a href="logout.php" class="w-full block text-center px-4 py-2 bg-red-500 hover:bg-red-600 rounded-lg text-white font-semibold transition">
            <i class="fas fa-sign-out-alt me-2"></i>Logout
        </a>
    </div>
</div>

<style>
    .gradient-primary { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
</style>